<?php

namespace App\Http\Controllers\Admin\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Auth;
use Session;
use App\user;
class LoginController extends Controller
{
  public function __construct(){
    //$this->middleware('guest:admin', ['except' => ['logout']]);
  }
  public function ShowLoginForm(){
    $this->logout();
    $data['title'] = 'Login';
    return view('admin/login',$data);
  }

    public static function notification_list_by_id($id,$type=''){
        $response_array = array();
        $query = DB::table('notifications')
            ->select('*','u_1.username as to_name','u_2.username as from_name');
        $query->where('to', $id);
        $query->join('users as u_1','notifications.to', '=','u_1.id');
        $query->join('users as u_2','notifications.from', '=','u_2.id');
        //$query->whereRaw('JSON_EXTRACT(`data`, \'$.to\') = ' . $id);
        //$query->where('data->to', $id);
        if($type == 'all'){
        }else{
            $query->whereNull('read_at');
        }
        $result = $query->get();
        return $result;
    }
  public function login(Request $request) {
    $this->validate($request, [
      'email' => 'required|email',
      'password' => 'required'
    ]);
    //Attempt to login to the user
    if ( Auth::guard('admin')->attempt(['email' => $request->email, 'password' => $request->password ,'role' => 1], $request->remember) ) {
      $id = Auth::guard('admin')->user()->id;
      $logs = array(
        'user_id'=> $id,
        'login_time'=> date('Y-m-d H:i:s'),
        'network_address'=> $request->ip(),
        'browser_information'=> $request->header('User-Agent'),
      );
      $user_model = new User;
      $user_model->set_login_logs($id,$logs);
      return redirect(url('/admin/dashboard'));
    }else{
      Session::flash('error', 'Please enter correct email address or password!');
      return redirect('admin/login')->withInput($request->only('email', 'remember'));
    }
  }
  public function logout()
  {
    if (Auth::guard('admin')->check()) {
      $id = Auth::guard('admin')->user()->id;
      $logs = array(
        'logout_time'=> date('Y-m-d H:i:s'),
    
      );
      $user_model = new User;
      $user_model->set_login_logs($id,$logs);
    }
    Auth::guard('admin')->logout();
    return redirect('admin/login');
  }

}
