<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Notifications\MyNotification;
use Auth;
use App\User;
use App\ProductCategory;
use DB;
use Session;
Use Mail;
Use Validator;
use Crypt;

class CategoryController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->user_model = new User;
    }
    public function category_list(){
        $data['title'] = "Category List";
        $category_model = new ProductCategory;
        $data['category'] = $category_model->category_list();
        //print_r($data);exit;
        return view('admin.category_list', $data);

    }
    public function add_category(Request $request){
        $data['title'] = "Add Category";
        return view('admin.category_add', $data);

    }
    public function edit_category(Request $request){
        $data['title'] = "Edit Category";
        $decryp_id = Crypt::decryptString($request->id);
        $category_model = new ProductCategory;
        $data['category'] = $category_model->category_detail_by_id($decryp_id);
        return view('admin.category_edit', $data);

    }
    public function edit_category_post(Request $request){
        $id = $request->category_id;
        $name = $request->name;
        $type = $request->action_type;
        $category_model = new ProductCategory;
        if($type == 'edit'){
            if($category_model->is_category_exist($name, $id)){
               $response['status'] = false;
               $response['msg'] ='Category name is already exist!';
               return json_encode($response);
            }
            $param = array(
                'name' => $name,
                'updated_at' => date('Y-m-d H:i:s')
            );
            DB::table('product_category')->where('category_id',$id)->update($param);
            Session::flash('success', 'Data updated successfully!');
            $response['status'] = true;
        }else{
            if($category_model->is_category_exist($name)){
               $response['status'] = false;
               $response['msg'] ='Category name is already exist!';
               return json_encode($response);
            }
            $param = array(
                'name' => $name,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            );
            DB::table('product_category')->insert($param);
            Session::flash('success', 'Category added successfully!');
            $response['status'] = true;
        }
        return json_encode($response);

    }
    public function delete_category(Request $request){
        $id = $request->id;
        $product_model = new ProductCategory;
        if($product_model->is_category_used($id)){
            $response['status'] = false;
            $response['msg'] ='You can not delete it.It is used by product.!';
            //Session::flash('error', 'You can not delete it.Its is used by someone!');
            return json_encode($response);
        }
        if(DB::table('product_category')->where('category_id', '=', $id)->delete()){
            $response['status'] = true;
            Session::flash('success', 'Category has been deleted successfully!');
        }else{
            $response['status'] = false;
            //Session::flash('error', 'Internal server error!');
            $response['msg'] ='Internal server error!';
        }
        return json_encode($response);
    }
}
