<?php

namespace App\Http\Controllers\Admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Session;
use App\Country;
use App\City;
use App\State;
use App\User;
use Auth;
use Hash;
class ProfileController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->user_model = new User;
    }
    public function profile(Request $request){
        $id = Auth::guard('admin')->user()->id;
        $user_details = $this->user_model->get_user_details_by_id($id);
        $data['user'] = $user_details;
        $data['title'] = "Admin Profile";
        $data['meta_description'] = "";
        return view('admin.profile',$data);
    }
    public function profile_post(Request $request){
        $user_id =  Auth::guard('admin')->user()->id;;
        if($request->hasFile('profile_pic')) {
          $filenameWithExt = $request->file('profile_pic')->getClientOriginalName();
          $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
          $extension = $request->file('profile_pic')->getClientOriginalExtension();
          $fileNameToStore = $filename.'_'.time().'.'.$extension;
          $destinationPath = public_path('profile_img');
          $request->file('profile_pic')->move($destinationPath, $fileNameToStore);
          $profile_image = asset("/public/profile_img/".$fileNameToStore);
        }else{
          $profile_image = $request->old_profile_pic;
        }
        $param = array(
        'first_name'=>$request->first_name,
        'last_name' =>$request->last_name,
        'phone' =>$request->mobile,
        'profile_picture' =>$profile_image,
        'created_at' => date("Y-m-d h:i:s"),
        'updated_at' => date("Y-m-d h:i:s"),
        );
        //print_r($param);exit;
        DB::table('users')->where('id', $user_id)->update($param);
        Session::flash('success', 'Data updated successfully!');
        return redirect(url('admin/profile'));
    }
    public function change_password(){
        $data['title'] = "Admin Change Password";
        $data['meta_description'] = "";
        return view('admin.changepassword',$data);
    }
    public function change_password_post(Request $request){
        $id = Auth::guard('admin')->user()->id;
        $conf_pass = trim($request->password_confirmation);
        $password = trim($request->new_password);
        $old_password = trim($request->old_password);
        $user = User::find($id);
        if(!Hash::check($old_password, $user->password)){
            Session::flash('error', 'Old password is wrong!');
            return back()->withInput();
        }
        if($password != $conf_pass){
            Session::flash('error', 'Password and confirm password is mismatch!');
            return back()->withInput();
        }
        $param = array(
            'password' => Hash::make($password),
            'created_at' => date("Y-m-d h:i:s"),
            'updated_at' => date("Y-m-d h:i:s"), 
        );
        DB::table('users')->where('id', $id)->update($param);
        Session::flash('success', 'Password updated successfully!');
         return redirect(url('admin/change-password'));
    }
}
