<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Notifications\MyNotification;
use Auth;
use App\User;
Use App\Pages;
use App\ReportedReasons;
use DB;
use Session;
Use Mail;
Use Validator;
use Crypt;

class SettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->user_model = new User;
        $this->pages_model = new Pages;
    }
    public function pages($pages)
    {
        $page_content = $this->pages_model->get_pages_by_type(strtolower($pages));
        $data['title'] = ucfirst($pages);
        $data['type'] = $pages;
        $data['meta_description'] = "";
        $data['page_content'] =  $page_content ;
        return view('admin.page_setting',$data);
    }
    public function pages_post(Request $request){
        $rules = array(
            'name' => 'required',
            'title' =>  'required',
            'page_content' =>  'required',
        );
        $validator = Validator::make($request->all(),$rules);
        if($validator->fails()){
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }
        $param = array(
            'name' =>trim($request->name),
            'title' =>trim($request->title),
            'content' =>trim($request->page_content),
            
        );
        $type = $request->type;
        $date = date('Y-m-d H:i:s');
        if($this->pages_model->is_page_exist($type)){
            $param['updated_at'] = $date;
            DB::table('pages')->where('type',$type)->update($param);
            Session::flash('success', 'Page content has been updated successfully!');
        }else{
            $param['type'] = $type;
            $param['created_at'] = $date;
            $param['updated_at'] = $date;
            DB::table('pages')->insert($param);
            Session::flash('success', 'Page content has been added successfully!');
        }
        return redirect(url('admin/setting/'.$type));
    }
    public function flagged_reason_list(){
        $data['title'] = "Reason List";
        $resons_model = new ReportedReasons;
        $data['reasons'] = $resons_model->reasons_list();
        return view('admin.reason_list', $data);

    }
    public function delete_reason(Request $request){
        $id = $request->id;
        $reported_reason_model = new ReportedReasons;
        if($reported_reason_model->is_reason_used($id)){
            $response['status'] = false;
            $response['msg'] ='You can not delete it.Its is used by someone!';
            //Session::flash('error', 'You can not delete it.Its is used by someone!');
            return json_encode($response);
        }
        if(DB::table('reported_reason')->where('serial_number', '=', $id)->delete()){
            $response['status'] = true;
            Session::flash('success', 'Data has been deleted successfully!');
        }else{
            $response['status'] = false;
            //Session::flash('error', 'Internal server error!');
            $response['msg'] ='Internal server error!';
        }
        return json_encode($response);
    }
    public function edit_reason(Request $request){
        $data['title'] = "Edit Reason";
        $decryp_id = Crypt::decryptString($request->id);
        $resons_model = new ReportedReasons;
        $data['reasons'] = $resons_model->reason_detail_by_id($decryp_id);
        return view('admin.reason_edit', $data);

    }
    public function add_reason(Request $request){
        $data['title'] = "Add Reason";
        return view('admin.reason_add', $data);

    }
    public function edit_reason_post(Request $request){
        $id = $request->reason_id;
        $name = $request->reason;
        $type = $request->action_type;
        if($type == 'edit'){
            $param = array(
                'name' => $name,
                'updated_at' => date('Y-m-d H:i:s')
            );
            DB::table('reported_reason')->where('serial_number',$id)->update($param);
            Session::flash('success', 'Data updated successfully!');
            $response['status'] = true;
        }else{
            $param = array(
                'name' => $name,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            );
            DB::table('reported_reason')->insert($param);
            Session::flash('success', 'Data added successfully!');
            $response['status'] = true;
        }
        return json_encode($response);

    }

}
