<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Notifications\MyNotification;
use Auth;
use App\User;
use App\ProductCategory;
use App\ProductSubcategory;
use DB;
use Session;
Use Mail;
Use Validator;
use Crypt;

class SubcategoryController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->user_model = new User;
    }
    public function subcategory_list(){
        $data['title'] = "Subcategory List";
        $subcategory_model = new ProductSubcategory;
        $data['subcategory'] = $subcategory_model->subcategory_list();
        //print_r($data);exit;
        return view('admin.subcategory_list', $data);

    }
    public function add_subcategory(Request $request){
        $data['title'] = "Add Subcategory";
        $category_model = new ProductCategory;
        $data['category'] = $category_model->category_list();
        //print_r($data);exit;
        return view('admin.subcategory_add', $data);

    }
    public function edit_subcategory(Request $request){
        $data['title'] = "Edit Category";
        $decryp_id = Crypt::decryptString($request->id);
        $category_model = new ProductCategory;
        $data['category'] = $category_model->category_list();
        $subcategory_model = new ProductSubcategory;
        $data['subcategory'] = $subcategory_model->subcategory_details_by_id($decryp_id);
        //print_r($data);exit;
        return view('admin.subcategory_edit', $data);

    }
    public function edit_subcategory_post(Request $request){
        $id = $request->id;
        $category = $request->category;
        $name = $request->name;
        $type = $request->action_type;
        $subcategory_model = new ProductSubcategory;
        if($type == 'edit'){
            if($subcategory_model->is_subcategory_exist($name, $id)){
               $response['status'] = false;
               $response['msg'] ='subcategory name is already exist!';
               return json_encode($response);
            }
            $param = array(
                'category_id' => $category,
                'name' => $name,
                'updated_at' => date('Y-m-d H:i:s')
            );
            DB::table('product_subcategory')->where('subcategory_id',$id)->update($param);
            Session::flash('success', 'Data updated successfully!');
            $response['status'] = true;
        }else{
            if($subcategory_model->is_subcategory_exist($name)){
               $response['status'] = false;
               $response['msg'] ='Subcategory name is already exist!';
               return json_encode($response);
            }
            $param = array(
                'category_id' => $category,
                'name' => $name,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            );
            DB::table('product_subcategory')->insert($param);
            Session::flash('success', 'Subcategory added successfully!');
            $response['status'] = true;
            $response['msg'] = "Subcategory added successfully!";
        }
        return json_encode($response);

    }
    public function delete_subcategory(Request $request){
        $id = $request->id;
        $subcategory_model = new ProductSubcategory;
        if($subcategory_model->is_subcategory_used($id)){
            $response['status'] = false;
            $response['msg'] ='You can not delete it.It is used by product!';
            //Session::flash('error', 'You can not delete it.Its is used by someone!');
            return json_encode($response);
        }
        if(DB::table('product_subcategory')->where('subcategory_id', '=', $id)->delete()){
            $response['status'] = true;
            Session::flash('success', 'Subcategory has been deleted successfully!');
        }else{
            $response['status'] = false;
            //Session::flash('error', 'Internal server error!');
            $response['msg'] ='Internal server error!';
        }
        return json_encode($response);
    }
}
