<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use DB;
use App\User;
use App\Pages;
use App\ReportedReasons;
use App\Mail\admin_mails;
use App\Mail\fbmail;
use Mail;
use Auth;
use Session;
use Crypt;
use View;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('auth');
        //$this->middleware('auth',['except' => array('/')]);
        $this->product_model = new  Product;
        $this->user_model = new User;
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {
        $data['title'] = 'Gpages Home';
        $status = array(2,3);
        if ($request->ajax()) {
            $count_item = $request->count_item;
            $data['gpages'] = $this->product_model->get_top_gpages_by_status($status,$count_item);
            $view = View::make('gfects.ajax.landing_show_more_top_item',$data);
            $contents = $view->render();
            $response['status'] = true;
            $response['output'] = $contents ;
            $response['new_count_item'] = $count_item+count($data['gpages']);
            $response['msg'] = "Data found.";
            //$response['data'] = $data['gpages'];
            echo json_encode($response);
            exit;
        }else{
            $data['gpages'] = $this->product_model->get_top_gpages_by_status($status);
            return view('gfects.landing',$data);
        }
    }
    public function user_home()
    {
        $data = [
            'title' => 'G-Home',
            'meta_description' =>'Welcome to your Gfects user Home page.'
        ];
        return view('gfects.userHome', $data);
    }

    public function about()
    {
        $data['title'] = 'About';
        $pages_model = new Pages;
        $data['page_content'] =$pages_model->get_pages_by_type('about-us');
        //print_r($data);exit;
        return view('gfects.about', $data);
    }
    public function feedback()
    {
        $data = [
            'title' => 'G-Feedback',
        ];
        return view('gfects.feedback', $data);
    }
    //feedback form submit by user
    public function feedback_post(Request $request)
    {
        $request->validate([
            'name' => 'required|min:3|max:50',
            'email' => 'required|email',
            'message' => 'required|min:15|max:250'
        ]);
        
        $name = $request->name;
        $email = $request->email;
        $message = $request->message;
        $admin_id = $this->user_model->get_admin_id();
        $date = date("Y-m-d H:i:s");
        $param = array(
            'reciver_id' => $admin_id,
            'sender_name' => $name,
            'sender_email' => $email,
            'message' => $message,
            'created_at' => $date,
            'updated_at' => $date
        );
        //print_r($param);exit;
        $data = array(
          'to' => $email ,
          'from' => 'fb@gfects.com',
          'subject' => "Gfects web feedback",
          'msg' => 'email :'.$email.'<br>Name :'.$name.'<br>'.$message,
          'email' =>$email,
          'name' => $name,
        );

        Mail::to('info@gfects.com')
        ->queue(new fbmail($data));
        if( DB::table('feedback')->insert($param)){
            $response['status'] = true;
            $response['msg'] ="Thanks for filling out our feedback form!";

        }else{
            $response['status'] = false;
            $response['msg'] ="Internal server error";
        }
        Session::flash($response['status'], 'You have been register successfully!');
        
        $data = [
            'title' => 'feedback',
            'meta_description' => 'Send us your feedback',
            'thankyou4feedbckmsg' => 'thankyou4feedbckmsg',
        ];
        
        return view('layouts.thanksyou', $data);
    }
    
    public function support()
    {
        if(Auth::check()){
            $data = [
            'title' => 'Support',
        ];
        return view('gfects.support', $data);
        }else{
            Session::flash('error', 'Please login to send suport message!');
            return redirect('/');
        }
    }
    public function support_post(Request $request){
        $subject = $request->about;
        $message = $request->message;
        $user_model = new User;
        $admin_id = $user_model->get_admin_id();
        //echo $admin_id;exit;
        if(isset($message ) && !empty($message )){
            $param = array(
                'subject' => $subject,
                'message' => $message,
                'sender_id' => Auth::user()->id,
                'reciver_id' => $admin_id,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
            //send email
            $data = array(
              'to' => 'info@gfects.com' ,
              //'to' => 'ravindra@coretechies.com' ,
              'from' => Auth::user()->email,
              'subject' => "Gfects web support",
              'msg' => $message,
              'email' =>Auth::user()->email,
              'name' => Auth::user()->name,
            );
            Mail::send('email.web_support',$data, function($message) use ($data) {
               $message->to($data['to'])->subject($data['subject']);
               $message->from($data['from'],'Gfects');
            });
            if(DB::table('support')->insert($param)){
                $response['status'] = true;
                $response['msg'] = "Message sent successfully to support team.";
            }else{
                $response['status'] = false;
                $response['msg'] = "Internal server error.";
            }
        }else{
            $response['status'] = false;
            $response['msg'] = "Message can not be empty.";
        }
        echo json_encode($response);
        exit;
    }
    public function privacy()
    {
        $data['title'] = 'Privacy';
        $pages_model = new Pages;
        $data['page_content'] =$pages_model->get_pages_by_type('privacy');
        return view('gfects.privacy', $data);
    }
     public function terms()
    {
        $data['title'] = 'Terms';
        $pages_model = new Pages;
        $data['page_content'] =$pages_model->get_pages_by_type('terms');
        return view('gfects.terms', $data);
    }
    public function teams()
    {
        $data = [
            'title' => 'G-Teams',
            'meta_description' =>'Welcome to your Gfects Team page.'
        ];
        return view('gfects.team', $data);
    }
    public function apps()
    {
        $data['title'] = 'Apps';
        $pages_model = new Pages;
        $data['page_content'] =$pages_model->get_pages_by_type('apps');
        return view('gfects.app', $data);
    }
    public function buy()
    {
        $data = [
            'title' => 'G-Apps',
            'meta_description' =>'Welcome to your Gfects buy page.'
        ];
        return view('gfects.buy', $data);
    }
     public function how_to_use()
    {
        $data = [
            'title' => 'G-Apps',
            'meta_description' =>'Welcome to your Gfects buy page.'
        ];
        return view('gfects.howtouse', $data);
    }
    public function others()
    {
        $data = [
            'title' => 'G-Apps',
            'meta_description' =>'Welcome to your Gfects buy page.'
        ];
        return view('gfects.others', $data);
    }
    public function gpages_info($id){
        $data['title'] = 'Gpages Info';
        $product_model = new Product;
        $data['result'] = $product_model->product_details_by_id($id);
        $product_model->update_page_view($id);
        return view('gfects.gpages_info',$data);
    }
    public function gpages_info_new($id){
        $data['title'] = 'Gpages Info';
        $product_model = new Product;
        $data['result'] = $product_model->product_details_by_id($id);
        $product_model->update_page_view($id);
        return view('gfects.gpages_info_new',$data);
    }

    public function gpages_comment($id){
        $data['title'] = 'Gpages Info';
        return view('gfects.gpages_comment',$data);
    }
    public function search_gpages(Request $request){
        $data['title'] = 'Search Result';
        $status = array(2,3);
        $search_key = $request->search_key;
        $product_model = new Product;
        $data['gpages'] = $product_model->search_gpages($search_key);;
        //print_r($data);
        return view('gfects.search_gpages_list',$data);
    }
    public function reported_to_gpages(Request $request)
    {
        if(Auth::check()){
        $data['title'] = "Report Gpages";
        $page_id = $request->page_id;
        $decrypt_page_id = Crypt::decryptString($page_id);
        $data['gpage_name'] = $this->product_model->product_name_by_id($decrypt_page_id);
        $data['gpage_id'] = $decrypt_page_id;
        $resons_model = new ReportedReasons;
        $data['reasons'] = $resons_model->reasons_list();
        return view('gfects.reported', $data);
        }else{
            Session::flash('error', 'Please login first!');
            return redirect('/');
        }
    }
    public function reported_to_gpages_post(Request $request){
        $page_id = $request->gpage_id;
        $page_name = $request->gpage_name;
        $reason = $request->reason;
        $message = $request->message;
        $user_model = new User;
        $admin_id = $user_model->get_admin_id();
        if(isset($message ) && !empty($message )){
            $param = array(
                'product_id' => $page_id,
                'sender_id' =>  Auth::user()->id,
                'reciver_id' =>  $admin_id,
                'reason' => $reason,
                'description' => $message,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
            if(DB::table('reported_product')->insert($param)){
                $response['status'] = true;
                $response['msg'] = "Message sent successfully to Gfects team.";
            }else{
                $response['status'] = false;
                $response['msg'] = "Internal server error.";
            }
        }else{
            $response['status'] = false;
            $response['msg'] = "Message can not be empty.";
        }
        echo json_encode($response);
        exit;
    }
}
