<?php

namespace App\Http\Controllers;

use App\Post; ##to get post page data from database
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class PostController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = [
            'title' => 'Offical Web posts',
            'meta_description' => "Gfects' Offical Web posts",
            'posts' => Post::all()->sortByDesc('id'),
            'pages' => Post::orderBy('id', 'DESC')->paginate(5),
           // 'pages' => DB::table('posts')->paginate(5),
        ];
        //dd($data);
       return view('layouts.posts', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Post  $post
     * @return \Illuminate\Http\Response
     */
    //public function show(Post $post)
    public function show($id='1', $slug = '')
    {
        $post_db = post::findOrFail($id);
        $data = [
            'post' => $post_db,
            'title' => $post_db->short_title,
            'meta_description' => $post_db->title,
        ];

        /*if ($slug !== $post_db->slug) {
            return redirect()->to($post_db->url);
        }
        dd($data);*/

       return view('layouts.post', $data)
            ->withCanonical($post_db->url);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Post  $post
     * @return \Illuminate\Http\Response
     */
    public function edit(Post $post)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Post  $post
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Post $post)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Post  $post
     * @return \Illuminate\Http\Response
     */
    public function destroy(Post $post)
    {
        //
    }
}
