<?php

namespace App\Http\Controllers\User\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Auth;
use Illuminate\Http\Request;
use Session;
use DB;
use App\user;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {

    }

    public function ShowLoginForm(){
        $data = [
            'title' => 'Log in',
            'meta_description' => 'Log into your account or Create a new account'
        ];
        Auth::guard('web')->logout();
        return view('users.auth.login',$data);
    }
    #This function
    public function logout()
    {
        if (Auth::guard('web')->check()) {
            $id = Auth::guard('web')->user()->id;
            $logs = array(
                'logout_time'=> date('Y-m-d H:i:s'),

            );
            $user_model = new User;
            $user_model->set_login_logs($id,$logs);
        }
        Auth::guard('web')->logout();
        return redirect('/');
    }
    #this function is used for login

    public function login(Request $request)
    {
        if ( Auth::guard('web')->attempt(['email' => $request->email, 'password' => $request->password], $request->remember) ) {
            #check user is verified or not
            $user_id = Auth::guard('web')->user()->id;
            $user_role = Auth::guard('web')->user()->role;
            $status = Auth::guard('web')->user()->status;
            if(!$this->is_verified($user_id)){
                Session::flash('error', 'Your  account is not verified!');
                Auth::guard('web')->logout();
                return redirect()->back()->withInput($request->only('email', 'remember'));
            }
            if($status == 0){
                Session::flash('error', 'Your account is not approved!');
                Auth::guard('web')->logout();
                return redirect()->back()->withInput($request->only('email', 'remember'));
            }elseif ($status == 2) {
                Session::flash('error', 'Your  account is suspended.Please contact to admin!');
                Auth::guard('web')->logout();
                return redirect()->back()->withInput($request->only('email', 'remember'));
            }elseif ($status == 3) {
                Session::flash('error', 'Your  account is on hold.Please contact to admin!');
                Auth::guard('web')->logout();
                return redirect()->back()->withInput($request->only('email', 'remember'));
            }elseif ($status == 4) {
                Session::flash('error', 'Your  account is deleted.Please contact to admin!');
                Auth::guard('web')->logout();
                return redirect()->back()->withInput($request->only('email', 'remember'));
            }
            $id = Auth::guard('web')->user()->id;
            $logs = array(
                'user_id'=> $id,
                'login_time'=> date('Y-m-d H:i:s'),
                'network_address'=> $request->ip(),
                'browser_information'=> $request->header('User-Agent'),
            );
            $user_model = new User;
            $user_model->set_login_logs($id,$logs);
            if($user_role == 1){
                return redirect()->intended(url('admin/dashboard'));
            }else if($user_role == 2){
                return redirect()->intended(url('creator/dashboard'));
            }else if($user_role == 3){
                return redirect()->intended(url('user/home'));
            }
        }else{
            Session::flash('error', 'Incorrect email or password');
            return redirect()->back()->withInput($request->only('email', 'remember'));
        }
    }
    #this function is used for check user is verified or not
    public function is_verified($user_id){
        $user_verify=User::find($user_id);

        if($user_verify){
            if(!empty($user_verify->email_verified_at) || $user_verify->email_verified_at != ''){
                return true;
            }else{
                return false;
            }
        }else{
            return false;
        }
    }
    #this function is used for check user status is active or not
    public function is_active($user_id){
        $user_verify=User::find($user_id);
        if($user_verify){
            if($user_verify->status == 1){
                return true;
            }else{
                return false;
            }
        }else{
            return false;
        }
    }
    public function is_deleted($user_id){
        $user_verify=User::find($user_id);
        if($user_verify){
            if($user_verify->status == 4){
                return true;
            }else{
                return false;
            }
        }else{
            return false;
        }
    }
}
