<?php
namespace App\Http\Middleware;
use Illuminate\Support\Facades\Auth;
use Closure;
class IsAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next){
        if (Auth::guard('admin')->check()) {
            $role = Auth::guard('admin')->user()->role;
            if ($role &&  $role == 1) {
                return $next($request);
            }
            Auth::guard('admin')->logout();
            return redirect('admin/login')->with('error','You have not permistion to access admin panel.');
        }else{
           Auth::guard('admin')->logout(); 
           return redirect('admin/login');
        }
    }
}