<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;

class ProductSubcategory extends Model
{
    protected $table = 'product_subcategory';

    public function subcategory_by_category_id($id)
    {
    	//$result = DB::table('product_subcategory')->select('name', 'subcategory_id')->where('category_id', $id)->get();
    	$result = ProductSubcategory::select('name','subcategory_id')->where('category_id', $id)->get();
    	return $result;
    }
    public function subcategory_list(){
		$result = DB::table('product_subcategory')
		->select('product_subcategory.subcategory_id as id','product_subcategory.name','product_subcategory.created_at','product_category.name as category')
		->join('product_category','product_category.category_id','=','product_subcategory.category_id')
		->get();
		 return $result;
	}
	public function is_subcategory_used($id)
	{
		$result=DB::table('product')->select('id')
		->where('subcategory_id',$id)
		->get();
	    if(count($result)>0){
	        return true;
	    }else{
	        return false;
	    }
	}
	public function is_subcategory_exist($name,$id='')
	{
		$query=DB::table('product_subcategory')->select('subcategory_id')
		->where('name',$name);
		if(!empty($query)){
			$query->where('subcategory_id','!=',$id);
		}
		$result = $query->get();
	    if(count($result)>0){
	        return true;
	    }else{
	        return false;
	    }
	}
	public function subcategory_details_by_id($id){
		$result = DB::table('product_subcategory')
		->select('product_subcategory.subcategory_id as id','product_subcategory.name','product_subcategory.created_at','product_category.name as category','product_subcategory.category_id')
		->join('product_category','product_category.category_id','=','product_subcategory.category_id')
		->where('product_subcategory.subcategory_id',$id)
		->get();
		 return $result;
	}
}
