<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Facades\DB;


class User extends Authenticatable implements MustVerifyEmail
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];


    public function get_user_info_by_id($id){
        $result = DB::table('users as u')
            ->select('u.*','ud.*','c.name as country','s.name as state')
            ->where('u.id', $id)
            ->leftJoin('user_details as ud', 'ud.user_id', '=', 'u.id')
            ->leftJoin('countries as c','c.id','=','u.country')
            ->leftJoin('states as s','s.id','=','u.state')
            ->get();
        return $result;
    }

    public function set_login_logs($id,$data){

    }

    public function get_recent_user_list($limit=''){
        $query = DB::table('users as u')
            ->select('u.*','ud.account_type','ud.account_type','ud.company_phone')
            ->whereIn('role',[2,3])
            ->leftJoin('user_details as ud', 'ud.user_id', '=', 'u.id')
            ->orderBy('created_at', 'desc');
        if(!empty($limit)){
            $query->take(5);
        }
        $result = $query->get();
        return $result;
    }


    public static function get_last_login($id){
        $result = DB::table('login_logs')->select('login_time','logout_time')->where('user_id', $id)->get();
        if(count($result)){
            return $result[0]->logout_time;
        }else{
            return false;
        }
    }
    public static function notification_list_by_id($id,$type=''){
        $response_array = array();
        $query = DB::table('notifications')
            ->select('*','u_1.username as to_name','u_2.username as from_name');
        $query->where('to', $id);
        $query->join('users as u_1','notifications.to', '=','u_1.id');
        $query->join('users as u_2','notifications.from', '=','u_2.id');
        //$query->whereRaw('JSON_EXTRACT(`data`, \'$.to\') = ' . $id);
        //$query->where('data->to', $id);
        if($type == 'all'){
        }else{
            $query->whereNull('read_at');
        }
        $result = $query->get();
        return $result;
    }

    public function get_user_details_by_id($id){
        $result = DB::table('users')
            ->select('users.*','user_details.*','countries.name as country','states.name as state')
            ->where('users.id', $id)
            ->leftJoin('countries','countries.id','=','users.country')
            ->leftJoin('states','states.id','=','users.state')
            ->leftJoin('user_details', 'user_details.user_id', '=', 'users.id')
            ->get();
        return $result;
    }

    public function get_user_details_by_product_id($id){
        $result = DB::table('product as p')
            ->select('u.*','ud.*','c.name as country','s.name as state')
            ->where('p.id', $id)
            ->join('users as u','p.user_id', '=','u.id')
            ->leftJoin('countries as c','c.id','=','u.country')
            ->leftJoin('states as s','s.id','=','u.state')
            ->leftJoin('user_details as ud', 'ud.user_id', '=', 'u.id')
            ->get();
        return $result;
    }
    public function get_admin_id(){
        $result = DB::table('users as u')->select('u.id')->where('u.role', 1)->get();
        if(count($result)){
            return $result[0]->id;
        }else{
            return false;
        }
    }

    public static function account_type($id)
    {
        $result = DB::table('user_details')
            ->select('account_type')
            ->where('user_id', $id)
            ->get();
        if(count($result)>0){
            return $result[0]->account_type;
        }else{
            return false;
        }
        //return $this->hasOne('App\UserDetails');
    }

    public static function get_user_activity_by_user_id($id){
        $result = DB::table('user_activity')
            ->select('user_activity.serial_number','user_activity.activity','user_activity.type','user_activity.created_at')
            ->where('user_activity.user_id', $id)
            ->join('users as u','user_activity.user_id', '=','u.id')
            ->orderBy('created_at', 'desc')
            ->get();
        return $result;
    }

    public function user_profile_pic_by_email($email){
        $result = DB::table('users as u')->select('u.profile_picture')->where('u.email',$email)->get();
        if(count($result)){
            return $result[0]->profile_picture;
        }else{
            return false;
        }
    }



}
