@extends('layouts.admin')
@section('content')
<div class="main">
   <div class="subheader">
      <ul>
         <li>Admin</li>
      </ul>
   </div>
   <!-- MAIN CONTENT -->
   <div class="main-content">
      <div class="container-fluid">
         <!-- END OVERVIEW -->
         <div class="row">
            <div class="col-md-12">
               <!-- RECENT PURCHASES -->
               <form class="col-md-12 form-panel" style="border:0"  method="POST" action="{{ url('admin/profile') }}" enctype="multipart/form-data" id="basic-details-frm">
                  <div class="row">
                     <div class="panel new-panel">
                        <div class="panel-heading">
                           <div class="col-md-12">
                              <h3 class="panel-title">Profile Setting</h3>
                           </div>
                           <br>
                        </div>
                        <div class="notice-area">
                           @include('admin.alert_message')
                        </div>
                        <input type="hidden" name="user_id" value="<?=$user?$user[0]->id:''?>">
                        <input type="hidden" name="old_profile_pic" value="<?=$user?$user[0]->profile_picture:''?>">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="panel-body no-padding">
                           <div class="col-md-4">
                              <label>First Name<span class="required">*</span></label>
                              <input class="form-control" value="<?=$user?$user[0]->first_name:''?>" type="text" id="first_name" name="first_name">
                              @if ($errors->has('first_name'))
                                 <span class="invalid-feedback" role="alert">
                                    <strong>{{ $errors->first('first_name') }}</strong>
                                 </span>
                              @endif
                              <br>
                           </div>
                           <div class="col-md-4">
                              <label>Last Name<span class="required">*</span></label>
                              <input class="form-control" value="<?=$user?$user[0]->last_name:''?>" type="text" id="last_name" name="last_name">
                              <br>
                              @if ($errors->has('last_name'))
                                 <span class="invalid-feedback" role="alert">
                                    <strong>{{ $errors->first('last_name') }}</strong>
                                 </span>
                              @endif
                           </div>
                            <div class="col-md-4">
                              <label>Mobile Number<span class="required">*</span></label>
                              <input class="form-control"  type="text" id="mobile" name="mobile" value="<?=$user?$user[0]->phone:''?>">
                              <br>
                              @if ($errors->has('mobile'))
                                 <span class="invalid-feedback" role="alert">
                                    <strong>{{ $errors->first('mobile') }}</strong>
                                 </span>
                              @endif
                           </div>
                           <div class="clearfix"></div>
                           <hr>
                           <div class="col-md-4">
                              <label>Email<span class="required">*</span></label>
                              <input class="form-control"  type="text" id="email" name="email" value="<?=$user?$user[0]->email:''?>" readonly>
                              <br>
                              @if ($errors->has('email'))
                                 <span class="invalid-feedback" role="alert">
                                    <strong>{{ $errors->first('email') }}</strong>
                                 </span>
                              @endif
                           </div>
                           <div class="col-md-4">
                              <label>User Name<span class="required">*</span></label>
                              <input class="form-control"  type="text" id="username" name="username" value="<?=$user?$user[0]->username:''?>" readonly>
                              <br>
                              @if ($errors->has('username'))
                                 <span class="invalid-feedback" role="alert">
                                    <strong>{{ $errors->first('username') }}</strong>
                                 </span>
                              @endif
                           </div>
                           <div class="clearfix"></div>
                           <hr>
                           <div class="col-md-12">
                              <fieldset class="form-group">
                                 <a href="javascript:void(0)" onclick="$('#profile_pic').click()">Upload profile Image</a>
                                 <input type="file" id="profile_pic" name="profile_pic" style="display: none;" class="form-control" onchange="readURL(this,'','profile_pic_preview')">
                              </fieldset>
                              <div class="preview-images-zone">
                                 <img src="<?=$user?$user[0]->profile_picture:asset('profile_img/no_image.png')?>" height="150px" width="200px;" id="profile_pic_preview">
                              </div>
                           </div>
                           <div class="clearfix"></div>
                        </div>
                        <div class="panel-footer">
                           <div class="row">
                              <div class="col-md-12 text-right"><input type="submit" name="Submit" class="btn btn-primary" value="Submit"></div>
                           </div>
                        </div>
                     </div>
                  </div>
               </form>
               <!-- END RECENT PURCHASES -->
            </div>
         </div>
      </div>
   </div>
   <!-- END MAIN CONTENT -->
</div>
<script type="text/javascript">
   $(document).ready(function(){
     //basic details form submit
      $('form[id="basic-details-frm"]').validate({
          rules: {
            first_name: 'required',
            last_name: 'required',
            email: 'required',
            mobile: 'required',
            username: 'required',
          },
          messages: {
            first_name: 'Please enter first name.',
            last_name: 'Please enter last name.',
            email: 'Please enter email.',
            mobile: 'Please enter mobile.',
            username: 'Please enter username',
          },
         submitHandler: function(form) {
            form.submit();
            /*frm = $('#basic-details-frm');
            $.ajax({
              type: "POST",
              url: site_url+"/account/setting1",
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              },
              data: frm.serialize(),
              success: function(res){
                 //$("#loader_img_product_update").css('display','none');
                 var data = jQuery.parseJSON(res);
                 if(data.status){
                    toastr.success(data.msg);
                 }else{
                    toastr.error(data.msg);
                 }
              }
            });*/
         }
      });
   });
</script>
@endsection
