@extends('layouts.admin')
@section('content')
<div class="main">
   <div class="subheader">
      <ul>
         <li>Admin</li>
      </ul>
   </div>
   <!-- MAIN CONTENT -->
   <div class="main-content">
      <div class="container-fluid">
         <!-- END OVERVIEW -->
         <div class="row">
            <div class="col-md-12">
               <!-- RECENT PURCHASES -->
               <form class="col-md-12 form-panel" style="border:0"  method="POST" action="" enctype="multipart/form-data" id="feedback_frm">
                  <div class="row">
                     <div class="panel new-panel">
                        <div class="panel-heading">
                           <div class="col-md-12">
                              <h3 class="panel-title">Add Reason</h3>
                           </div>
                           <br>
                        </div>
                        <div class="notice-area">
                           @include('admin.alert_message')
                        </div>
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="panel-body no-padding">
                           <div class="col-md-8">
                              <label>Reason<span class="required">*</span></label>
                             <textarea id="reason" name="reason" class="form-control" rows="5"></textarea>
                              <br>
                              <input type="hidden" name="action_type" value="add">
                           </div>
                        </div>
                        <div class="panel-footer">
                           <div class="row">
                              <div class="col-md-12 text-right">
                              <a href="{{ redirect()->back()->getTargetUrl() }}" class="btn btn-primary">Back</a>
                              <button type="Submit" class="btn btn-primary" id="reply_btn">Submit</button>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </form>
               <!-- END RECENT PURCHASES -->
            </div>
         </div>
      </div>
   </div>
   <!-- END MAIN CONTENT -->
</div>
<script type="text/javascript">
  $(document).ready(function(){
    $('form[id="feedback_frm"]').validate({
        rules: {
          reason: 'required',
        },
        messages: {
          reason: 'Please enter reason description',
        },
        submitHandler: function(form) {
          //form.submit();
          $("#reply_btn").attr("disabled", true);
          frm = $('#feedback_frm');
          $.ajax({
            type: "POST",
            url: site_url+"/admin/flagged/edit-reason",
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: frm.serialize(),
            success: function(res){
               var data = jQuery.parseJSON(res);
               if(data.status){
                  setTimeout(function(){
                     window.location=site_url+"/admin/flagged/reason-list";
                  }, 900);
               }else{
                  toastr.error(data.msg);
               }
               $("#reply_btn").attr("disabled", false);
            }
          });
        }
      });
  });
</script>
@endsection
