<?php
use App\State;
?>
@extends('layouts.admin')
@section('content')
    <div class="main">
        <div class="subheader">
            <ul>
                <li>Admin</li>
            </ul>
        </div>
        <!-- MAIN CONTENT -->
        <div class="main-content">
            <div class="container-fluid">
                <!-- END OVERVIEW -->
                <div class="container emp-profile">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="profile-img">
                                @if($user[0]->profile_picture!="")
                                    <img width="200px" height="200px" src="{{$user[0]->profile_picture}}" alt="" />
                                 @else
                                    <img width="200px" height="200px" src="{{asset('/public/img/G-logo-3.png')}}" alt="" />
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="profile-head">
                                <h5><small>First name</small> <?=$user?$user[0]->first_name:''?><small>last name</small> <?=$user?$user[0]->last_name:''?></h5>
                                <h6>
                                    <small>Account type :</small>
                                    @if($user[0]->account_type == 1)
                                        <span class="label label-success">Publisher</span>
                                    @elseif($user[0]->account_type == 2)
                                        <span class="label label-success">Agency</span>
                                    @elseif($user[0]->account_type == 3)
                                        <span class="label label-success">Business</span>
                                    @else
                                        <span class="label label-success">User</span>
                                    @endif
                                </h6>
                                <p>
                                    <strong>Profile stats : </strong>
                                </p>
                                <p>
                                    email : <span class="badge bg-primary">{{$emailverfy}}</span>
                                    <br>
                                    Biz Verification : <span class="badge bg-info">paid</span> mark as:
                                    <!-- <select class="custom-select d-block w-100" id="country" required="">
                                        <option value="">Choose...</option>
                                        <option>verified</option>
                                    </select> -->
                                    <button type="button" class="btn btn-warning" data-user_id="{{$user[0]->id}}" data-email_id="{{$user[0]->email}}" data-verify_status="0" id="{{$user[0]->id}}_div_action">Warning</button>
                                    <br>
                                    Flags : <span class="badge bg-warning">{{$flagCount}}</span>
                                    <br>
                                    G-pages : <span class="badge bg-success">{{$gpageCount}}</span>
                                </p>

                                <p class="proile-rating">like : <span>8/10</span></p>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <select class="form-control common_action" style="border-radius: 1px" name="common_action" data-user_id="{{$user[0]->id}}" data-email_id="{{$user[0]->email}}" data-status="{{$user[0]->status}}" id="{{$user[0]->id}}_div_action">
                                <option value="">Choose</option>
                                <option value="1" <?= $user[0]->status == 1?'selected=selected':''?>>
                                    Approved
                                </option>
                                <option value="2" <?= $user[0]->status == 2?'selected=selected':''?>>
                                    Hold
                                </option>
                                <option value="3" <?= $user[0]->status == 3?'selected=selected':''?>>
                                    Suspend
                                </option>
                                <option value="4" <?= $user[0]->status == 4?'selected=selected':''?>>
                                    Delete
                                </option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="profile-work">
                                <p><small>User Name</small></p>
                                <p> <?=$user?$user[0]->username:''?></p>
                                <br/>
                                <p><small>email</small></p>
                                <p> <?=$user?$user[0]->email:''?></p>
                                <br/>
                                <p><small>Dob</small></p>
                                <p> <?=$user?$user[0]->date_of_birth:''?></p>
                                <br/>
                                <p><small>Country</small></p>
                                <p> <?=$user?$user[0]->country:''?></p>
                                <br/>
                                <p><small>State</small></p>
                                <p> <?=$user?$user[0]->state:''?></p>
                                <br/>
                            </div>
                        </div>
                        <div class="col-md-8">
                            @if($user[0]->account_type == 2 || $user[0]->account_type == 3)
                                <ul class="nav nav-tabs" id="myTab" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Company</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Gpages</a>
                                    </li>
                                </ul>
                                <div class="tab-content" id="myTabContent">
                                    <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                                        <div class="clearfix"></div>
                                        <hr>
                                        @if($user[0]->company_name)
                                        <div class="col-md-3">
                                            <label>company Name<span class="required">*</span></label>
                                            <input class="form-control" value="<?=$user?$user[0]->company_name:''?>" type="text" readonly>
                                            <br>
                                        </div>
                                        <div class="col-md-3">
                                            <label>company Title<span class="required">*</span></label>
                                            <input class="form-control" value="<?=$user?$user[0]->company_title:''?>" type="text" readonly>
                                            <br>
                                        </div>
                                        <div class="col-md-3">
                                            <label>company Street<span class="required">*</span></label>
                                            <input class="form-control" value="<?=$user?$user[0]->company_street:''?>" type="text" readonly>
                                            <br>
                                        </div>
                                        <div class="col-md-3">
                                            <label>company State<span class="required">*</span></label>
                                            <input class="form-control" value="<?=State::find($user[0]->company_state)->name?>" type="text">
                                            <br>
                                        </div>
                                        <div class="col-md-3">
                                            <label>company Country<span class="required">*</span></label>
                                            <input class="form-control" value="<?=\App\Country::find($user[0]->company_country)->name?>" type="text" readonly>
                                            <br>
                                        </div>
                                        <div class="col-md-3">
                                            <label>Zip<span class="required">*</span></label>
                                            <input class="form-control" value="<?=$user?$user[0]->company_zip:''?>" type="text" readonly>
                                            <br>
                                        </div>
                                        <div class="col-md-3">
                                            <label>company City<span class="required">*</span></label>
                                            <input class="form-control" value="<?=\App\City::find($user[0]->company_city)->name?>" type="text" readonly>
                                            <br>
                                        </div>
                                        <div class="col-md-3">
                                            <label>company Email<span class="required">*</span></label>
                                            <input class="form-control" value="<?=$user?$user[0]->company_email:''?>" type="text"  readonly>
                                            <br>
                                        </div>
                                        <div class="col-md-3">
                                            <label>company Phone<span class="required">*</span></label>
                                            <input class="form-control" value="<?=$user?$user[0]->company_phone:''?>" type="text"  readonly>
                                            <br>
                                        </div>
                                        @else
                                        <div class="col-md-3">
                                            <label>company Data<span class="required">*</span></label>
                                            <p>Company data is blank </p>
                                            <br>
                                        </div>
                                        @endif
                                    </div>
                                    <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                                        @endif
                                        <table class="table table-striped datatable">
                                            <thead>
                                            <tr>
                                                <th>#SN</th>
                                                <th>Product Name</th>
                                                <th>Barcode</th>
                                                <th>Last Updated</th>
                                                <th>Created At</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @if(count($gpages)>0)
                                                @foreach($gpages as $key => $value)
                                                    <tr>
                                                        <td></td>
                                                        <td><a target="_blank" href="{{url('admin/gpage-info/'.$value->id)}}"><?=$value->name?></a></td>
                                                        <td><?=$value->bar_code?></td>
                                                        <td><?=$value->updated_at?></td>
                                                        <td><?=$value->created_at?></td>
                                                        <td>
                                                            @if($value->status == 1)
                                                                <span class="label label-success">Draft</span>
                                                            @elseif($value->status == 2)
                                                                <span class="label label-info">Submitted</span>
                                                            @elseif($value->status == 3)
                                                                <span class="label label-success">Approved</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <select class="form-control common_action" style="border-radius: 1px" name="common_action" data-user_id="{{$value->id}}" data-email_id="{{$value->email}}" data-status="{{$value->status}}" id="{{$value->id}}_div_action" data-product_id="{{$value->id}}">
                                                                <option value="">Choose</option>
                                                                <option value="1" <?= $value->status == 3?'selected=selected':''?>>
                                                                    Approved
                                                                </option>
                                                                <option value="4" <?= $value->status == 4?'selected=selected':''?>>
                                                                    Reject
                                                                </option>
                                                                <option value="5">
                                                                    Delete
                                                                </option>
                                                            </select>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            @endif
                                            </tbody>
                                        </table>
                                        @if($user[0]->account_type == 2 || $user[0]->account_type == 3)
                                    </div>
                                    @endif
                                </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- END MAIN CONTENT -->
    </div>
    <script type="text/javascript">
        $(document).ready(function(){
            $('body').on('change', '.common_action', function(e) {
                var product_id = $(this).data('product_id');
                var user_id = $(this).data('user_id');
                var status = $("#"+user_id+"_div_action").val();
                var old_status = $(this).data('status');
                var email = $(this).data('email_id');
                var message = 'Are you sure ?';
                //alert("status is:"+status);
                if(status == "3"){
                    message = 'Are you sure want to  approved request?';
                }else if(status == "4"){
                    message = 'Are you sure want to reject approved request ?';
                }else if(status == "5"){
                    message = 'Are you sure want to delete G-page ?';
                }else{
                    return true;
                }
                if(product_id != "" || product_id != undefined){
                    bootbox.confirm({
                        message: message,
                        buttons: {
                            cancel: {
                                label: '<i class="fa fa-times"></i> Cancel'
                            },
                            confirm: {
                                label: '<i class="fa fa-check"></i> Confirm'
                            }
                        },
                        callback: function (result) {
                            if(result){
                                if(status == 4){
                                    $("#to").val(email);
                                    $("#user_id").val(user_id);
                                    $("#product_id").val(product_id);
                                    $("#subject").val('Your G-Page Review Feedback');
                                    $("#message").val('');
                                    $("#reject_request_model").modal("toggle");
                                    return true;
                                }
                                if(status == 5){
                                    $('#loader_img').css('display','block');
                                    $.ajax({
                                        type: "POST",
                                        url: "/admin/delete-gpages",
                                        headers: {
                                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                        },
                                        data: {product_id: product_id,status:status,user_id:user_id,email:email},
                                        success: function(res){
                                            $('#loader_img').css('display','none');
                                            var data = jQuery.parseJSON(res);
                                            if(data.status){
                                                //toastr.success(data.msg);
                                                setTimeout(function(){
                                                    window.location.reload();
                                                }, 900);

                                            }else{
                                                //toastr.error(data.msg);
                                                setTimeout(function(){
                                                    window.location.reload();
                                                }, 900);
                                            }
                                        }
                                    });
                                    return true;
                                }
                                $('#loader_img').css('display','block');
                                $.ajax({
                                    type: "POST",
                                    url: "/admin/update-gpages-status",
                                    headers: {
                                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                    },
                                    data: {product_id: product_id,status:status,user_id:user_id,email:email},
                                    success: function(res){
                                        $('#loader_img').css('display','none');
                                        var data = jQuery.parseJSON(res);
                                        if(data.status){
                                            //toastr.success(data.msg);
                                            setTimeout(function(){
                                                window.location.reload();
                                            }, 900);

                                        }else{
                                            //toastr.error(data.msg);
                                            setTimeout(function(){
                                                window.location.reload();
                                            }, 900);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            });
        });
    </script>
@endsection

