'@extends('layouts.main')
@section('content')
<style type="text/css">
  .error {
    color: red;
    margin-left: 5px;
  }
  .text-span{
    margin-left: 50px;
  }
</style>
<div>
    <div>
        <h3>Comment List</h3>
        <div>
            <table class="table table-striped">
                <thead>
                  <tr>
                    <th>SN</th>
                    <th>G-Page</th>
                    <th>Sender</th>
                    <th>Date</th>
                    <th>Reply Status</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  @if(count($comment_list))
                    @foreach($comment_list as $key=>$value)
                        <tr>
                            <td>{{$key+1}}</td>
                            <td>
                              <a href="{{url('creator/comment-exchange/'.$value->product_id)}}" id="comment_replay_btn1" data-id="{{$value->id}}" data-name="{{$value->sender_name}}" data-comment="{{$value->comment}}" data-reciver_id="{{$value->sender_id}}" data-reply_status="{{$value->reply_status}}">{{$value->product_name}}
                              </a>
                              </td>
                            <td>{{$value->sender_name}}</td>
                            <td>{{date("d M Y", strtotime($value->created_at))}}</td>
                            <td><span class="btn btn-{{$value->reply_status == 1 ?"success":"info"}}" style="width: 60px;padding: 0px;">{{$value->reply_status == 1 ?"Yes":"No"}}</span>
                            </td>
                            <td>
                                <a  style="font-size:18px" class="common_action" data-id="{{$value->id}}"><i class="fa fa-eye"></i></a>
                                <a  style="font-size:18px" class="delete_icon" data-id="{{$value->id}}"><i class="fa fa-trash"></i></a>
                            </td>
                        </tr>
                    @endforeach
                  @endif
              </table>
        </div>
    </div>
        <hr class="featurette-divider">
        @include('common.menu')
    </div>
    <div id="info_model" class="modal fade" role="dialog">
        <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header text-center">
            <h4 class="modal-title w-100 font-weight-bold">Comment</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close" data-model_id="comment_reply_model">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body mx-3">
            <div class="md-form mb-4">
              <label data-error="wrong" data-success="right" for="form29">Gpages:</label>
              <span id="product_name" class="text-span"></span>
            </div>
             <div class="md-form mb-4">
              <label data-error="wrong" data-success="right" for="form29">Creator:</label>
              <span id="reciver_name" class="text-span"></span>
            </div>
            <div class="md-form mb-4">
              <label data-error="wrong" data-success="right" for="form29">User:</label>
             <span id="sender_name" class="text-span"></span>
            </div>
            <div class="md-form mb-4">
              <label data-error="wrong" data-success="right" for="form34">Comment:</label>
              <span id="comment" class="text-span"></span>
            </div>
            <div class="md-form mb-4">
              <label data-error="wrong" data-success="right" for="form34">Reply:</label>
              <span id="span_reply_txt" class="text-span"></span>
            </div>
            <div class="md-form mb-4">
              <label data-error="wrong" data-success="right" for="form34">Time:</label>
              <span id="created_at" class="text-span"></span>
            </div>
            <!-- <div class="md-form">
               <label data-error="wrong" data-success="right" for="form8">Reply:</label>
              rejifg fkogkh kgkk
            </div> -->
            <div class="modal-footer d-flex justify-content-center">
             
            </div>
          </div>
        </div>
    </div>
  </div>
    <!-- reply model start here -->
    <div class="modal fade" id="comment_reply_model" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
      aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header text-center">
            <h4 class="modal-title w-100 font-weight-bold">Reply to comment</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close" data-model_id="comment_reply_model">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <form method="post" name="commen_reply_frm" id="commen_reply_frm">
            <input type="hidden" name="reciver_id" id="reciver_id">
             <input type="hidden" name="comment_id" id="comment_id">
            <div class="modal-body mx-3">
              <div class="md-form mb-4">
                <i class="fas fa-envelope prefix grey-text"></i>
                <label data-error="wrong" data-success="right" for="form34">Comment</label>
                <input type="text" id="comment_txt" name="comment" class="form-control" readonly>
              </div>

              <div class="md-form mb-4">
                <i class="fas fas fa-user prefix grey-text"></i>
                <label data-error="wrong" data-success="right" for="form29">User</label>
                <input type="text" id="name" name="name" class="form-control" readonly>
              </div>
              <div class="md-form">
                <i class="fas fa-pencil prefix grey-text"></i>
                 <label data-error="wrong" data-success="right" for="form8">Your message</label>
                <textarea type="text" id="message"  name="message" class="md-textarea form-control" rows="4"></textarea>
              </div>
            </div>
            <div class="modal-footer d-flex justify-content-center">
              <input class="btn btn-unique" type="submit" value="Send"> <i class="fas fa-paper-plane-o ml-1"></i></button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <!-- reply model end here -->
    <script type="text/javascript">
        $(document).ready(function(){
          //close model by id
            $('body').on('click', '.close_btn', function(e) {
                var id = $(this).data('model_id');
                $("#"+id).modal("toggle");
            });
            //comment details by id
            $('body').on('click', '.common_action', function(e) {
              var id = $(this).data('id');
              if(id != '' || id != undefined){
                $.ajax({
                    type: "POST",
                    url: site_url+"/ajax/comment-details",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {id: id},
                    success: function(res){
                       var data = jQuery.parseJSON(res);
                       if(data.status){
                        $("#product_name").html(data.comment[0].product_name);
                        $("#reciver_name").html(data.comment[0].reciver_name);
                        $("#sender_name").html(data.comment[0].sender_name);
                        $("#comment").html(data.comment[0].comment.trim());
                        if(data.comment[0].reply_msg){
                          $("#span_reply_txt").html(data.comment[0].reply_msg.trim());
                        }else{
                          $("#span_reply_txt").html('');
                        }
                        $("#created_at").html(data.comment[0].created_at);
                        $("#info_model").modal("toggle");
                       }else{
                        toastr.error(data.msg);
                       }
                    }
                });
              }
            });
            //delete comment
            $('body').on('click', '.delete_icon', function(e) {
                var id = $(this).data('id');
                if(id != "" || id != undefined){
                    bootbox.confirm({
                        message: "Are you sure want to delete ?",
                        buttons: {
                            cancel: {
                                label: '<i class="fa fa-times"></i> Cancel'
                            },
                            confirm: {
                                label: '<i class="fa fa-check"></i> Confirm'
                            }
                        },
                        callback: function (result) {
                            console.log('This was logged in the callback: ' + result);
                            if(result){
                                $.ajax({
                                    type: "POST",
                                    url: site_url+"/creator/delete-comment",
                                    headers: {
                                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                    },
                                    data: {id: id},
                                    success: function(res){
                                       var data = jQuery.parseJSON(res);
                                       if(data.status){
                                        toastr.success(data.msg);
                                        setTimeout(function(){
                                           window.location.reload();
                                        }, 900);
                                          
                                       }else{
                                        toastr.error(data.msg);
                                        setTimeout(function(){
                                            window.location.reload();
                                        }, 900);
                                       }
                                    }
                                });
                            }
                        }
                    });
                }
            });
            //comment reply form submit
            $('form[id="commen_reply_frm"]').validate({
              rules: {
                message: 'required',
              },
              messages: {
                message: 'Please enter your message',
              },
              submitHandler: function(form) {
                //form.submit();
                frm = $('#commen_reply_frm');
                $.ajax({
                  type: "POST",
                  url: site_url+"/creator/reply-to-comment",
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  },
                  data: frm.serialize(),
                  success: function(res){
                     var data = jQuery.parseJSON(res);
                     $("#comment_reply_model").modal("toggle");
                     if(data.status){
                        toastr.success(data.msg);
                        setTimeout(function(){
                           window.location.reload();
                        }, 900);
                     }else{
                        toastr.error(data.msg);
                     }
                  }
                });
              }
            });
            //open comment reply model
            $('body').on('click', '#comment_replay_btn', function(e) {
              var reply_status = $(this).data("reply_status");
              if(reply_status){
                toastr.info("You have already replied.");
                return true;
              }
              var name = $(this).data("name");
              var reciver_id = $(this).data("reciver_id");
              var comment = $(this).data("comment");
              var comment_id = $(this).data("id");
              $("#name").val(name);
              $("#comment_txt").val(comment);
              $("#reciver_id").val(reciver_id);
              $("#comment_id").val(comment_id);
              $("#message").val('');
              setTimeout(function(){ 
                $("#comment_reply_model").modal("toggle");
              }, 200);
            });
        })
    </script>
  @endsection
