@extends('layouts.main')
@section('content')
<style type="text/css">
   .error {
   color: red;
   margin-left: 5px;
   }
   .text-span{
   margin-left: 50px;
   }
</style>
<div>
   <!-- gpages info start here -->
   <h2><?=$product?$product->title:''?></h2>
   <div class="panel-body no-padding">
      <div class="col-md-3">
         <label>Barcode</label>
         <input class="form-control" value="<?=$product?$product->bar_code:''?>" type="text" readonly>
         <br>
      </div>
      <div class="col-md-3">
         <label>Name</label>
         <input class="form-control"  type="text" value="<?=$product?$product->name:''?>" readonly>
         <br>
      </div>
      <div class="col-md-3">
         <label>Title</label>
         <input class="form-control" value="<?=$product?$product->title:''?>" type="text" readonly>
         <br>
      </div>
      <div class="col-md-3">
         <label>Category</label>
         <input class="form-control"  type="text" value="<?=$product?$product->category_name:''?>" readonly>
         <br>
      </div>
      <div class="col-md-3">
         <label>Subcategory</label>
         <input class="form-control"  type="text" value="<?=$product?$product->subcategory_name:''?>" readonly>
         <br>
      </div>
      <div class="col-md-3">
         <label>Statue</label>
         @if($product->status == 1)
         <span class="label label-success">Draft</span>
         @elseif($product->status == 2)
         <span class="label label-success">Published</span>
         @elseif($product->status == 3)
         <span class="label label-success">Approved</span>
         @elseif($product->status == 4)
         <span class="label label-success">Rejected</span>
         @endif
         <br>
      </div>
      <div class="clearfix"></div>
      <hr>
      <div class="col-md-3">
         <label>Manufacture</label>
         <input class="form-control"  type="text" value="<?=$product?$product->manufactured_by:''?>" readonly>
         <br>
      </div>
      <div class="col-md-3">
         <label>Made In</label>
         <input class="form-control"  type="text" value="<?=$product?$product->made_in_name:''?>" readonly>
         <br>
      </div>
      <div class="col-md-3">
         <label>Msr Price</label>
         <input class="form-control"  type="text" value="<?=$product?$product->msr_price:''?>" readonly>
         <br>
      </div>
      <div class="col-md-3">
         <label>Price</label>
         <input class="form-control"  type="text" value="<?=$product?$product->price:''?>" readonly>
         <br>
      </div>
      <div class="col-md-3">
         <label>Currency</label>
         <input class="form-control"  type="text" value="<?=$product?$product->code:''?>(<?=$product?$product->symbol:''?>)" readonly>
         <br>
      </div>
      <div class="col-md-3">
         <label>Manufactured Part No</label>
         <input class="form-control"  type="text" value="<?=$product?$product->manufactured_port_no:''?>" readonly>
         <br>
      </div>
      <div class="col-md-3">
         <label>Color Show</label><br>
         <?php  $color = json_decode($product->color_to_show);?>
         @foreach($color as $key=>$color_va)
         <!--  <input class="form-control"  type="text" value="<?=$product?$color_va:''?>" readonly> -->
         <span class="btn" style="background-color: {{$color_va}}"></span>
         @endforeach
         <br>
      </div>
      <div class="col-md-3">
         <label>Weight</label>
         <input class="form-control"  type="text" value="<?=$product?$product->weight:''?>" readonly>
         <br>
      </div>
      <div class="col-md-3">
         <label>Unit Price</label>
         <input class="form-control"  type="text" value="<?=$product?$product->unit_price:''?>" readonly>
         <br>
      </div>
      <?php  $dimension = json_decode($product->dimension);?>
      <div class="col-md-3">
         <label>Dimenstions Unit</label>
         <input class="form-control"  type="text" value="<?=$product?$dimension->type:''?>" readonly>
         <br>
      </div>
      <div class="col-md-1">
         <label>Height</label>
         <input class="form-control"  type="text" value="<?=$product?$dimension->height:''?>" readonly>
         <br>
      </div>
      <div class="col-md-1">
         <label>Width</label>
         <input class="form-control"  type="text" value="<?=$product?$dimension->width:''?>" readonly>
         <br>
      </div>
      <div class="col-md-1">
         <label>Length</label>
         <input class="form-control"  type="text" value="<?=$product?$dimension->length:''?>" readonly>
         <br>
      </div>
      <div class="col-md-1">
         <label>Girth</label>
         <input class="form-control"  type="text" value="<?=$product?$dimension->grith:''?>" readonly>
         <br>
      </div>
      <div class="col-md-5">
         <label>Summary</label><br>
         <textarea rows="3" cols="40"><?=$product?$product->mnf_summary:''?></textarea>
         <br>
      </div>
      <div class="clearfix"></div>
      <hr>
      <div class="col-md-12">
         <label>Product Images</label>
         <?php  $image = json_decode($product->image);?>
         @if(count( $image))
         <div class="preview-images-zone">
            @foreach( $image as $key=>$img)
            <img src="<?=$product?asset($img->url):asset('profile_img/no_image.png')?>" height="150px" width="200px;">
            @endforeach
         </div>
         @endif
      </div>
      <div class="clearfix"></div>
      <hr>
      @if(!empty($product->video))
      <div class="col-md-12">
         <label>Product Video</label>
         <?php  $video = json_decode($product->video);?>
         <div class="preview-images-zone">
            @foreach( $video as $key=>$vi)
            <video width="210" height="200" controls class="video">
               <source src="<?=$product?asset($vi->url):asset('profile_img/no_image.png')?>">
               Your browser does not support HTML5 video.
            </video>
            @endforeach
         </div>
      </div>
      @endif
      <div class="clearfix"></div>
      <hr>
      <div class="col-md-6">
         <label>Features</label>
         <br>
         <!-- <input class="form-control"  type="text" value="<?=$product?$product->features_feed:''?>" readonly> -->
         <!-- <textarea rows="3" cols="40"><?=$product?$product->features_feed:''?></textarea> -->
         <?=$product?$product->features_feed:''?>
         <br>
      </div>
      <div class="col-md-6">
         <label>Specification</label>
         <br>
         <!-- <input class="form-control"  type="text" value="<?=$product?$product->spec_field:''?>" readonly> -->
         <!-- <textarea rows="3" cols="40"><?=$product?$product->spec_field:''?></textarea> -->
         <?=$product?$product->spec_field:''?>
         <br>
      </div>
      <div class="clearfix"></div>
      <hr>
      @if(!empty($product->buy_online_link))
         <?php  $online_link = json_decode($product->buy_online_link);?>
         @foreach($online_link as $key => $value)
         <div class="col-md-4">
            @if($key == 0)
            <label>Buy Online Url</label><br>
            <label>Link</label>
            @else
            <label>Link</label>
            @endif
            <input class="form-control"  type="text" value="<?=$value->online_url?>" readonly>
            Price:<input class="form-control"  type="text" value="<?=$value->price?>" readonly>
            <br>
         </div>
         @endforeach
      @endif
      <div class="col-md-3">
         <label>Product Webpage</label>
         <input class="form-control"  type="text" value="<?=$product?$product->web_page_link:''?>" readonly>
         <br>
      </div>
      <div class="col-md-3">
         <label>Manufacture Webpage</label>
         <input class="form-control"  type="text" value="<?=$product?$product->manufactured_web_page_link:''?>" readonly>
         <br>
      </div>
      <div class="clearfix"></div>
      <hr>
      <div class="col-md-3">
         <label>Exclude from feed</label>
         <input class="form-control"  type="text" value="<?=$product?$product->exclude_from_feed == 1?'Yes':'No':''?>" readonly>
         <br>
      </div>
      <div class="col-md-3">
         <label>Hide Price</label>
         <input class="form-control"  type="text" value="<?=$product?$product->hide_price == 1?'Yes':'No':''?>" readonly>
         <br>
      </div>
      <div class="col-md-3">
         <label>Register to view</label>
         <input class="form-control"  type="text" value="<?=$product?$product->register_to_view== 1?'Yes':'No':''?>" readonly>
         <br>
      </div>
      <div class="col-md-3">
         <label>To be page age resticted</label>
         <input class="form-control"  type="text" value="<?=$product->to_be_age_resticted==2?'Yes':'No'?>" readonly>
         <br>
      </div>
      @if(!empty($product->qr_code))
      <div class="col-md-3">
         <label>Qr-code</label>
         <img src="<?=$product?asset($product->qr_code):asset('profile_img/no_image.png')?>" height="150px" width="200px;">
         <br>
      </div>
      @endif
      <div class="clearfix"></div>
      <!-- <hr> -->
   </div>
   <div class="panel-footer">
      <div class="row">
         <div class="col-md-12 text-right"><a href="{{ redirect()->back()->getTargetUrl() }}" class="btn btn-primary">Back</a></div>
      </div>
   </div>
</div>
<!-- gpages info end here -->
<hr class="featurette-divider">
@include('common.menu')
</div>
@endsection