@extends('layouts.landing')
@section('content')
<style type="text/css">
  .error{
    color:red;
  }
</style>
<?php 
  if(Auth::check()){
    $name = Auth::user()->name;
    $email = Auth::user()->email;
  }else{
    $name = '';
    $email = '';
  }
?>
<section class="seciton section-content" style="padding: 40px 0">
   <div class="container-fluid">
      <div class="row">
         <div class="container">
               <div class=" mx-auto " style="max-width: 600px;">
                    <h5 class="center" style="padding: 0 0 30px 0;">Support Message</h5>
                    <form id="feedback_frm" name="feedback_frm" class="form-signin" method="post">
                        @csrf
                        <span id="show_message"></span>
                                        <input type="hidden" name="user_id" value="">
                                   <div class="form-group"> 
                        
                        <input type="text" class="form-control" id="name" name="name" placeholder="Name" value="{{$name}}" readonly="">
                    </div>
                    <div class="form-group">
                        <input type="text" class="form-control" id="email" name="email" placeholder="Email" value="{{$email}}" readonly="">
                    </div>
                    <div class="form-group">
                        <input type="text" class="form-control" id="about" name="about" placeholder="Subject" value="">
                    </div>
                    <div class="form-group">
                      <textarea class="form-control" type="textarea" id="message" name="message" placeholder="Message" maxlength="140" rows="7"></textarea>                
                    </div>
                     <input type="submit" class="btn btn-primary pull-right" id="reply_btn" name="submit" value="Submit">   
                    <!--button type="submit" id="submit" name="submit" class="btn btn-primary pull-right">Submit</button-->
                    </form>
                </div>
            </div>
         </div>
      </div>
   </div>
</section>
<script type="text/javascript">
  $(document).ready(function(){
    $('form[id="feedback_frm"]').validate({
        rules: {
          name: 'required',
          email:{
            required: true,
            email: true
          },
          about:'required',
          message: 'required',
        },
        messages: {
          name: 'Please enter your name',
          email:{
            required: 'Please enter email address',
            email: 'Please enter valid email address'
          },
          about: 'Please enter subject',
          message: 'Please enter your message',
        },
        submitHandler: function(form) {
          //form.submit();
          $("#reply_btn").attr("disabled", true);
          frm = $('#feedback_frm');
          $.ajax({
            type: "POST",
            url: site_url+"/support",
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: frm.serialize(),
            success: function(res){
               var data = jQuery.parseJSON(res);
               if(data.status){
                  toastr.success(data.msg);
                  $("#message").val("");
                  $("#about").val("");
                  setTimeout(function(){
                     //window.location.reload();
                  }, 900);
               }else{
                  toastr.error(data.msg);
               }
               $("#reply_btn").attr("disabled", false);
            }
          });
        }
      });
  });
</script>
@endsection

 