<!doctype html>
<html lang="en">

<head>
    <title>Gfects Admin | {{$title?ucfirst($title):'Page'}}</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="stylesheet" href="{{asset('/public/assets_admin/vendor/bootstrap/css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{asset('/public/assets_admin/vendor/font-awesome/css/font-awesome.min.css')}}">
    <link rel="stylesheet" href="{{asset('/public/assets_admin/vendor/linearicons/style.css')}}">
    <link rel="stylesheet" href="{{asset('/public/assets_admin/vendor/chartist/css/chartist-custom.css')}}">
    <link rel="stylesheet" href="{{asset('/public/assets_admin/scripts/DataTables/DataTables-1.10.16/css/jquery.dataTables.css')}}">
    <link rel="stylesheet" href="{{asset('/public/assets_admin/css/main.css')}}">
    <link rel="stylesheet" href="{{asset('/public/assets_admin/css/demo.css')}}">
    <link rel="stylesheet" href="{{asset('/public/assets_admin/css/custom.css')}}">
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700" rel="stylesheet">
     <link href="{{asset('/public/vendor/toastr/toastr.min.css')}}" rel="stylesheet">
    <script src="{{asset('/public/assets_admin/vendor/jquery/jquery.min.js')}}"></script>
    <!-- ICONS -->
    <link rel="apple-touch-icon" sizes="76x76" href="{{asset('assets_admin/img/apple-icon.png')}}">
    <link rel="icon" type="image/png" sizes="96x96" href="{{asset('assets_admin/img/favicon.png')}}">
    <script type="text/javascript">
      var site_url ="<?=url('/')?>";
    </script>
</head>
<?php 
  $login_user =  Auth::guard('admin')->user();
  $last_login = App\User::get_last_login($login_user->id);
  $notification = App\User::notification_list_by_id($login_user->id);
  //print_r($notification);
?>
<body>
    <!-- WRAPPER -->
    <div id="wrapper">
        <!-- NAVBAR -->
        <nav class="navbar navbar-default navbar-fixed-top">
            <div class="brand">
                <a href="{{url('admin/dashboard')}}">
                    <img src="{{asset('/public/assets_admin/img/logo_w.png')}}" height="36" />
                </a>
            </div>
            <div class="container-fluid">
                <div class="navbar-btn">
                    <button type="button" class="btn-toggle-fullwidth">
                        <i class="lnr lnr-menu"></i>
                    </button>
                </div>
                <form class="navbar-form navbar-left">
                    <ul>
                        <!--<li>GENOVA PTE. LTD.</li>-->
                        <li></li>
                        <li class="hidden-xs">Last Login :
                            <span><?=$last_login?date('Y-m-d H:i:s A',strtotime($last_login)):date('Y-m-d H:i:sA')?></span>
                        </li>
                    </ul>
                </form>
                <div id="navbar-menu">
                    <ul class="nav navbar-nav navbar-right">
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle icon-menu" data-toggle="dropdown">
                                <i class="lnr lnr-alarm"></i>
                                <span class="badge bg-danger">{{count($notification)}}</span>
                            </a>
                            <ul class="dropdown-menu notifications">
                            @if(count($notification) >0)
                                @foreach($notification as $key=> $value)
                                    <li class="">
                                        <a  class="notification-item read_action" data-id="{{$value->id}}">
                                            <span class="dot bg-warning"></span>{{$value->message}}
                                        </a>
                                    </li>
                                @endforeach
                                <li>
                                    <a href="{{url('admin/notification')}}" class="more">
                                       See all notifications
                                    </a>
                                </li>
                            @endif
                            </ul>
                        </li>
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle users" data-toggle="dropdown">
                                <img src="<?=$login_user?$login_user->profile_picture:asset('/public/assets_admin/img/user2.png')?>" class="img-circle" alt="Avatar">
                                <span>{{$login_user->first_name}}</span>
                                <i class="icon-submenu lnr lnr-chevron-down"></i>
                            </a>
                            <ul class="dropdown-menu">
                                <li>
                                    <a href="{{url('admin/profile')}}">
                                        <i class="lnr lnr-user"></i>
                                        <span>My Profile</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="{{url('admin/change-password')}}">
                                        <i class="lnr lnr-envelope"></i>
                                        <span>Change Password</span>
                                    </a>
                                </li>
                                <!-- <li>
                                    <a href="#">
                                        <i class="lnr lnr-cog"></i>
                                        <span>Settings</span>
                                    </a>
                                </li> -->
                                <li>
                                    <a href="{{url('admin/logout')}}">
                                        <i class="lnr lnr-exit"></i>
                                        <span>Logout</span>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <!-- <li class="dropdown">
                            <a href="#" class=" icon-menu">
                                <i class="lnr lnr-power-switch"></i>
                            </a>
                        </li> -->
                    </ul>
                </div>
            </div>
        </nav>
        <!-- END NAVBAR -->
        <!-- LEFT SIDEBAR -->
        <div id="sidebar-nav" class="sidebar">
            <div class="sidebar-scroll">
                <nav>
                    <ul class="nav">
                        <li>
                            <a href="{{url('admin/dashboard')}}" class="<?=$title == 'Dashboard'?'active':''?>">
                                <i class="lnr lnr-home"></i>
                                <span>Dashboard</span>
                            </a>
                        </li>
                        <li>
                            <a href="{{url('admin/user-list')}}" class="<?=$title == 'Users List'?'active':''?>">
                                <i class="lnr lnr-users"></i>
                                <span>Users</span>
                            </a>
                        </li>
                        <li>
                            <a href="{{url('admin/to-be-approved-gpages')}}" class="<?=$title == 'To Be Approved Gpages' || $title == 'User Info' || $title == 'G-Pages Info'?'active':''?>">
                                <i class="lnr lnr-circle-minus"></i>
                                <span>To be approved</span>
                            </a>
                        </li>
                        <li>
                            <a href="{{url('admin/approved-gpages')}}" class="<?=$title == 'Approved Gpages'?'active':''?>">
                                <i class="lnr lnr-plus-circle"></i>
                                <span>Product G-Pages</span>
                            </a>
                        </li>
                        <li>
                            <a href="{{url('admin/rejected-approved-gpages')}}" class="<?=$title == 'Rejected Approved Gpages'?'active':''?>">
                                <i class="lnr lnr-cross"></i>
                                <span>Rejected</span>
                            </a>
                        </li>
                        <li>
                            <a href="{{url('admin/flagged-list')}}" class="<?=$title == 'Flagged List' || $title == 'Flagged Info'?'active':''?>">
                                <i class="lnr lnr-layers"></i>
                                <span>Flagged</span>
                            </a>
                        </li>
                         <li>
                            <a href="#content_mng" data-toggle="collapse" class="<?=$title == 'Reason List' ||$title == 'Edit Reason' ||$title == 'Add Reason' || $title == 'Category List' || $title == 'Edit Category' || $title == 'Add Category' || $title == 'Add Subcategory' || $title == 'Edit Subcategory' || $title == 'Subcategory List'?'active':'collapsed'?>">
                                <i class="lnr lnr-cog"></i>
                                <span>Content Managment</span>
                                <i class="icon-submenu lnr lnr-chevron-right"></i>
                            </a>
                            <div id="content_mng" class="collapse <?=$title == 'Reason List' ||$title == 'Edit Reason' || $title == 'Add Reason' || $title == 'Category List' || $title == 'Edit Category' || $title == 'Add Category' || $title == 'Add Subcategory' || $title == 'Edit Subcategory' || $title == 'Subcategory List'?'in':''?>">
                                <ul class="nav">    
                                    <li>
                                        <a href="{{url('admin/flagged/reason-list')}}" class="<?=$title == 'Reason List' ||$title == 'Edit Reason' ||$title == 'Add Reason'?'active':''?>"> 
                                            <i class="lnr lnr-layers"></i>
                                            <span>Flagged Reason</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{url('admin/category-list')}}" class="<?=$title == 'Category List' || $title == 'Edit Category' ||$title == 'Add Category'?'active':''?>"> 
                                            <i class="lnr lnr-layers"></i>
                                            <span>Category</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{url('admin/subcategory-list')}}" class="<?=$title == 'Subcategory List' ||$title == 'Edit Subcategory' ||$title == 'Add Subcategory'?'active':''?>"> 
                                            <i class="lnr lnr-layers"></i>
                                            <span>Subcategory</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                        <li>
                            <!-- <a href="" class="">
                                <i class="lnr lnr-cog"></i>
                                <span>Site Settings</span>
                            </a> -->
                            <a href="#settings" data-toggle="collapse" class="<?=$title == 'About us' || $title == 'How its work'?'active':'collapsed'?>">
                                <i class="lnr lnr-cog"></i>
                                <span>Site Settings</span>
                                <i class="icon-submenu lnr lnr-chevron-right"></i>
                            </a>
                            <div id="settings" class="collapse <?=$title == 'About-us' || $title == 'How-its-work' || $title == 'Apps' || $title == 'Privacy' || $title == 'Faq' || $title == 'Terms-of-use'?'in':''?>">
                                <ul class="nav">    
                                    <li>
                                        <a href="{{url('admin/setting/about-us')}}" class="<?=$title == 'About-us'?'active':''?>"> 
                                            <i class="lnr lnr-layers"></i>
                                            <span>About us</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{url('admin/setting/apps')}}" class="<?=$title == 'Apps'?'active':''?>"> 
                                            <i class="lnr lnr-layers"></i>
                                            <span>Apps</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{url('admin/setting/how-its-work')}}" class="<?=$title == 'How-its-work'?'active':''?>"> 
                                            <i class="lnr lnr-layers"></i>
                                            <span>How its work</span>   
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{url('admin/setting/faq')}}" class="<?=$title == 'Faq'?'active':''?>"> 
                                            <i class="lnr lnr-layers"></i>
                                            <span>Faq</span>   
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{url('admin/setting/Privacy')}}" class="<?=$title == 'Privacy'?'active':''?>"> 
                                            <i class="lnr lnr-layers"></i>
                                            <span>Privacy</span>   
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{url('admin/setting/terms-of-use')}}" class="<?=$title == 'Terms-of-use'?'active':''?>"> 
                                            <i class="lnr lnr-layers"></i>
                                            <span>Terms of use</span>   
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                        <li>
                            <a href="{{url('admin/feedback')}}" class="<?=$title == 'Feedback List' || $title == 'Feedback Exchange'?'active':''?>">
                                <i class="lnr lnr-book"></i>
                                <span>Feedback</span>
                            </a>
                        </li>
                        <li>
                            <a href="{{url('admin/support-message')}}" class="<?=$title == 'Support Messages' || $title == 'Support Messages Exchange'?'active':''?>">
                                <i class="lnr lnr-star"></i>
                                <span>Support Messages</span>
                            </a>
                        </li>
                        <li>
                            <a href="{{url('admin/notification')}}" class="">
                                <i class="lnr lnr-star"></i>
                                <span>Notification</span>
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
            <footer>
                <div class="container-fluid"></div>
            </footer>
            </div>
            <!-- END LEFT SIDEBAR -->
            <!-- MAIN --> 
            @yield('content')
            @endcontent       
            <!-- END MAIN CONTENT -->
            <div class="subfooter">
                <div class="col-sm-4">
                    <ul>
                        <li>
                            <p class="copyright copyright-left">&copy; 2018
                                <a href="#" target="_blank">Gfects</a>
                            </p>
                        </li>
                    </ul>
                </div>
                <div class="col-sm-8">
                    <ul>
                        <li>
                            <p class="copyright"> &nbsp;
                                <img src="{{asset('/public/assets_admin/img/logo.png')}}" height="19" />
                            </p>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- END MAIN -->
        <div class="clearfix"></div>
    </div>
    <!-- END WRAPPER -->
    <!-- Javascript -->
    <script src="{{asset('/public/assets_admin/vendor/bootstrap/js/bootstrap.min.js')}}"></script>
    <script src="{{asset('/public/assets_admin/vendor/jquery-slimscroll/jquery.slimscroll.min.js')}}"></script>
    <script src="{{asset('/public/assets_admin/vendor/jquery.easy-pie-chart/jquery.easypiechart.min.js')}}"></script>
    <script src="{{asset('/public/assets_admin/vendor/chartist/js/chartist.min.js')}}"></script>
    <script src="{{asset('/public/assets_admin/scripts/DataTables/DataTables-1.10.16/js/jquery.dataTables.js')}}"></script>
    <script src="{{asset('/public/assets_admin/scripts/klorofil-common.js')}}"></script>
    <script src="{{asset('/public/assets_admin/scripts/bootbox.js')}}"></script>
    <script src="{{asset('/public/assets_admin/scripts/jquery.validate.js')}}"></script>
    <script src="{{asset('vendor/toastr/toastr.min.js')}}"></script>
    <script src="{{asset('/public/vendor/ckeditor/ckeditor.js')}}"></script>
    <script src="{{asset('/public/assets_admin/scripts/custom.js')}}"></script>
    <script>
        $(document).ready(function() {
            var t = $('.datatable').DataTable();
            t.on( 'order.dt search.dt', function () {
                t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
                    cell.innerHTML = i+1;
                } );
            } ).draw();

            $('body').on('click', '.read_action', function(e) {
                var id = $(this).data('id');
                //alert(id);
                $.ajax({
                    type: "POST",
                    url: site_url+"/admin/read-notification",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {id: id},
                    success: function(res){
                       var data = jQuery.parseJSON(res);
                       if(data.status){
                        setTimeout(function(){
                           window.location.reload();
                        }, 900);
                          
                       }else{
                        setTimeout(function(){
                            window.location.reload();
                        }, 900);
                       }
                    }
                });
                return true;
            });
        });
    </script>
</body>

</html>
