<?php
// This is PHP function to convert a user-supplied URL to just the domain name,
// which I use as the link text.
// Remember you still need to use htmlspecialchars() or similar to escape the
// result.
function url_to_domain($url)
  {
      $host = @parse_url($url, PHP_URL_HOST);
      // If the URL can't be parsed, use the original URL ### Change to "return false" if you don't want that
      if (!$host) $host = $url;
      // The "www." prefix isn't really needed if you're just using ### this to display the domain to the user
      if (substr($host, 0, 4) == "www.") $host = substr($host, 4);
      // You might also want to limit the length if screen space is limited
      if (strlen($host) > 50) $host = substr($host, 0, 47) . '...';

      return $host;
  }
?>

@if(!empty($gpage->buy_online_link))
    <?php
    $buy_link = json_decode($gpage->buy_online_link);
    ?>

            <section id="buytable">
                <div class="container-fluid">
                  <style>
                    #buyTable{
                      display:block;
                    }

                    #buyTable a:hover
                    {
                      text-decoration: none;
                    }

                    .buyTable_header
                    {
                      background: #316486;
                      padding:5px;
                      color: white;
                      position: relative;
                      transition: all 0.3s ease-in-out;
                    }

                    .buyTable_header li:first-child
                    {
                      background:#316486;
                      border:none;
                    }
                    
                    .buyTable_header:before
                    {
                      position: absolute;
                      z-index: 1;
                      left: -20%;
                      top: -10%;
                      content: '';
                      width: 50%;
                      height: 147%;
                      -webkit-transform: rotate(-30deg);
                      transform: rotate(-30deg);
                      background: white;
                      opacity: .3;
                      transition: all 0.3s ease-in-out;
                    }

                    .buyTable:hover{
                      background: black;
                    }
                    
                    #buyTable:hover{
                        box-shadow: 0px 0px 19px -3px rgba(0,0,0,0.36);
                      }
                    
                    #buyTable:hover .buyTable_header:before
                    {
                      -webkit-transform: rotate(0deg);
                      transform: rotate(0deg);
                      width: 60%;
                    }

                    #icona_2 
                    {
                      width:25px;
                      height:25px;
                      background: url("{{url('/public/assets_web/img/G-web.png')}}");
                      background-position:0 -28px;
                      background-size: 300px;
                    }

                  </style>
                  <h3>Buy online</h3>
                    <div id="buyTable" class="m-auto" style="max-width: 300px">
                      <ul class="buyTable_header list-group">
                        <li class="list-group-item d-flex justify-content-between">
                          <div>
                            <h6 class="my-0">Store</h6>
                          </div>
                          <span>Price</span>
                        </li>
                      </ul>
                    	<ul class="list-group mb-3">
                        @foreach($buy_link as $key => $value)
                        <li class="list-group-item d-flex justify-content-between">
                          <div style="width: 200px; ">
                            <?php
                                $url = $value->online_url;
                                ?>
                            <a href="{{ $url }}" class="stretched-link" target='blank'><h6 class="my-0"><?= htmlspecialchars(url_to_domain($url)) ?></h6></a>
                                  {{--
                            <div class="row">
                              <div class="col-auto">
                                <small class="text-muted">
                                  last Checked 
                                  @if($lastcheck < 'younger than 6 months')
                                    <span class="text-success"><i class="fas fa-check-square">: $lastcheck = 2 days ago</i></span>
                                  @else
                                      <span class="text-danger font-weight-bold">: $lastcheck 7 days ago</span>
                                  @endif
                                </small>
                                </div>
                                <div id="icona_2" class="col-auto"></div>
                              </div>
                                  --}}
                          </div>
                          <div class="row">
                            <div class="col-auto"><span class="text-muted">{{\App\Currencie::find($gpage->currency)->symbol}}{{$value->price}}</span></div>
                          </div>
                        </li>
                        @endforeach
                      </ul>
                    </div>
                </div>
            </section>
        		<hr class="featurette-divider">
@endif