@extends('layouts.layout')

{{-- head Start--}}
  @section('meta_description'){{$meta_description}}@endsection
  @section('title'){{$title}}@endsection
  @section('more_css_style')
  <style>
    form input.ng-pristine{border: 1px solid lightblue;}
    form input.ng-dirty{border: 1px solid pink;}
  </style>
  @endsection
  @section('Google_adsense')
    @includeif('layouts.googleadsense')
  @endsection
{{-- head end--}}


{{-- Body start--}}

{{-- section starts--}}
  {{-- top --}}
  @section('section_content_top')
  @endsection
  
  {{-- Middle --}}
  @section('section_content')
  <div class="container" ng-app="app">
    <div class="py-5 text-center">
      
      <h2>Create account</h2>
      <p class="lead">Create a publisher account to add your product to G-Pages. </p>
      <p>Read more about the types of <a href="Creator-Types">creator accounts</a></p>
    </div>


    <div class="py-5" ng-controller="create-ACC-cntrlr">

      <div class="p-3 my-3">             
          <h4 class="mb-3">Let's get started </h4>
          <hr class="mb-4">
          <div ng-show="!show_cAcc_prog_01"><p>Already have account? <a href="log-in">Log in</a></p></div>
          <!--
          <div>
            <p>Continue with</p>
            <ul class="selectDynamicType">
              <li class="d-inline ml-1"><button type="button" class="mb-1 btn btn-danger" "="">Google</button></li>
              <li class="d-inline ml-1"><button type="button" class="mb-1 btn btn-primary">LinkedIn</button></li>
            </ul>
          </div>
          -->
          
          <hr class="mb-4">

          <form class="needs-validation" name="createACCf01" method="POST" action="{{url('/Create-Account') }}">
            @csrf

            <p><b>Representative Details</b> - let's get to know you</p>

            
            <div class="row">
              <div class="col-md-6 mb-3">
                <label for="firstName">First name</label>
                <input type="text" class="form-control {{ $errors->has('firstName') ? ' is-invalid' : '' }}" id="firstName" name="firstName" placeholder="first"  value="{{ old('firstName') }}" required="">
                <div class="invalid-feedback {{ $errors->has('firstName') ? ' is-invalid' : '' }}">
                  <p>{{ $errors->first('firstName') }}<br>Valid first name is required.</p>
                </div>
              </div>
              <div class="col-md-6 mb-3">
                <label for="lastName">Last name</label>
                <input type="text" class="form-control {{ $errors->has('lastName') ? ' is-invalid' : '' }}" id="lastName" name="lastName" placeholder=""  value="{{ old('lastName') }}" required="">
                <div class="invalid-feedback {{ $errors->has('lastName') ? ' is-invalid' : '' }}">
                  Valid last name is required.
                </div>
              </div>
            </div>

            <div class="mb-3">
              <label for="sdate">Birthdate</label>
              <input type="date" class="form-control col-md-2 {{ $errors->has('Bsdate') ? ' is-invalid' : '' }}" id="Bsdate" name="Bsdate" value="{{ old('Bsdate') }}" require>
              <div class="invalid-feedback {{ $errors->has('Bsdate') ? ' is-invalid' : '' }}">
                <p>Birthdate required and you must be over 18 years</p>
              </div>
            </div>
                          

            <div class="mb-3">
              <label for="email">Email </label>
              <input type="email" class="form-control {{ $errors->has('email') ? ' is-invalid' : '' }}" id="email" name="email" ng-model="email" placeholder="work@example.com" value="{{ old('email') }}" required>
              @if ($errors->has('email'))
              <div class="text-danger {{ $errors->has('email') ? ' is-invalid' : '' }}" >
                {{ $errors->first('email') }} <a href="log-in">log in</a>
              </div>
               @endif
              <div class="text-danger {{ $errors->has('email') ? ' is-invalid' : '' }}" ng-show="createACCf01.email.$touched && createACCf01.email.$invalid">
                Please enter a valid email address.
              </div>
            </div>
            <hr class="mb-4">

            
            <div class="row">
              <div class="col-md-6 mb-3">
                <label for="country">Country</label>
                  <select class="form-control gds-cr{{ $errors->has('country') ? ' is-invalid' : '' }}" id="country" name="country" country-data-region-id="gds-cr-two" country-data-default-value="US" ng-model="country" valve="{!! !empty($country) ? $country : '' !!}" required></select>
                  <div class="invalid-feedback {{ $errors->has('country') ? ' is-invalid' : '' }}">
                    Please select a valid country.
                  </div>
              </div>
              <div class="col-md-6 mb-3">
                <label for="state"><span>State / Province / Region</span></label>
                <select class="form-control {{ $errors->has('state') ? ' is-invalid' : '' }}" id="gds-cr-two" region-data-language="en" name="state"  value="" required></select>
                <div class="invalid-feedback {{ $errors->has('state') ? ' is-invalid' : '' }}">
                  Please provide a valid state.
                </div>
              </div>
            </div>

            <h5 class="mb-3">Enter your Username</h5>
            <div class="mb-3">
              <label for="username">Username</label>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text">@</span>
                </div>
                <input type="text" class="form-control col-md-2 {{ $errors->has('username') ? ' is-invalid' : '' }}" id="username" name="username" placeholder="Username" value="{{ old('username') }}" required>
                @if ($errors->has('username'))
                <div class="invalid-feedback {{ $errors->has('username') ? ' is-invalid' : '' }}" >
                  <p>{{ $errors->first('username')}} <a href="log-in">log in</a></p> 
                </div>
                 @endif
              </div>
            </div>
            <div class="mb-3">
              <label for="password">Password</label>
              <input type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" id="password" name="password" placeholder="password" required>
              @if ($errors->has('password'))
                <div class="invalid-feedback {{ $errors->has('password') ? ' is-invalid' : '' }}" >
                  <p>{{ $errors->first('password')}}</p> 
                  <p>Password must be 8 characters in length, contains only alphanumeric characters with at least one numeric digit.</p>
                </div>
                 @endif
            </div>
            <div class="mb-3">
              <label for="password-confirm">Confirm Password</label>
              <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" placeholder="password" required>
              @if ($errors->has('password-confirm'))
                <div class="invalid-feedback {{ $errors->has('password-confirm') ? ' is-invalid' : '' }}" >
                  <p>{{ $errors->first('password-confirm')}}</p> 
                </div>
                 @endif
            </div>
            
            <hr class="mb-4">
            <div class="mb-3">
              <small class="text-muted">By clicking continue, you agree to our <a href="terms" title="gfects terms of use"> Terms of use.</a></small>
            </div>

            <button class="btn btn-primary float-right" type="submit" >Continue</button>
          </form>
            

          <ng-include src="show_Create_ACC_HTML_form"></ng-include>
        
      </div>
    </div>
  </div>
  @endsection

  {{-- bottom for pop ups--}}
  @section('section_content_3')
  @endsection

{{-- section end--}}

{{-- footer Start--}}
{{-- footer end --}}

{{-- Scripts start--}}
  @section('ext_scripts')
  <!-- For country and state selector cass start-->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/country-region-dropdown-menu/1.2.1/geodatasource-cr.min.js"></script>
  <!--cass end -->
    <script src="https://ajax.googleapis.com/ajax/libs/angularjs/1.7.4/angular.min.js"></script>
    <script src="/js/angular-contr.js"></script>
  @endsection
{{-- script end--}}

{{--Body  end--}}