<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="Gfects LLC">
    <link rel="icon" href="{{url('/public/img/Gfects_icon.png')}}">
    <meta name="description" content="@yield('meta_description', 'Page')">

    <title>Gfects | @yield('title', 'Page')</title>

    <!-- Bootstrap core CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">

     <link href="https://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic"
          rel="stylesheet" type="text/css"/>
    <link rel="stylesheet" type="text/css" href="{{asset('public/vendor//toastr/toastr.min.css')}}">   
    <script src="https://kit.fontawesome.com/0596136271.js" crossorigin="anonymous"></script>
    <!-- Custom styles for this template -->
    <link href="{{url('/public/css/styling.css')}}" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
    {{-- For posting redirect --}} @if(isset($canonical))
    <link rel="canonical" href="{{ $canonical }}" />
    @endif
    
    @yield('more_css_style')
    
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-85605806-1"></script>
    @yield('Google_adsense')
    <script type="text/javascript">
      var site_url ="<?=url('/')?>";
    </script>
  </head>
  <body>

    @include('layouts.inc_header')

    <main role="main">      
      <div class="m-5 p-2"></div>
      @yield('section_content_top')

      <div class="container mt-4">
        <!-- START THE FEATURETTES -->
        @yield('content')
        @yield('section_content')
      </div>

      @yield('section_content_3')

      <!-- /.container -->


      <!-- FOOTER -->
      @include('layouts.inc_footer')
      <!-- /.container -->
    </main>


    <!-- <script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script> -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js" integrity="sha384-cs/chFZiN24E4KMATLdqdvsezGxaGsi4hLGOzlXwp5UZB1LY//20VyM2taTB4QvJ" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
    <script src="https://code.jquery.com/ui/1.12.0/jquery-ui.min.js" integrity="sha256-eGE6blurk5sHj+rmkfsGYeKyZx3M4bG+ZlFyA7Kns7E=" crossorigin="anonymous"></script>
    <script src="{{asset('public/vendor//toastr/toastr.min.js')}}"></script>
    <script src="{{asset('public/assets_web/js/jquery.validate.min.js')}}"></script>
    <script src="{{asset('public/assets_web/js/custom.js')}}"></script>
    @yield('ext_scripts')
  </body>
</html>