@extends('layouts.layout')

{{-- head Start--}}
  @section('meta_description'){{$meta_description}}@endsection
  @section('title'){{$title}}@endsection
  @section('more_css_style')
  <style>
    form input.ng-pristine{border: 1px solid lightblue;}
    form input.ng-dirty{border: 1px solid pink;}
  </style>
  @endsection
  @section('Google_adsense')
    @includeif('layouts.googleadsense')
  @endsection
{{-- head end--}}


{{-- Body start--}}

{{-- section starts--}}
  {{-- top --}}
  @section('section_content_top')
  @endsection
  
  {{-- Middle --}}
  @section('section_content')
  <div class="container" ng-app="app">
    <div class="py-5 text-center">
      
      <h2>Create account</h2>
      <p class="lead">Create a publisher account to add your product to G-Pages. </p>
      <p>Read more about the types of <a href="Creator-Types">creator accounts</a></p>
    </div>


    <div class="py-5" ng-controller="create-ACC-cntrlr">

      <div class="p-3 my-3">             
          <h4 class="mb-3">Let's get started </h4>
          @empty($country)
          <div>
              <p>
                <b>State / Province / Region</b> {!! !empty($state) ? $state : '***empty***' !!}, <b> country </b>{!! !empty($country) ? $country : '***empty***' !!} <span> </span><span> <a href="Create-Account">Edit</a></span>
              </p>
          </div>
          @endempty

          @isset($state, $country )
          <div>
              <p>
                <b>State / Province / Region</b> {!! !empty($state) ? $state : '***empty***' !!}, <b> country </b>{!! !empty($country) ? $country : '***empty***' !!} <span> </span><span> <a href="Create-Account">Edit</a></span>
              </p>
          </div>

          <form class="needs-validation" name="createACCf01" method="" action="testingpage" novalidate=""> 
            @csrf
            @method_post

            <p><b>Representative Details</b> - let's get to know you</p>

            
            <div class="row">
              <div class="col-md-6 mb-3">
                <label for="firstName">First name</label>
                <p>{!! !empty($firstName) ? $firstName : '***empty***' !!}</p>
                <input type="hidden" class="form-control" id="firstName" name="firstName" placeholder=""  value="{!! !empty($firstName) ? $firstName : '' !!}" required="">
                <div class="invalid-feedback">
                  Valid first name is required.
                </div>
              </div>
              <div class="col-md-6 mb-3">
                <label for="lastName">Last name</label>
                <p>{!! !empty($lastName) ? $lastName : '***empty***' !!}</p>
                <input type="hidden" class="form-control" id="lastName" name="lastName" placeholder=""  value="{!! !empty($lastName) ? $lastName : '' !!}" required="">
                <div class="invalid-feedback">
                  Valid last name is required.
                </div>
              </div>
            </div>

            <div class="mb-3">
              <label for="sdate">Birthdate</label>
                <p>{!! !empty($Bsdate) ? $Bsdate : '***empty***' !!}</p>
              <input type="hidden" class="form-control col-md-2" id="Bsdate" name="Bsdate" value="{!! !empty($Bsdate) ? $Bsdate : '' !!}" require>
              <div class="invalid-feedback">
                <p>Birthdate required</p>
              </div>
            </div>
                          

            <div class="mb-3">
              <label for="email">Email </label>
                <p>{!! !empty($email) ? $email : '***empty***' !!}</p>
              <input type="hidden" class="form-control" id="email" name="emailfLD" ng-model="email" placeholder="work@example.com" value="{!! !empty($email) ? $email : '' !!}" required>
              <div class="text-danger" ng-show="createACCf01.emailfLD.$touched && createACCf01.emailfLD">
                This email address ready exist. <a href="log-in">log in</a>
              </div>
              <div class="text-danger" ng-show="createACCf01.emailfLD.$touched && createACCf01.emailfLD.$invalid">
                Please enter a valid email address.
              </div>
            </div>
            <hr class="mb-4">

            <div class="row">
                <p></p>
                  <input type="hidden" name="country" value="{!! !empty($country) ? $country : '' !!}"  required>
                  <input type="hidden" name="state" value="{!! !empty($state) ? $state : '' !!}" required>
            </div>

            <h4 class="mb-3">Enter your User name</h4>
            <div class="mb-3">
              <label for="username">Username</label>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text">@</span>
                </div>
                <p>{!! !empty($username) ? $username : '***empty***' !!}</p>
                <input type="hidden" class="form-control" id="username" name="username" placeholder="Username" value="{!! !empty($Username) ? $Username : '' !!}" required="">
                <div class="invalid-feedback" style="width: 100%;">
                  Your username is required.
                </div>
              </div>
            </div>
            <div class="mb-3">
              <label for="password">Password</label>
                <p>{!! !empty($password) ? $password : '***empty***' !!}</p>
              <input type="hidden" class="form-control" id="password" name="password" placeholder="password" required="">
              <div class="invalid-feedback">
                <p>Please enter a valid password.</p>
                <p>8 characters in length, contains only alphanumeric characters with at least one numeric digit.</p>
              </div>
            </div>
            <div class="mb-3">
              <label for="password">Confirm Password</label>
                <p></p>
              <input type="hidden" class="form-control" id="passwordc" name="password_confirmation" placeholder="password" required="">
              <div class="invalid-feedback">
                <p>Please enter a valid password.</p>
                <p>8 characters in length, contains only alphanumeric characters with at least one numeric digit.</p>
              </div>
            </div>
            
            <hr class="mb-4">
            <div class="mb-3">
              <small class="text-muted">By clicking continue, you agree to our <a href="terms" title="gfects terms of use"> Terms of use.</a></small>
            </div>

            <button class="btn btn-primary float-right" type="submit" >Continue</button>
          </form>

          @endisset
            

          <ng-include src="show_Create_ACC_HTML_form"></ng-include>
        
      </div>
    </div>
  </div>
  @endsection

  {{-- bottom for pop ups--}}
  @section('section_content_3')
  @endsection

{{-- section end--}}

{{-- footer Start--}}
{{-- footer end --}}

{{-- Scripts start--}}
  @section('ext_scripts')

  @empty($country)
  <!-- For country and state selector cass start-->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/country-region-dropdown-menu/1.2.1/geodatasource-cr.min.js"></script>
  <!--cass end -->
  @endempty
  @isset($state, $country )
    <script src="https://ajax.googleapis.com/ajax/libs/angularjs/1.7.4/angular.min.js"></script>
    <script src="https://gfects.com/assets/js/angular-contr.js"></script>
  @endisset
  @endsection
{{-- script end--}}

{{--Body  end--}}