
<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="Gfects LLC">
    <link rel="icon" href="{{asset('img/Gfects_icon.png')}}">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="description" content="@yield('meta_description', ' Page=')">

    <title>Gfects | @yield('title', 'Page')</title>

    <!-- Bootstrap core CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/css/bootstrap.min.css" integrity="sha384-9gVQ4dYFwwWSjIDZnLEWnxCjeSWFphJiwGPXr1jddIhOegiu1FwO5qRGvFXOdJZ4" crossorigin="anonymous">

     <link href="https://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic"
          rel="stylesheet" type="text/css"/>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.3.1/css/all.css" integrity="sha384-mzrmE5qonljUremFsqc01SB46JvROS7bZs3IO2EmfFsd15uHvIt+Y8vEf7N7fWAU" crossorigin="anonymous">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <!-- Custom styles for this template -->
    <link href="{{asset('css/styling.css')}}" rel="stylesheet">
    <link href="{{asset('css/carousel.css')}}" rel="stylesheet">
    <!-- tostr message css -->
     <link href="{{asset('vendor/toastr/toastr.min.css')}}" rel="stylesheet">
    @yield('more_css_style')
    <script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-85605806-1"></script>
    @yield('Google_adsense')
    <script type="text/javascript">
      var site_url ="<?=url('/')?>";
    </script>
<style type="text/css">
.acount-type{
    background-color: #FF6347;
    padding: 10px 15px 10px 15px;
  }
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

/* Hide default HTML checkbox */
.switch input {
  opacity: 0;
  width: 0;
  height: 0;
}

/* The slider */
.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #FF6347;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #2196F3;
}

input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
  </style>
  </head>
  <body>

    <header class="">
      <nav class="navbar navbar-expand-md navbar-dark fixed-top bg-dark" style="height:56px">
        <div class="navbar navbar-expand-md fixed-top bg-dark">
          <a class="navbar-brand" href="{{  url('/') }}">Gfects</a>
          <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
          </button>
          <div class="collapse navbar-collapse" id="navbarCollapse">
          <input class="form-control form-control-dark" type="text" placeholder="Search" style="max-width:100%" aria-label="Search" id="search">
          <div class="search_suggestion" id="search_suggestion" style="position: absolute;width:350px;">
                <ul class="list-unstyled activity-list" id="search_suggestion_item" style="margin-top: 125px;"> 
                </ul>                 
          </div>
            <!--div class="mr-auto"></div-->
            <ul class="navbar-nav ">
              <li class="nav-item active">
                <a class="nav-link" href="{{  url('/') }}/">Home <span class="sr-only">(current)</span></a>
              </li>
              @if(Auth::check())
                <li class="nav-item active">
                <a class="nav-link" href="{{  url('user/dashboard') }}"> Dashboard <span class="sr-only">(current)</span></a>
              </li>
              @endif
                @guest
                <!-- <li class="nav-item">
                  <a class="nav-link" href="{{  url('/') }}/G-pages">G-pages</a>
                </li> -->
                <li>
                  <a class="nav-link" href="{{ url('register') }}" >
                          Register
                      </a>
                </li>
                <li>
                  <a class="nav-link" href="{{ url('login') }}" >
                          Login
                      </a>
                </li>
              @else
                <li>
                    <a class="nav-link"><span>{{ucfirst(Auth::user()->username)}}</span></a>
                </li>
                <li>
                    <a class="nav-link" href="{{ url('logout') }}" >
                            Logout
                      </a>
                </li>
              @endguest
            </ul>
          </div>
        </div>
          
      </nav>
    </header>
    <main role="main">
      @if(session('success'))
           <div class="alert alert-success" role="alert" style="position: absolute;margin-top: -60px;margin-left: 450px;">{{session('success')}}</div>
      @elseif(session('error'))
           <div class="alert alert-danger" role="alert">{{session('error')}}</div>
      @endif
      @yield('section_content_top')
      <div class="container marketing" style="margin-top: 100px;">
      <!-- switch account code start here -->
      @if(Auth::check())
          <?php
            if(Auth::user()->role == 2) {
              $account_type = App\User::account_type(Auth::user()->id);
            }else{
              $account_type = 0;
            }
          ?>
          <div class="row">
            <div class="col-8">
                <strong style="font-size: 25px;">Account Type:</strong>
                @if($account_type == 1)
                  <span class="acount-type">Publisher</span>
                @elseif($account_type == 2)
                  <span class="acount-type">Agency/Business</span>
                @else
                  <span class="acount-type">User</span>
                @endif
            </div> 
            @if(Auth::user()->role == 2 && $account_type == 1)
              <div class="col-4">
                  <strong style="font-size: 25px;">Switch TO Creator A/c</strong> 
                  <label class="switch switch_icon">
                    <input type="checkbox">
                    <span class="slider round"></span>
                  </label>
              </div>
            @endif
          </div>
        @endif
         <!-- switch account code end here -->
      @yield('content')
      </div>
      @yield('section_content_3')

<!-- /.container -->


      <!-- FOOTER -->
     <footer class="container py-5">
      <div class="row">
        <div class="col-12 col-md">
          <small class="d-block mb-3 text-muted">&copy; 2018-2019</small>
        </div>
        <div class="col-6 col-md">
          <!--h5>Features</h5-->
          <ul class="list-unstyled text-small">
            <li><a class="text-muted" href="{{ url('/') }}/about">About Us</a></li>
          </ul>
        </div>
        <div class="col-6 col-md">
          <!--h5>Resources</h5-->
          <ul class="list-unstyled text-small">
            <li><a class="text-muted" href="{{ url('/') }}/feedback">Feedback</a></li>
          </ul>
        </div>
        <div class="col-6 col-md">
          <!--h5>Resources</h5-->
          <ul class="list-unstyled text-small">
            <li><a class="text-muted" href="{{ url('/') }}/privacy">Privacy Policy</a></li>
          </ul>
        </div>
        <div class="col-6 col-md">
          <!--h5>About</h5-->
          <ul class="list-unstyled text-small">
            <li><a class="text-muted" href="{{ url('/') }}/teams">Teams</a></li>
          </ul>
        </div>
      </div>
    </footer>
    </main>
<script type="text/javascript">
  $(document).ready(function(){
    $('body').on('click', '.switch_icon', function(e) {
      bootbox.confirm({
        message: "Are you sure want to switch account ?",
        buttons: {
            cancel: {
                label: '<i class="fa fa-times"></i> Cancel'
            },
            confirm: {
                label: '<i class="fa fa-check"></i> Confirm'
            }
        },
        callback: function (result) {
          window.location.href = "<?=url('switch-account')?>";
        }
      });
    });
    $('body').on('keyup', '#search', function(e) {
      $('#search_suggestion_item').html('');
      if($('#search').val().length >2){
        //alert($('#search').val());
        var key = $('#search').val();
        $.ajax({
          type: "POST",
          url: site_url+"/ajax/search-gpages",
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: {search_key: key},
          success: function(res){
             var data = jQuery.parseJSON(res);
             if(data.status){
              //toastr.success(data.msg);
              $('#search_suggestion_item').html(data.output);
                
             }else{
              //toastr.error(data.msg);
             }
          }
        });
      }
    });
  });
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js" integrity="sha384-cs/chFZiN24E4KMATLdqdvsezGxaGsi4hLGOzlXwp5UZB1LY//20VyM2taTB4QvJ" crossorigin="anonymous"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/js/bootstrap.min.js" integrity="sha384-uefMccjFJAIv6A+rW+L4AHf99KvxDjWSu1z9VI8SKNVmz4sk7buKt/6v9KI65qnm" crossorigin="anonymous"></script>
<script src="https://code.jquery.com/ui/1.12.0/jquery-ui.min.js" integrity="sha256-eGE6blurk5sHj+rmkfsGYeKyZx3M4bG+ZlFyA7Kns7E=" crossorigin="anonymous"></script>
<script src="{{asset('vendor/toastr/toastr.min.js')}}"></script>
<script src="{{asset('vendor/ckeditor/ckeditor.js')}}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/4.4.0/bootbox.min.js"></script>
<script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/jquery.validate.min.js"></script>
<script src="{{asset('js/custom.js')}}"></script>
<!-- <script src="{{asset('js/bootbox.js')}}"></script> -->
@yield('ext_scripts')
  </body>
</html>