<?php
    $product_id = session()->get('product_id');
    $product_name =session()->get('product_name'); 
    $url_name = preg_replace('/[^A-Za-z0-9]/', '-', $product_name);
    $url_name = strtolower(preg_replace('/-+/', '-', $url_name));
?>
<!DOCTYPE html>
<html lang="en">
 @include('users.inc.head')
  <body class="app sidebar-mini rtl pace-done sidenav-toggled">
      <div class="mask"></div>
      @include('users.inc.side_pop_up') 
    <!-- Navbar-->
    <header class="app-header">
        
        <h4 class="header-title">
          {{$user_details[0]->name}}
        </h4>        
        <!-- Sidebar toggle button--><a class="sidepopup-switch" href="#" aria-label="Hide Sidebar">
            <img src="{{asset('assets_web/img/icons/menu.png')}}" height="16"/>
        </a>
      <!-- Navbar Right Menu-->
      @include('users.inc.nav_right_menu')
    </header>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">
      @include('users.inc.app_side_bar')
    </aside>
    <main class="app-content">
      <div class="row">
          <div class="col-md-12">
              <h4 class="text-center">
              @if($user_details[0]->role == 1) 
                Admin Activity
              @elseif($user_details[0]->role == 2) 
                Publisher Activity
              @else
                User Activity
              @endif
              </h4>
              <div class="table-responsive">
                  <table class="table table-striped datatable">
                      <thead>
                        <tr>
                            <th>#SN</th>
                           <!--  <th>Type</th> -->
                            <th>Activity</th>
                            <th>Created_at</th>
                            <th>Action</th>
                        </tr>
                      </thead>
                      <tbody>
                      @if(count($activity_list))
                        @foreach($activity_list as $key=>$value)
                          <tr>
                              <td>{{++$key}}</td>
                              <!-- <td>{{$value->type}}</td> -->
                              <td>{{$value->activity}}</td>
                              <td>{{$value->created_at}}</td>
                              <td><span class="btn btn-info delete_activity_btn"  data-id="{{$value->serial_number}}" style="padding: 0px 10px 5px 10px">Delete</span></td>
                          </tr>
                        @endforeach
                      @endif
                      </tbody>
                  </table>
              </div>    
          </div>
        </div>  
    </main>
     @include('users.inc.footer_js_lib')
    <!-- Essential javascripts for application to work-->
    <script type="text/javascript">
      $(document).ready(function(){
        $('body').on('click', '.delete_activity_btn', function(e) {
            var id = $(this).data('id');
            if(id != "" || id != undefined){
                bootbox.confirm({
                    message: "Are you sure want to delete ?",
                    buttons: {
                        cancel: {
                            label: '<i class="fa fa-times"></i> Cancel'
                        },
                        confirm: {
                            label: '<i class="fa fa-check"></i> Confirm'
                        }
                    },
                    callback: function (result) {
                        $.ajax({
                          type: "POST",
                          url: site_url+"/user/delete-activity",
                          headers: {
                              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                          },
                          data: {id:id},
                          success: function(res){
                             var data = jQuery.parseJSON(res);
                             if(data.status){
                              toastr.success(data.msg);
                              setTimeout(function(){
                                 window.location.reload(true);
                              }, 900);
                                
                             }else{
                              toastr.error(data.msg);
                              setTimeout(function(){
                                 // window.location.reload(true);
                              }, 900);
                             }
                          }
                      });
                    }
                });
            }
        });
        // datatable 
        var t = $('.datatable').DataTable();
            t.on( 'order.dt search.dt', function () {
                t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
                    cell.innerHTML = i+1;
                } );
            } ).draw();
      });
      </script>
  </body>
</html>