<?php
    $product_id = session()->get('product_id');
    $product_name =session()->get('product_name'); 
    $url_name = preg_replace('/[^A-Za-z0-9]/', '-', $product_name);
    $url_name = strtolower(preg_replace('/-+/', '-', $url_name));
?>
<!DOCTYPE html>
<html lang="en">
 @include('users.inc.head')
  <body class="app sidebar-mini rtl pace-done sidenav-toggled">
      <div class="mask"></div>
      @include('users.inc.side_pop_up') 
    <!-- Navbar-->
    <header class="app-header">
        
        <h4 class="header-title">Notifications List</h4>        
        <!-- Sidebar toggle button--><a class="sidepopup-switch" href="#" aria-label="Hide Sidebar">
            <img src="{{asset('assets_web/img/icons/menu.png')}}" height="16"/>
        </a>
      <!-- Navbar Right Menu-->
      @include('users.inc.nav_right_menu')
    </header>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">
      @include('users.inc.app_side_bar')
    </aside>
    <main class="app-content">
    <?php
      $this->product_model = new App\product;
      $total_likes = $this->product_model->get_total_likes_by_page_id($product_id);
      $total_unlikes = $this->product_model->get_total_dislikes_by_page_id($product_id);
      $total_comments = $this->product_model->get_total_comments_by_page_id($product_id);
      $like_status = $this->product_model->page_like_status_by_user(Auth::user()->id,$product_id); 
    ?>
     <div class="widget">
        <table>
            <tr>
                <td><i class="fa fa-thumbs-up"></i></td>
                <td>
                    <p>{{$total_likes}}</p>
                    <h4><a href="#" class="like_action" data-page_id="{{$product_id}}" data-like_status="{{$like_status == 'yes'?'yes':'no'}}">Likes</a></h4>
                </td>
                <td><i class="fa fa-thumbs-down"></i></td>
                <td>
                    <p>{{$total_unlikes}}</p>
                    <h4><a href="#" class="dislike_action" data-page_id="{{$product_id}}" data-like_status="{{$like_status == 'yes'?'yes':'no'}}">Unlikes</a></h4>
                </td>
                <td><i class="fa fa-plus"></i></td>
                <td>
                    <p>1.3K</p>
                    <h4><a href="#">Add</a></h4>
                </td>
                <td><i class="fa fa-share-alt"></i></td>
                <td>
                    <p>0</p>
                    <h4><a href="#">Share</a></h4>
                </td>
                <td><i class="fa fa-comment" style="color:#f05b28"></i></td>
                <td>
                    <p>{{$total_comments}}</p>
                    <h4><a class="comment_action" href="#" data-page_id="{{$product_id}}">Comments</a></h4>
                </td>
            </tr>
            <tr>
                <td colspan="3" class="text-center">
                    <h3>By User Aggto</h3>
                </td>
                <td colspan="4" class="text-center">
                    <h3>Last Updated May 1, 2018</h3>
                </td>
                <td colspan="3" class="text-center">
                    <h3>Last Updated May 1, 2018</h3>
                </td>
            </tr>
          </table>
      </div>
      <div class="row">
          <div class="col-md-12">
              <h4 class="text-center">Notifications</h4>
              <div class="table-responsive">
                  <table class="table table-striped">
                      <thead>
                        <tr>
                            <th>#SN</th>
                            <th>From</th>
                            <th>Messsage</th>
                            <th>Status</th>
                            <th>Created At</th>
                            <th>Action</th>
                        </tr>
                      </thead>
                      <tbody>
                      @if(count($notifications))
                        @foreach($notifications as $key=>$value)
                          <tr>
                              <td>{{++$key}}</td>
                              <td>{{$value->from}}</td>
                              <td>{{$value->message}}</td>
                              <td>
                                @if(empty($value->read_at))
                                  <span class="label label-danger">Unread</span>
                                @else
                                  <span class="label label-success">Read</span>
                                @endif
                              </td>
                              <td>{{$value->created_at}}</td>
                              <td>{{$value->updated_at}}</td>
                              <td>
                                  <span class="label label-danger common_action" data-id="{{$value['id']}}">Delete</span>
                              </td>
                          </tr>
                        @endforeach
                      @endif
                    </tbody>
                  </table>
              </div>   
          </div>
      </div>   
    </main>
     @include('users.inc.footer_js_lib')
    <!-- Essential javascripts for application to work-->
    <script type="text/javascript">
      $(document).ready(function(){
        $('body').on('click', '.common_action', function(e) {
          var id = $(this).data('id');
          if(id != "" || id != undefined){
            bootbox.confirm({
              message: 'Are You sure want to delete ?',
              buttons: {
                  cancel: {
                      label: '<i class="fa fa-times"></i> Cancel'
                  },
                  confirm: {
                      label: '<i class="fa fa-check"></i> Confirm'
                  }
              },
              callback: function (result) {
                if(result){
                  $.ajax({
                      type: "POST",
                      url: site_url+"/user/delete-notification",
                      headers: {
                          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                      },
                      data: {id: id},
                      success: function(res){
                         var data = jQuery.parseJSON(res);
                         if(data.status){
                          setTimeout(function(){
                             window.location.reload();
                          }, 900);
                            
                         }else{
                          setTimeout(function(){
                              window.location.reload();
                          }, 900);
                         }
                      }
                  });
                  return true;
                }
              }
            });
          }
        });
      });
      </script>
  </body>
</html>