<?php
    $product_id = session()->get('product_id');
    $product_name =session()->get('product_name'); 
    $url_name = preg_replace('/[^A-Za-z0-9]/', '-', $product_name);
    $url_name = strtolower(preg_replace('/-+/', '-', $url_name));
?>
<!DOCTYPE html>
<html lang="en">
  @include('users.inc.head')
  <body class="app sidebar-mini rtl pace-done sidenav-toggled">
      <div class="mask"></div>
        @include('users.inc.side_pop_up') 
    <!-- Navbar-->
    <header class="app-header">
        
        <h4 class="header-title">Edit profile</h4>
        
        <!-- Sidebar toggle button--><a class="sidepopup-switch" href="#" aria-label="Hide Sidebar">
             <img src="{{asset('assets_web/img/icons/menu.png')}}" height="16"/>
        </a>
      <!-- Navbar Right Menu-->
       @include('users.inc.nav_right_menu')
       <style type="text/css">
        .error{color:#800000;}     
        </style>
    </header>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">
    @include('users.inc.app_side_bar')
    </aside>
    <main class="app-content">
    <form class="form-auth-small" action="{{url('user/profile-info')}}" method="post" enctype="multipart/form-data" id="user_profile_frm">
      <div class="row">
        <div class="col-md-4" style='float: none; margin: auto'>          
            @csrf
            <input type="hidden" name="user_id" value="{{$user[0]->id}}">
            <div class="form-group">
              <label  class="control-label ">First Name</label>
              <input type="text" class="form-control" name="first_name"  value="{{$user?$user[0]->first_name:''}}" required>
              <br>
              @if ($errors->has('first_name'))
                  <span class="error" role="alert">
                      <strong>{{ $errors->first('first_name') }}</strong>
                  </span>
              @endif
            </div>
            <div class="form-group">
              <label  class="control-label">Last Name</label>
              <input type="text" class="form-control" name="last_name"  value="{{$user?$user[0]->last_name:''}}" required>
              <br>
              @if ($errors->has('last_name'))
                  <span class="error" role="alert">
                      <strong>{{ $errors->first('last_name') }}</strong>
                  </span>
              @endif
            </div>
            <div class="form-group">
              <label  class="control-label ">Date of birth</label>
              <input type="date" class="form-control" name="date_of_birth"  value="{{$user?$user[0]->date_of_birth:''}}" required>
              <br>
              @if ($errors->has('date_of_birth'))
                  <span class="error" role="alert">
                      <strong>{{ $errors->first('date_of_birth') }}</strong>
                  </span>
              @endif
            </div>
            <div class="form-group">
              <label class="control-label ">Email</label>
              <input type="email" class="form-control" name="email"  value="{{$user?$user[0]->email:''}}" required readonly>
              <br>
              @if ($errors->has('email'))
                  <span class="error" role="alert">
                      <strong>{{ $errors->first('email') }}</strong>
                  </span>
              @endif
            </div>
            <div class="form-group">
              <label class="control-label ">Username</label>
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text">@</span>
                  </div>
                  <input type="text" class="form-control " id="username" name="username" value="{{$user?$user[0]->username:''}}" placeholder="Username" required readonly>
                  <br>
                  @if ($errors->has('username'))
                      <span class="error" role="alert">
                          <strong>{{ $errors->first('username') }}</strong>
                      </span>
                  @endif
                </div>
            </div>
            <button type="submit" class="btn btn-primary btn-lg btn-block">Update</button>
            <div class="bottom text-center">
            </div>
        </div>
         <div class="col-md-6"> 
            <div class="form-group">
             <div class="form-group">
              <label class="control-label ">Preview</label>
                <img src="{{$user?$user[0]->profile_picture:''}}" width="250px" height="200px" id="profile_pic_preview" />
              </div>
              <label class="control-label ">Profile Picture</label>
                <div class="input-group">
                 <input type="file" id="profile_pic" name="profile_pic"  class="form-control" onchange="readURL(this,'','profile_pic_preview')">
                  <br>
                  @if ($errors->has('username'))
                      <span class="error" role="alert">
                          <strong>{{ $errors->first('username') }}</strong>
                      </span>
                  @endif
                </div>
            </div>
         </div>
      </div>
    </form>
  </main>
    <!-- Essential javascripts for application to work-->
   @include('users.inc.footer_js_lib')
   <script type="text/javascript">
     function readURL(input,id,preview_id){
        var max_size = 1048576 * 4;
        var ext = input.files[0]['name'].substring(input.files[0]['name'].lastIndexOf('.') + 1).toLowerCase();
        if(ext == "gif" || ext == "png" || ext == "jpeg" || ext == "jpg"){
        }else{
            //alert("Please upload only png|jpg|jpeg image.");
            toastr.warning('Please upload only png, jpg, jpeg image.');
            $('#'+id).val('');
            return false;
        }
        if(input.files[0].size >max_size){
            //alert("File size should be equal or less than 4MB");
            toastr.warning('File size should be equal or less than 4MB');
            $('#'+id).val('');
            return false;
        }
        if (input.files && input.files[0] && (ext == "gif" || ext == "png" || ext == "jpeg" || ext == "jpg")){
            var reader = new FileReader();
            reader.onload = function (e) {
                $('#'+preview_id).attr('src', e.target.result);
            }

            reader.readAsDataURL(input.files[0]);
        }else{
             //$('#img').attr('src', '/assets/no_preview.png');
        }
    }

   </script>
  </body>
</html>