<?php
    $product_id = session()->get('product_id');
    $product_name =session()->get('product_name'); 
    $url_name = preg_replace('/[^A-Za-z0-9]/', '-', $product_name);
    $url_name = strtolower(preg_replace('/-+/', '-', $url_name));
?>
<!DOCTYPE html>
<html lang="en">
 @include('users.inc.head')
  <body class="app sidebar-mini rtl pace-done sidenav-toggled">
      <div class="mask"></div>
      @include('users.inc.side_pop_up') 
    <!-- Navbar-->
    <header class="app-header">
        
        <h4 class="header-title">
          {{$user_details[0]->name}} Gpages
        </h4>        
        <!-- Sidebar toggle button--><a class="sidepopup-switch" href="#" aria-label="Hide Sidebar">
            <img src="{{asset('assets_web/img/icons/menu.png')}}" height="16"/>
        </a>
      <!-- Navbar Right Menu-->
      @include('users.inc.nav_right_menu')
    </header>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">
      @include('users.inc.app_side_bar')
    </aside>
    <main class="app-content" style="margin-top: 50px">       
      <div class="row">         
          <div class="col-md-5" style='float:none; margin: auto'>
            @if(count($gpages_list))
              @foreach($gpages_list as $key=>$value)
                <?php 
                  $image = json_decode($value->image);
                  $this->product_model = new \App\Product;
                  $total_likes = $this->product_model->get_total_likes_by_page_id($value->id);
                  $total_unlikes = $this->product_model->get_total_dislikes_by_page_id($value->id);
                  $total_comments = $this->product_model->get_total_comments_by_page_id($value->id);
                  $total_fllowers = $this->product_model->get_total_fllowers_by_page_id($value->id);
                  $page_name = preg_replace('/[^A-Za-z0-9]/', '-', $value->name);
                  $page_name = preg_replace('/-+/', '-', $page_name);
                 if(Auth::check()){
                    $like_status = $this->product_model->page_like_status_by_user(Auth::user()->id,$value->id);
                  }else{
                    $like_status = 0;
                  }
                ?>
                <div class="more-product">
                  <div class="more-product-info">
                      <div class="more-product-img"><img src="{{asset($image[0]->url)}}"/></div>
                      <p><a href="{{url('product/'.strtolower($page_name).'/about/'.$value->id)}}">{{$value->description}}</a></p>
                  </div>
                  <div class="more-product-assets">
                      <table>
                        <tr>
                            <td style='font-weight: bold'>
                                <img src="{{$value->profile_picture}}"/> {{$value->username}}
                            </td>
                            <td><i class="fa fa-thumbs-up"></i></td>
                            <td>
                                <p>{{$total_likes}}</p>
                                <h4><a href="#" class="like_action" data-page_id="{{$value->id}}" data-like_status="{{$like_status == 'yes'?'yes':'no'}}">Likes</a></h4>
                            </td>
                            <td><i class="fa fa-thumbs-down"></i></td>
                            <td>
                                <p>{{$total_unlikes}}</p>
                                <h4><a href="#" class="dislike_action" data-page_id="{{$value->id}}" data-like_status="{{$like_status == 'yes'?'yes':'no'}}"> Unlikes</a></h4>
                            </td>
                            <td><i class="fa fa-eye"></i></td>
                            <td>
                                <p>{{$value->view_count}}</p>
                                <h4><a href="#">Views</a></h4>
                            </td>
                            <td><i class="fa fa-comment" style="color:#f05b28"></i></td>
                            <td>
                                <p>{{$total_comments}}</p>
                                <h4><a target="_blank" class="comment_action" data-page_id="{{$value->id}}" href="{{url('user/gpages-comment/'.$value->id)}}">Comments</a></h4>
                            </td>
                        </tr>
                    </table>
                  </div>
                </div>
              @endforeach
            @endif
        </div>
      </main>
     @include('users.inc.footer_js_lib')
    <!-- Essential javascripts for application to work-->
  </body>
</html>