<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Notifications\MyNotification;
use Auth;
use App\User;
use App\Product;
use App\Feedback;
use App\Support;
use App\ReportedReason;
use App\Mail\admin_mails;
use DB;
use Session;
Use Mail;
use Crypt;
use QrCode;
class DashboardController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->user_model = new User;
        $this->product_model = new Product;
    }
    public function index()
    {
        $data['user'] = $this->user_model->get_recent_user_list(5);
        $data['title'] = "Dashboard";
        $data['meta_description'] = "";
        $data['total_users']=User::all()->count();
        $data['total_draft']=Product::where('status','1')->count();
        $data['total_approved']=Product::where('status','3')->count();
        $data['total_rejected']=Product::where('status','4')->count();
        $data['total_published']=Product::all()->count();
        return view('admin.index',$data);
    }

    public function to_be_approved_gpages(){
        $status = array(2);
        $data['gpages'] = $this->product_model->gpages_list_by_status($status);
        $data['title'] = "To Be Approved Gpages";
        $data['meta_description'] = "";
        return view('admin.to_be_approved_gpages',$data);
    }
    public function approved_gpages(){
        $status = array(3);
        $data['gpages'] = $this->product_model->gpages_list_by_status($status);
        $data['title'] = "Approved Gpages";
        $data['meta_description'] = "";
        return view('admin.approved_gpages',$data);
    }
    public function rejected_approved_gpages(){
        $status = array(4);
        $data['gpages'] = $this->product_model->gpages_list_by_status($status);
        $data['title'] = "Rejected Approved Gpages";
        $data['meta_description'] = "";
        return view('admin.rejected_approved_gpages',$data);
    }
    public function delete_gpages(Request $request){
        $id= $request->product_id;
        $admin_id =  Auth::guard('admin')->user()->id;
        $user_id = $request->user_id;
        $to = $request->email;
        if(isset($id) && !empty($id)){
            //send support message to publisher
            $product =  $this->product_model->product_details_by_id($id);
            $subject = 'Your G-Page Review Feedback';
            $message = 'p><strong>Hello publisher,</strong></p>
                        <p>Your G-Pages has been deleted.</p>
                        <p> <strong>G-page Details</strong></p>
                        <p><strong>G-page: </strong>'.$product->name.'</p>
                        <p><strong>Barcode: </strong>'.$product->bar_code.'</p>
                        <p><strong>Category: </strong>'.$product->category_name.'</p>';
            $data = array(
                'to' => $to ,
                'from' => Auth::guard('admin')->user()->email,
                'subject' => "Your G-Page Review Feedback",
                'msg' =>'',
                'product_name' => $product->name,
                'barcode' => $product->bar_code,
                'category' => $product->category_name,

            );
            Mail::send('email.delete_gpages',$data, function($message) use ($data) {
                $message->to($data['to'])->subject($data['subject']);
                $message->from($data['from'],'Gfects');
            });
            if(DB::table('product')->where('id', '=', $id)->delete()){
                $response['status'] = true;
                $response['msg'] = "Gpage has been deleted successfully!";
                Session::flash('success', 'Gpage has been deleted successfully!');
            }else{
                $response['status'] = false;
                Session::flash('error', 'Internal server error!');
                $response['msg'] = "Internal server error!";
            }
        }else{
            $response['status'] = false;
            $response['msg'] = "Invalid product id!";
            Session::flash('error', 'Internal server error!');
        }
        echo json_encode($response);
    }
    public function update_gpages_status(Request $request){
        $product_id = $request->product_id;
        $status = $request->status;
        $admin_id =  Auth::guard('admin')->user()->id;
        $user_id = $request->user_id;
        $to = $request->email;
        $message = '';
        if(DB::table('product')->where('id', $product_id)->update(['status'=>$status, 'updated_at'=>date('Y-m-d H:i:s')])){
            $product =  $this->product_model->product_details_by_id($product_id);
            //qrcode generate
            /*if($status == 3){
                $qrcode_img_name = time()."."."png";
                $page_info_url = url('admin/gpage-info/'.$product_id);
                QrCode::size(2500)->backgroundColor(255,55,0)->format('png')->generate($page_info_url, public_path('qrcode/'.$qrcode_img_name));
                DB::table('product')->where('id', $product_id)->update(['qr_code'=>'qrcode/'.$qrcode_img_name, 'updated_at'=>date('Y-m-d H:i:s')]);
            }*/
            //send support message to publisher
            $subject = 'Your G-Page Review Feedback';
            $message = 'p><strong>Hello publisher,</strong></p>
                        <p>Congratulations! Your G-Pages has been approved.</p>
                        <p> <strong>G-page Details</strong></p>
                        <p><strong>G-page: </strong>'.$product->name.'</p>
                        <p><strong>Barcode: </strong>'.$product->bar_code.'</p>
                        <p><strong>Category: </strong>'.$product->category_name.'</p>';
            //send email to publisher
            $data = array(
                'to' => $to ,
                'from' => Auth::guard('admin')->user()->email,
                'subject' => "Your G-Page Review Feedback",
                'msg' =>'',
                'product_name' => $product->name,
                'barcode' => $product->bar_code,
                'category' => $product->category_name,

            );
            Mail::send('email.approved_gpages',$data, function($message) use ($data) {
                $message->to($data['to'])->subject($data['subject']);
                $message->from($data['from'],'Gfects');
            });
            $response['status'] = true;
            Session::flash('success', 'Gpages status  updated successfully!');
            $response['msg'] = "Gpages status  updated successfully!";
        }else{
            $response['status'] = false;
            Session::flash('error', 'Internal server error!');
            $response['msg'] = "Internal server error!";
        }
        echo json_encode($response);
    }
    public function reject_message_to_publisher(Request $request){
        $subject = $request->subject;
        $message = $request->message;
        $admin_id =  Auth::guard('admin')->user()->id;
        $user_id = $request->user_id;
        $to = $request->to;
        $product_id = $request->product_id;
        $product =  $this->product_model->product_details_by_id($product_id);
        if(isset($message ) && !empty($message )){
            DB::table('product')->where('id', $product_id)->update(['status'=>4, 'updated_at'=>date('Y-m-d H:i:s')]);
            //send email to publisher.
            $data = array(
                'to' => $to ,
                'from' => Auth::guard('admin')->user()->email,
                'subject' => $subject,
                'msg' =>$message,
                'product_name' => $product->name,
                'barcode' => $product->bar_code,
                'category' => $product->category_name,

            );
            Mail::send('email.reject_approvel',$data, function($message) use ($data) {
                $message->to($data['to'])->subject($data['subject']);
                $message->from($data['from'],'Gfects');
            });
            $response['status'] = true;
            $response['msg'] = "Gpages status  updated successfully and Message sent  to publisher!";
            Session::flash('success', 'Gpages status  updated successfully and Message sent  to publisher!');
        }else{
            $response['status'] = false;
            $response['msg'] = "Message can not be empty.";
            Session::flash('error', 'Message can not be empty!');
        }
        echo json_encode($response);
    }
    public function user_info(Request $request){
        $id = $request->id;
        $user_details = $this->user_model->get_user_details_by_id($id);
        if (User::find($id)->email_verified_at==null) {
            $data['emailverfy'] = 'Not verify';
        } else {
            $data['emailverfy'] = 'done';
        }
        $data['gpages'] = Product::where('user_id',$id)->get();
        $data['user'] = $user_details;
        $data['title'] = "User Info";
        $data['gpageCount'] = Product::where('user_id',$id)->count();
        $data['flagCount'] = DB::table('reported_product')->count();
        $data['meta_description'] = "";
        //print_r($data);exit;
        return view('admin.user_info',$data);
    }
    public function gpage_info(Request $request){
        $id = $request->id;
        $product = $this->product_model->product_details_by_id($id);
        $data['product'] = $product;
        $data['title'] = "G-Pages Info";
        //print_r($data);exit;
        //echo $id;exit;
        return view('admin.gpages_info',$data);
    }
    public function random_strings($length_of_string) {
        $str_result = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
        return substr(str_shuffle($str_result),  0, $length_of_string);
    }
    public function user_list()
    {
        $data['user'] = $this->user_model->get_recent_user_list();
        $data['title'] = "Users List";
        $data['meta_description'] = "";
        return view('admin.user_list',$data);
    }
    public function user_account_review(Request $request){
        $subject = $request->subject;
        $message = $request->message;
        $admin_id =  Auth::guard('admin')->user()->id;
        $user_id = $request->user_id;
        $to = $request->to;
        $status = $request->user_status;
        if(isset($message ) && !empty($message )){
            if($status == 5){
                DB::table('users')->where('id', $user_id)->update(['verify_by_admin'=>1, 'updated_at'=>date('Y-m-d H:i:s')]);
                $data = array(
                    'to' => $to ,
                    'from' => Auth::guard('admin')->user()->email,
                    'subject' => $subject,
                    'msg' =>$message,

                );
                /*Mail::send('email.user_account_review',$data, function($message) use ($data) {
                    $message->to($data['to'])->subject($data['subject']);
                    $message->from($data['from'],'Gfects');
                });*/
                Mail::to($to)
                ->queue(new admin_mails($data));
                $response['status'] = true;
                $response['msg'] = "Gfects Agency/Business account review feedback has been updated successfully and message sent  to user!";
                Session::flash('success', 'Gfects Agency/Business account review feedback has been updated successfully and message sent  to user!');

            }else{
                DB::table('users')->where('id', $user_id)->update(['status'=>$status, 'updated_at'=>date('Y-m-d H:i:s')]);
                //send email to publisher.
                $data = array(
                    'to' => $to ,
                    'from' => Auth::guard('admin')->user()->email,
                    'subject' => $subject,
                    'msg' =>$message,

                );
                /*Mail::send('email.user_account_review',$data, function($message) use ($data) {
                    $message->to($data['to'])->subject($data['subject']);
                    $message->from($data['from'],'Gfects');
                });*/
                Mail::to($to)
                ->queue(new admin_mails($data));
                $response['status'] = true;
                $response['msg'] = "Gfects publisher account review feedback has been updated successfully and message sent  to publisher!";
                Session::flash('success', 'Gfects publisher account review feedback has been updated successfully and message sent  to publisher!');
            }
        }else{
            $response['status'] = false;
            $response['msg'] = "Message can not be empty.";
            Session::flash('error', 'Message can not be empty!');
        }
        echo json_encode($response);
    }
    public function user_account_delete(Request $request){
        $id = $request->user_id;
        $email = $request->email;
        $subject = "Our Gfects publisher account Review Feedback .";
        $message = "Hello publisher, We are sorry to inform you that your Gfects publisher account has been deleted after review!";
        $data = array(
            'to' => $email,
            'from' => Auth::guard('admin')->user()->email,
            'subject' => $subject,
            'msg' =>$message,

        );
        if($id){
            DB::table('users')->where('id', $id)->update(['status'=>4, 'updated_at'=>date('Y-m-d H:i:s')]);
            Mail::send('email.user_account_review',$data, function($message) use ($data) {
                $message->to($data['to'])->subject($data['subject']);
                $message->from($data['from'],'Gfects');
            });
            $response['status'] = true;
            $response['msg'] = "Gfects publisher account  has been deleted!";
            Session::flash('success', 'Gfects publisher account  has been deleted!');
        }else{
            $response['error'] = false;
            $response['msg'] = "User id can not be empty!";
            Session::flash('error', 'User id can not be empty!');

        }
        echo json_encode($response);
    }
    public function notification()
    {
        $id = Auth::guard('admin')->user()->id;
        $data['notification_list'] = User::notification_list_by_id($id,'all');
        $data['title'] = "Notification";
        $data['meta_description'] = "";
        return view('admin.notification',$data);
    }

    public function delete_notification(Request $request){
        $id = $request->id;
        if(DB::table('notifications')->where('id', '=', $id)->delete()){
            $response['status'] = true;
            Session::flash('success', 'Notification has been deleted successfully!');
        }else{
            $response['status'] = false;
            Session::flash('error', 'Internal server error!');
        }
        return json_encode($response);
    }
    public function read_notification(Request $request){
        $id = $request->id;
        if(DB::table('notifications')->where('id',$id)->update(['read_at' => date('Y-m-d H:i:s')])){
            $response['status'] = true;
            Session::flash('success', 'Notification has been read!');
        }else{
            $response['status'] = false;
            Session::flash('error', 'Internal server error!');
        }
        return json_encode($response);
    }
    public function filter_user(Request $request){
        $columns = array(
            0 =>'id',
            1 =>'name',
            2=> 'email',
            3=> 'type',
            4=> 'status',
            5=> 'created_at',
            6=> 'action'
        );
        $totalData = User::count();
        $totalFiltered = $totalData;
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');

        if(empty($request->input('search.value')))
        {
            $posts = User::offset($start)
                ->whereIn('role',[2,3])
                ->leftJoin('user_details as ud', 'ud.user_id', '=', 'users.id')
                ->limit($limit)
                ->orderBy($order,$dir)
                ->get();
        }else {
            $search = $request->input('search.value');
            $posts = User::where('id','LIKE',"%{$search}%")
                ->whereIn('role',[2,3])
                ->orWhere('name', 'LIKE',"%{$search}%")
                ->orWhere('email', 'LIKE',"%{$search}%")
                ->leftJoin('user_details as ud', 'ud.user_id', '=', 'users.id')
                ->offset($start)
                ->limit($limit)
                ->orderBy($order,$dir)
                ->get();

            $totalFiltered = User::where('id','LIKE',"%{$search}%")
                ->whereIn('role',[2,3])
                ->orWhere('name', 'LIKE',"%{$search}%")
                ->orWhere('email', 'LIKE',"%{$search}%")
                ->leftJoin('user_details as ud', 'ud.user_id', '=', 'users.id')
                ->count();
        }
        $data = array();
        if(!empty($posts))
        {
            foreach ($posts as $post)
            {
                //$show =  route('posts.show',$post->id);
                //$edit =  route('posts.edit',$post->id);
                $span_status="";
                $nestedData['id'] = $post->id;
                $nestedData['name'] = $post->name;
                $nestedData['email'] = $post->email;
                if($post->account_type == 1){
                    $type= '<span class="label label-success">Publisher</span>';
                }elseif($post->account_type == 2){
                    $type = '<span class="label label-success">Business</span>';
                }elseif($post->account_type == 3){
                    $type = '<span class="label label-success">Business</span>';
                }else{
                    $type = '<span class="label label-success">User</span>';
                }
                if($post->status == 1){
                    $status= '<span class="label label-success">Approved</span>';
                    $option = '<option value="">
                                    Choose
                                </option>
                                <option value="1" selected="selected">
                                    Approved
                                </option>
                                <option value="2">
                                    Hold
                                </option>
                                <option value="3">
                                    Suspend
                                </option>
                                <option value="4">
                                    Delete
                                </option>';
                }elseif($post->status == 2){
                    $option = '<option value="">
                                    Choose
                                </option>
                                <option value="1">
                                    Approved
                                </option>
                                <option value="2" selected="selected">
                                    Hold
                                </option>
                                <option value="3">
                                    Suspend
                                </option>
                                <option value="4">
                                    Delete
                                </option>';
                    $status= '<span class="label label-warning">Hold</span>';
                }elseif($post->status == 3){
                    $option = '<option value="">
                                    Choose
                                </option>
                                <option value="1">
                                    Approved
                                </option>
                                <option value="2">
                                    Hold
                                </option>
                                <option value="3" selected="selected">
                                    Suspend
                                </option>
                                <option value="4">
                                    Delete
                                </option>';
                    $status = ' <span class="label label-info">Suspend</span>';
                }elseif($post->status == 4){
                    $option = '<option value="">
                                    Choose
                                </option>
                                <option value="1">
                                    Approved
                                </option>
                                <option value="2">
                                    Hold
                                </option>
                                <option value="3">
                                    Suspend
                                </option>
                                <option value="4" selected="selected">
                                    Delete
                                </option>';
                    $status = '<span class="label label-info">Deleted</span>';
                }else{
                    $status = '<span class="label label-danger">Unapproved</span>';
                }
                $action = '<select class="form-control common_action" style="border-radius: 1px" name="common_action" data-user_id="'.$post->id.'" data-email_id="'.$post->email.'" data-status="'.$post->status.'" id="'.$post->id.'_div_action">
                        '.$option.'
                    </select>';
                $nestedData['status'] = $status;
                $nestedData['type'] = $type;
                //$nestedData['status'] = substr(strip_tags($post->email),0,50)."...";
                $nestedData['created_at'] = date('j M Y h:i a',strtotime($post->created_at));
                $nestedData['action'] =  $action;
                $data[] = $nestedData;

            }
        }
        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data
        );
        echo json_encode($json_data);
    }
    //feedback section
    public function feedback(Request $request){
        $feedback_model = new Feedback;
        $id = Auth::guard('admin')->user()->id;
        $data['feedback_list'] = $feedback_model->get_all_feedback_by_reciver_id($id );
        $data['title'] ="Feedback List";
        //print_r($data);exit;
        return view('admin.feedback_list',$data);
    }
    public function delete_feedback(Request $request){
        $id = $request->id;
        if(DB::table('feedback')->where('serial_number', '=', $id)->delete()){
            $response['status'] = true;
            Session::flash('success', 'Feedback has been deleted successfully!');
        }else{
            $response['status'] = false;
            Session::flash('error', 'Internal server error!');
        }
        return json_encode($response);
    }
    public function feedback_exchange(Request $request){
        $feedback_model = new Feedback;
        $feedback_id = $request->feedback_id;
        $data['feedback'] = $feedback_model->get_feedback_by_id($feedback_id);
        $data['feedback_response'] = $feedback_model->get_feedback_response_by_id($feedback_id);
        $data['title'] ="Feedback Exchange";
        return view('admin.feedback_exchange',$data);
    }
    public function feedback_response(Request $request){
        $message = $request->message;
        $name = $request->name;
        $email = $request->email;
        $id = $request->id;
        $date = date("Y-m-d H:i:s");
        $param = array(
            'parent_id' => $id,
            'message' => $message,
            'created_at' => $date,
            'updated_at' => $date
        );
        //print_r($param);exit;
        $subject = 'Your G-Page  Feedback Response';
        $data = array(
            'to' => $email ,
            'from' => Auth::guard('admin')->user()->email,
            'subject' => "Your G-Page Feedback Response",
            'msg' => $message,
            'name' => $name,
        );
        Mail::send('email.feedback_response',$data, function($message) use ($data) {
            $message->to($data['to'])->subject($data['subject']);
            $message->from($data['from'],'Gfects');
        });
        if( DB::table('feedback')->insert($param)){
            DB::table('feedback')->where('serial_number', $id)->update(['reply_status'=>1, 'updated_at'=>date('Y-m-d H:i:s')]);
            $response['status'] = true;
            Session::flash('success', 'Feedback response has been sent!');
            $response['msg'] ="Feedback response has been sent!";

        }else{
            Session::flash('error', 'Internal server error!');
            $response['status'] = false;
            $response['msg'] ="Internal server error";
        }
        echo json_encode($response);
    }

    //support section
    public function support(Request $request){
        $support_model = new Support;
        $id = Auth::guard('admin')->user()->id;
        $data['support_list'] = $support_model->support_list_by_user_id($id );
        $data['title'] ="Support Messages";
        //print_r($data);exit;
        return view('admin.support_list',$data);
    }
    public function delete_support_message(Request $request){
        $id = $request->id;
        if(DB::table('support')->where('serial_number', '=', $id)->delete()){
            $response['status'] = true;
            Session::flash('success', 'Data has been deleted successfully!');
        }else{
            $response['status'] = false;
            Session::flash('error', 'Internal server error!');
        }
        return json_encode($response);
    }
    public function support_message_exchange(Request $request){
        $support_model = new Support;
        $support_id = $request->support_id;
        $data['support'] = $support_model->get_support_message_by_id($support_id);
        $data['support_response'] = $support_model->get_support_message_response_by_id($support_id);
        $data['title'] ="Support Message Exchange";
        //print_r($data);exit;
        //dd($support_model->get_support_message_response_by_id($support_id));
        return view('admin.support_message_exchange',$data);

    }
    public function support_response(Request $request){
        $message = $request->message;
        $name = $request->name;
        $email = $request->email;
        $reciver_id = $request->reciver_id;
        $id = $request->id;
        $date = date("Y-m-d H:i:s");
        $param = array(
            'sender_id' => Auth::guard('admin')->user()->id,
            'reciver_id' => $reciver_id,
            'message' => $message,
            'parent_id' => $id,
            'message' => $message,
            'created_at' => $date,
            'updated_at' => $date
        );
        //print_r($param);exit;
        $data = array(
            'to' => $email ,
            'from' => 'info@gfects.com',
            'subject' => "G-Page Support Message",
            'msg' => $message,
            'name' => $name,
        );
        Mail::send('email.support_response',$data, function($message) use ($data) {
            $message->to($data['to'])->subject($data['subject']);
            $message->from($data['from'],'Gfects');
        });
        if( DB::table('support')->insert($param)){
            DB::table('support')->where('serial_number', $id)->update(['reply_status'=>1, 'updated_at'=>date('Y-m-d H:i:s')]);
            $response['status'] = true;
            Session::flash('success', 'Support message has been sent!');
            $response['msg'] ="Support message has been sent!";

        }else{
            Session::flash('error', 'Internal server error!');
            $response['status'] = false;
            $response['msg'] ="Internal server error";
        }
        echo json_encode($response);
    }
    //Flagged/Reported section
    public function flagged_list(Request $request){
        $product_model = new Product;
        $id = Auth::guard('admin')->user()->id;
        $data['gpages_list'] = $product_model->reported_product_list($id );
        $data['title'] ="Flagged List";
        //print_r($data);exit;
        return view('admin.flagged_list',$data);
    }
    public function flagged_info(Request $request){
        $id = $request->id;
        $decryp_id = Crypt::decryptString($id);
        $product_model = new Product;
        $data['gpages'] = $product_model->reported_product_details_by_id($decryp_id);
        $data['title'] ="Flagged Info";
        //print_r($data);exit;
        return view('admin.flagged_info',$data);
    }
    public function delete_reported_message(Request $request){
        $id = $request->id;
        if(DB::table('reported_product')->where('serial_number', '=', $id)->delete()){
            $response['status'] = true;
            Session::flash('success', 'Data has been deleted successfully!');
        }else{
            $response['status'] = false;
            Session::flash('error', 'Internal server error!');
        }
        return json_encode($response);
    }
    
    
    //send email view
    public function email(){
        $data['title'] ="Email";
        return view('admin.admin_emailing',$data);
    }
    //send email post
    public function emailpost(Request $request){
        $subject = $request->subject;
        $message = $request->message;
        $to = $request->email;
        $data['title'] ="Email";
        $data = array(
                    'to' => $to ,
                    'from' => Auth::guard('admin')->user()->email,
                    'subject' => $subject,
                    'msg' =>$message,

                );
        Mail::to($request->email)
        ->cc('info@gfects.com')
        ->queue(new admin_mails($data));
        /*return (new admin_mails($data))->render();*/
        $data['sent'] ="Email sent";
        $data['to'] = $to;
        $data['title'] ="Email";
        return view('admin.admin_emailing',$data);
    }
}
