<?php

namespace App\Http\Controllers\Auth;

use App\User;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Http\Request;
use DB;
use Session;
use App\Mail\verifi;
use Illuminate\Support\Facades\Mail;
use App\Country;
use Laravel\Socialite\Facades\Socialite;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:6', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array $data
     * @return \App\User
     */
    protected function create(array $data)
    {
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
    }

    public function showRegisterForm()
    {
        $data = [
            'title' => 'Home',
            'meta_description' => 'Register as a Creator'
        ];
        $country = new Country;
        $data['country'] = $country->all_country();
        //print_r($data);exit;
        #return view('auth.register', $data);
        return view('auth.createAccount', $data);
    }
    
    

    public function getregisterX()
    {
        $data = [
            'title' => 'Home',
            'meta_description' => ''
        ];
        $country = new Country;
        $data['country'] = $country->all_country();
        //print_r($data);exit;
        return view('auth.createAccount', $data);
    }
    public function registerX(Request $request)
    {
        $user_model = new User;
        $token = str_random(40);
        //validation rules params
        $rules = array(
            'first_name' => 'required',
            'last_name' => 'required',
            'dob' => 'required|date|before:-13 years',
            'email' => 'required|email|unique:users',
            'username' => 'required|unique:users',
            'password' => 'min:6|alpha_num|required_with:password_confirmation|confirmed',
            'password_confirmation' => 'required',
            'country' => 'required',
            'state' => 'required',
            'account_type' => 'required',
        );
        //data field parms
        $data = array(
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'dob' => $request->dob,
            'email' => $request->email,
            'username' => $request->username,
            'password' => trim($request->password),
            'password_confirmation' => trim($request->password_confirmation),
            'country' => $request->country,
            'state' => $request->state,
            'account_type' => $request->account_type,

        );
        //validate field
        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
            exit;
        }
        
        $profile_image = "no_image.jpg";

        if ($data['account_type'] == 1) {
            $profile_image = 'https://gfects.com/public/assets_web/img/G-publisher.png';
        } elseif ($data['account_type'] == 2) {
            $profile_image = 'https://gfects.com/public/assets_web/img/G-agent.jpg';
        } elseif ($data['account_type'] == 3) {
            $profile_image = 'https://gfects.com/public/assets_web/img/G-Biz.jpg';

        }
        //check if register by socila site
        $social_id = $request->social_id;
        if (isset($social_id) && !empty($social_id)) {
            $profile_image = $request->social_image;
            $register_by = $request->provider;
        } else {
            $register_by = "email";
            $social_id = "";
        }
        //user tables field params
        $user_param = array(
            'name' => $request->first_name . " " . $request->last_name,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'state' => $request->state,
            'country' => $request->country,
            'username' => $request->username,
            'role' => 2,
            'password' => Hash::make($request->password),
            'date_of_birth' => $request->dob,
            'profile_picture' => $profile_image,
            'register_by' => $register_by,
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
            'verify_token' => $token,
        );
        //social id set in params
        if ($register_by == 'google') {
            $user_param['google_id'] = $social_id;
        } else if ($register_by == 'linkedin') {
            $user_param['linkedin_id'] = $social_id;
        }
        $id = DB::table('users')->insertGetId($user_param);
        if ($id) {
            //user detilas tables field params
            $user_details_param = array(
                'user_id' => $id,
                'account_type' => $request->account_type,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
             DB::table('user_details')->insert($user_details_param);
            //send verification mail to user.
            $data = array(
                'name' => $request->first_name,
                'link' => url('/') . '/email-verification/' . $token,
                'to' => $request->email,
                'from' => 'info@gfects.com',
                'subject' => 'Gfects account activation link.',

            );
            Mail::to($request->email)
                ->queue(new verifi($data));
            Session::flash('success', 'You have been register successfully!');
            Session::forget('social_data');

            return redirect(url('thank-you'));
            
        } else {
            Session::flash('success', 'Some things went wrong.Pls try again!');
            return redirect(url('register'));
        }
        exit;
    }

    public function showUserRegisterForm()
    {
        $data = [
            'title' => 'Home',
            'meta_description' => ''
        ];
        $country = new Country;
        $data['country'] = $country->all_country();
        //print_r($data);exit;
        return view('users.auth.register', $data);
    }

    public function register(Request $request)
    {
        $user_model = new User;
        $token = str_random(40);
        //validation rules params
        $rules = array(
            'first_name' => 'required',
            'last_name' => 'required',
            'dob' => 'required',
            'email' => 'required|email|unique:users',
            'username' => 'required|unique:users',
            'password' => 'min:6|alpha_num|required_with:password_confirmation|confirmed',
            'password_confirmation' => 'required',
            'country' => 'required',
            'state' => 'required',
            'account_type' => 'required',
        );
        //data field parms
        $data = array(
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'dob' => $request->dob,
            'email' => $request->email,
            'username' => $request->username,
            'password' => trim($request->password),
            'password_confirmation' => trim($request->password_confirmation),
            'country' => $request->country,
            'state' => $request->state,
            'account_type' => $request->account_type,

        );

        if (isset($data['account_type']) && $data['account_type'] == 1) {
        } else {
            //data field parms
            $data['company_name'] = $request->company_name;
            $data['company_title'] = $request->company_title;
            $data['company_country'] = $request->company_country;
            $data['company_state'] = $request->company_state;
            $data['company_zip'] = $request->company_zip;
            //validation rules params
            $rules['company_name'] = 'required';
            $rules['company_title'] = 'required';
            $rules['company_state'] = 'required';
            $rules['company_country'] = 'required';
            $rules['company_zip'] = 'digits:5';
        }
        //validate field
        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
            exit;
        }
        //profile image upload
        if ($request->hasFile('profile_pic')) {
            $filenameWithExt = $request->file('profile_pic')->getClientOriginalName();
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $extension = $request->file('profile_pic')->getClientOriginalExtension();
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;
            $destinationPath = public_path('profile_img');
            $request->file('profile_pic')->move($destinationPath, $fileNameToStore);
            //$path=$request->file('squad_image')->storeAs('public/squad_images', $fileNameToStore);
            $profile_image = asset("profile_img/" . $fileNameToStore);
        } else {
            $profile_image = "no_image.jpg";
        }

        if ($data['account_type'] == 1) {
            $profile_image = 'https://gfects.com/public/assets_web/img/G-publisher.png';
        } elseif ($data['account_type'] == 2) {
            $profile_image = 'https://gfects.com/public/assets_web/img/G-agent.jpg';
        } elseif ($data['account_type'] == 3) {
            $profile_image = 'https://gfects.com/public/assets_web/img/G-Biz.jpg';

        }
        //check if register by socila site
        $social_id = $request->social_id;
        if (isset($social_id) && !empty($social_id)) {
            $profile_image = $request->social_image;
            $register_by = $request->provider;
        } else {
            $register_by = "email";
            $social_id = "";
        }
        //user tables field params
        $user_param = array(
            'name' => $request->first_name . " " . $request->last_name,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'state' => $request->state,
            'country' => $request->country,
            'username' => $request->username,
            'role' => 2,
            'password' => Hash::make($request->password),
            'date_of_birth' => $request->dob,
            'profile_picture' => $profile_image,
            'register_by' => $register_by,
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
            'verify_token' => $token,
        );
        //social id set in params
        if ($register_by == 'google') {
            $user_param['google_id'] = $social_id;
        } else if ($register_by == 'linkedin') {
            $user_param['linkedin_id'] = $social_id;
        }
        $id = DB::table('users')->insertGetId($user_param);
        if ($id) {
            //user detilas tables field params
            $user_details_param = array(
                'user_id' => $id,
                'account_type' => $request->account_type,
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            );
            if ($data['account_type'] != 1) {
                $user_details_param['company_name'] = $data['company_name'];
                $user_details_param['company_title'] = $data['company_title'];
                $user_details_param['company_country'] = $data['company_country'];
                $user_details_param['company_state'] = $data['company_state'];
                $user_details_param['company_street'] = $request->company_street;
                $user_details_param['company_city'] = $request->company_city;
                $user_details_param['company_zip'] = $request->company_zip;
                $user_details_param['company_email'] = $request->email;
                $user_details_param['company_phone'] = $request->phone;
            }
                DB::table('user_details')->insert($user_details_param);
            //send verification mail to user.
            $data = array(
                'name' => $request->first_name,
                'link' => url('/') . '/email-verification/' . $token,
                'to' => $request->email,
                'from' => 'info@gfects.com',
                'subject' => 'Gfects account activation link.',

            );
            Mail::send('email.verifyUser', $data, function ($message) use ($data) {
                $message->to($data['to'], $data['name'])->subject($data['subject']);
                $message->from($data['from'], 'Gfects');
            });
            Session::flash('success', 'You have been register successfully!');
            Session::forget('social_data');

            if (isset($data['account_type']) && $data['account_type'] == 1) {
                return redirect(url('login'));
            } else {
                return redirect(url('thank-you'));
            }
        } else {
            Session::flash('success', 'Some things went wrong.Pls try again!');
            return redirect(url('register'));
        }
        exit;
    }

    //this function is used for verify user email
    public function email_verification($token)
    {
        if (!empty($token)) {
            $users = DB::table('users')->select('email', 'email_verified_at')->where('verify_token', $token)->get();
            if (count($users) > 0) {
                if (!empty($users[0]->email_verified_at)) {
                    Session::flash('success', 'You account have already activated!');
                    return redirect(url('login'));
                }
                DB::table('users')->where('verify_token', $token)->update(['email_verified_at' => date('Y-m-d H:i:s'), 'status' => 1]);
                Session::flash('success', 'You have been successfully activated your account!');
                return redirect(url('login'));
            } else {
                Session::flash('error', 'Sorry, Your token is invalid!');
                return redirect(url('login'));
            }
        } else {
            Session::flash('error', 'Sorry, Your token is invalid!');
            return redirect(url('login'));
        }
    }

    public function thank_you()
    {
        $data = [
            'title' => 'Thank You',
            'meta_description' => ''
        ];
        return view('auth.thank_you', $data);
    }

    public function redirectToProvider($provider)
    {
        return Socialite::driver($provider)->redirect();
    }

    public function redirectToProviderUser($provider)
    {
        session(['register' => 'user']);
        return Socialite::driver($provider)->redirect();
    }


    public function handleProviderCallback(Request $rx, $provider)
    {
        if (isset($rx->error)) {
            return Redirect(url('/'));
        }
        try {
            $user = Socialite::driver($provider)->user();
            $name_arr = explode(' ', $user->getName());
        } catch (Exception $ex) {
            echo 'Caught exception: ', $ex->getMessage(), "\n";
        }

        if (Session::has('register')) {
            Session::forget('register');
            if (isset($name_arr[0])) {
                $first_name = $name_arr[0];
            } else {
                $first_name = '';
            }
            if (isset($name_arr[1])) {
                $last_name = $name_arr[1];
            } else {
                $last_name = '';
            }
            $user_data = array(

                'id' => $user->getId(),
                'first_name' => $first_name,
                'last_name' => $last_name,
                'name' => $user->getName(),
                'email' => $user->getEmail(),
                'profile_pic' => $user->getAvatar(),
                'provider' => $provider,
            );
            session(['social_data' => $user_data]);
            return redirect('register');

        }

        $user1 = User::where('email', $user->getEmail())->first();
        if ($user1) {

            Auth::loginUsingId($user1->id);
            if ($user1->role == 1) {
                return redirect()->intended(url('admin/dashboard'));
            } else if ($user1->role == 2) {
                return redirect()->intended(url('creator/dashboard'));
            } else if ($user1->role == 3) {
                return redirect()->intended(url('user/home'));
            }
        } else {
            if (isset($name_arr[0])) {
                $first_name = $name_arr[0];
            } else {
                $first_name = '';
            }
            if (isset($name_arr[1])) {
                $last_name = $name_arr[1];
            } else {
                $last_name = '';
            }
            $user_data = array(
                'id' => $user->getId(),
                'first_name' => $first_name,
                'last_name' => $last_name,
                'name' => $user->getName(),
                'email' => $user->getEmail(),
                'profile_pic' => $user->getAvatar(),
                'provider' => $provider,
            );
            session(['social_data' => $user_data]);
            return redirect('register');
        }


    }
}
