<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use File;
use View;
use App\Product;

class FileUploadController extends Controller
{
    public function __construct()
    {
        //$this->middleware('auth');
        //$this->middleware('auth',['except' => array('/')]);
    }
    
    
    public function file_upload(Request $request)
    {
        
        if($request->hasFile('custom_name')) {
              $folder_name = $request->post('folder_name');
              $type = $request->post('type');
              $filenameWithExt = $request->file('custom_name')->getClientOriginalName();
              $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
              $extension = $request->file('custom_name')->getClientOriginalExtension();//GET FILE TYPE
              $time = time();
              $fileNameToStore = $time.'.'.$extension;
              if($type == 'image'){
                  $validator = Validator::make($request->all(), [
                    "file" => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                  ]);
            
            
                  if($validator->fails()){
                    $response['status'] = false;
                    $response['msg'] = 'Wrong image type';
                    echo json_encode($response);
                    return;
                      
                  }else{
                    $destinationFolder = "uploads/".$folder_name."/image";
                  }
              }else if($type == 'video'){
                $destinationFolder = "uploads/".$folder_name."/video";
              }else{
                $destinationFolder = "uploads/attachment";
              }
              $destinationPath = public_path($destinationFolder);
                        //dd('here');
              if (!file_exists($destinationPath)) {
                File::makeDirectory($destinationPath, $mode = 0777, true, true);

                if ($steps == 4) {
                    $steps = $request->steps;
                    $id = $request->id;
                    $pr = Product::find($id);

                    if($type == 'image'){
                        $product_img_array = $request->product_img_array;
                        #prepare add new img
                        $new_img_arr = [
                            "name" => $fileNameToStore,
                            "url" => $destinationFolder,
                            "id" => $time,
                        ];
                        array_push($product_img_array,$new_img_arr);
                        $product_param = array(
                            'image' => $product_img_array,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        $response['new_imgs'] = $product_img_array;
                      }else if($type == 'video'){
                       $product_param = array(
                           'image' => $request->upload_img,
                           'created_at' => date("Y-m-d H:i:s"),
                           'updated_at' => date("Y-m-d H:i:s"),
                       );
                      }

                      if (DB::table('product')->where('id', $id)->update($product_param)) {
                                 
                                  
                          } else {
                              $response['status'] = false;
                              $response['msg'] = "Internal server error.";
                              echo json_encode($response);
                              return;
                          }
                }
                    
              }else{
              $response['status'] = false;
              $response['msg'] = 'File exist';
                echo json_encode($response);
                              return;
              }
              $response['url'] =  $destinationFolder."/".$fileNameToStore;
              $response['status'] = true;
              $response['msg'] = 'File has been uploaded!';
              $response['name'] = $fileNameToStore;
              $response['id'] = $time;
              $request->file('custom_name')->move($destinationPath, $fileNameToStore);
              if($type == 'image'){
                $view = View::make('creators.ajax.image_div',$response);   
              }else{
                $view = View::make('creators.ajax.video_div',$response);   
              }
              $content = $view->render();
              $response['content'] = $content;
        }else{
              $response['status'] = false;
              $response['msg'] = 'File can not be empty!';
        }
        echo json_encode($response);
        exit;
    }
    
}