<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use Auth;
use DB;
class UserController extends Controller
{
    public function __construct()
    {   
        $this->middleware('user');
        $this->product_model = new Product;
    }

    public function index()
    {
        $data['title'] = 'User Dashboard';
        $data['meta_description'] = '';
        //$this->product_model->update_page_view(1);
        $status = array(1,2,3);
        $data['gpages'] = $this->product_model->get_all_gpages_by_status($status);
        //print_r($data);exit;
        return view('users.index',$data);
    }
    public function gpages_comment(Request $request){
        $id = $request->page_id;
        $message = trim($request->message);
        $date = date('Y-m-d H:i:s');
        if($id){
            $param = array(
                'sender_id' => Auth::user()->id,
                'product_id' => $id,
                'comment'   => $message,
                'created_at' => $date,
                'updated_at' => $date,
            );
            DB::table('product_comment')->insert($param);
            $response['status'] = true;
            $response['msg'] = "Your comment has been published!";
            echo json_encode($response);
            exit;
        }else{
            $response['status'] = false;
            $response['msg'] = "Message can not be empty!";
            echo json_encode($response);
            exit;
        }
    }

    public function gpages_likes(Request $request){
        $id = $request->page_id;
        $status = $request->like_status;
        $date = date('Y-m-d H:i:s');
        $sender_id = Auth::user()->id;
        if($id){
            if($this->product_model->is_page_like_by_user($sender_id,$id)){
                $param = array(
                    'like_status'   => $status,
                    'updated_at' => $date,
                );
                DB::table('product_likes')->where('product_id',$id)->where('sender_id',$sender_id)->update($param);
                $response['msg'] = "Your have disliked this page!";
            }else{
                $param = array(
                    'sender_id' => $sender_id,
                    'product_id' => $id,
                    'like_status'   => $status,
                    'created_at' => $date,
                    'updated_at' => $date,
                );
                DB::table('product_likes')->insert($param);
                $response['msg'] = "Your have liked this page!";
            }
            $response['status'] = true;
            echo json_encode($response);
            exit;
        }else{
            $response['status'] = false;
            $response['msg'] = "Gpage id can not be empty";
            echo json_encode($response);
            exit;
        }
    }
    public function gpages_fllows(Request $request){
        $id = $request->page_id;
        $date = date('Y-m-d H:i:s');
        $user_id = Auth::user()->id;
        if($id){
            if($this->product_model->is_page_flow_by_user($user_id,$id)){
                DB::table('product_fllowers')->where('user_id',$user_id)->where('product_id', $id)->delete();
                $response['msg'] = "Your have unfllow this page!";
            }else{
                $param = array(
                    'user_id' => $user_id,
                    'product_id' => $id,
                    'created_at' => $date,
                    'updated_at' => $date,
                );
                DB::table('product_fllowers')->insert($param);
                $response['msg'] = "Your have fllow this page!";
            }
            $response['status'] = true;
            echo json_encode($response);
            exit;
        }else{
            $response['status'] = false;
            $response['msg'] = "Gpage id can not be empty";
            echo json_encode($response);
            exit;
        }
    }
}
