<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class verifi extends Mailable
{
    use Queueable, SerializesModels;

    public $data;
    
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        //
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $data = [
            'subject' => $this->data['subject'],
            'msg' => 'Thank you for registering for a Gfects account.
                        <br>
                        To complete your registration, click on the link below.
                        <br>',
            'name' => $this->data['name'],
            'link' => $this->data['link'],
        ];
        
        return $this->from('info@gfects.com')
                    ->subject($this->data['subject'])
                    ->markdown('email.verifyUser', $data);
    }
}
