<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;
class Product extends Model
{
    protected $table = 'product';
    protected  $fillable =['name'];

    public function total_created_page_by_user_id($id,$status='')
    {
        $query = DB::table('product')->select('id')->where('user_id', $id);
        if(!empty($status)){
            $query->where('status',$status);
        }
        $result = $query->get()->count();
        return $result;
    }

    public function gpages_list_by_user_id($id,$status=array(),$limit='')
    {
        $query = DB::table('product')
            ->select('product.id','product.name','product.bar_code','product.title','product.price','product.manufactured_by','product.description','product.image','product.status','product.view_count','product_category.name as category_name','product_subcategory.name as subcategory_name','product.created_at','product.updated_at','product.user_id','users.username','users.email','users.profile_picture','user_details.account_type','product.link_id')
            ->where('product.user_id', $id);
        $query->whereIn('product.status',$status);
        $query->join('product_category', 'product.category_id', '=', 'product_category.category_id');
        $query->join('product_subcategory', 'product_subcategory.subcategory_id', '=', 'product.subcategory_id');
        $query->join('users','users.id','=','product.user_id');
        $query->join('user_details','user_details.user_id','=','users.id');
        if(!empty($limit)){
            $query->limit(5);
        }
        $query->orderBy('product.id', 'DESC');
        $result = $query->get();
        return $result;
    }

    public function gpages_list_by_status($status=array(), $category_id='')
    {
        $query = DB::table('product')
            ->select('product.id','product.name','product.bar_code','product.title','product.price','product.manufactured_by','product.description','product.image','product.status','product.view_count','product_category.name as category_name','product_subcategory.name as subcategory_name','product.created_at','product.updated_at','product.user_id','users.username','users.email','users.profile_picture','user_details.account_type');
        $query->whereIn('product.status',$status);
        if(!empty($category_id)){
            $query->where('product.category_id',$category_id);
        }
        $query->join('product_category', 'product.category_id', '=', 'product_category.category_id');
        $query->join('product_subcategory', 'product_subcategory.subcategory_id', '=', 'product.subcategory_id');
        $query->join('users','users.id','=','product.user_id');
        $query->join('user_details','user_details.user_id','=','users.id');
        $result = $query->get();
        return $result;
    }
    public function product_details_by_id($id)
    {
        $result = DB::table('product')
            ->select('product.*','product_category.name as category_name','product_subcategory.name as subcategory_name','countries.name as made_in_name','product.image','msr_price','product.price','currencies.code','currencies.symbol','manufactured_port_no as manufactured_part_no','color_to_show as color','weight','unit_price','dimension','features_feed as features','spec_field as specification','buy_online_link as buy_url','web_page_link as web_url','manufactured_web_page_link as manufactured_url','product.created_at','product.updated_at','users.username','users.email','users.profile_picture')
            ->where('product.id', $id)
            ->join('product_category', 'product.category_id', '=', 'product_category.category_id')
            ->join('product_subcategory', 'product_subcategory.subcategory_id', '=', 'product.subcategory_id')
            ->join('countries', 'countries.id', '=', 'product.made_in')
            ->join('users','users.id','=','product.user_id')
            ->join('currencies','currencies.id','=','product.currency')
            ->get();
        if(count($result) > 0){
            return $result[0];
        }else{
            return $result;
        }
    }
    public function product_id_by_link_id($id)
    {
        $result = DB::table('product')
            ->select('product.id')
            ->where('product.link_id', $id)
            ->get();
        if(count($result) > 0){
            return $result[0]->id;
        }else{
            return false;
        }
    }
    public function get_all_gpages_by_status($status=array())
    {
        $query = DB::table('product')
            ->select('product.id','product.name','product.bar_code','product.title','product.description','product.status','product_category.name as category_name','product_subcategory.name as subcategory_name','product.created_at','product.image','product_likes.like_status','product.view_count','users.username');
        $query->whereIn('product.status',$status);
        $query->join('product_category', 'product.category_id', '=', 'product_category.category_id');
        $query->join('product_subcategory', 'product_subcategory.subcategory_id', '=', 'product.subcategory_id');
        $query->leftJoin('product_likes', 'product_likes.product_id', '=', 'product.id');
        $query->join('users','users.id','=','product.user_id');
        $query->groupBy('product.id');
        //$query->distinct('product.id');
        $result = $query->get();
        return $result;
    }
    public function get_top_gpages_by_status($status=array(),$count_item='')
    {
        $query = DB::table('product')
            ->select('product.id','product.name','product.bar_code','product.title','product.description','product.status','product_category.name as category_name','product_subcategory.name as subcategory_name','product.created_at','product.image','product_likes.like_status','product.view_count','product.exclude_from_feed','users.username');
        $query->whereIn('product.status',$status);
        $query->join('product_category', 'product.category_id', '=', 'product_category.category_id');
        $query->join('product_subcategory', 'product_subcategory.subcategory_id', '=', 'product.subcategory_id');
        $query->leftJoin('product_likes', 'product_likes.product_id', '=', 'product.id');
        $query->join('users','users.id','=','product.user_id');
        $query->groupBy('product.id');
        $query->orderBy('product.view_count','DESC');
        if(!empty($count_item)){
            $limit = $count_item;
            $query->offset($count_item)->limit(3);
        }else{
            $query->offset(0)->limit(6);
        }
        //$query->distinct('product.id');
        //$query->paginate(3);
        $result = $query->get();
        return $result;
    }
    public function is_page_like_by_user($user_id,$page_id){
        $result = DB::table('product_likes')
            ->select('serial_number')
            ->where('product_id',$page_id)
            ->where('sender_id',$user_id)
            ->get();
        if(count($result) > 0){
            return true;
        }else{
            return false;
        }
    }
    public function page_like_status_by_user($user_id,$page_id){
        $result = DB::table('product_likes')
            ->select('serial_number','like_status')
            ->where('product_id',$page_id)
            ->where('sender_id',$user_id)
            ->get();
        if(count($result) > 0){
            return $result[0]->like_status;
        }else{
            return false;
        }
    }
    public function is_page_flow_by_user($user_id,$page_id){
        $result = DB::table('product_fllowers')
            ->select('serial_number')
            ->where('product_id',$page_id)
            ->where('user_id',$user_id)
            ->get();
        if(count($result) > 0){
            return true;
        }else{
            return false;
        }
    }
    public function is_publisher_follow_by_user($user_id,$publisher_id){
        $result = DB::table('publisher_followers')
            ->select('serial_number')
            ->where('publisher_id',$publisher_id)
            ->where('user_id',$user_id)
            ->get();
        if(count($result) > 0){
            return true;
        }else{
            return false;
        }
    }
    public function is_pages_added_by_user($user_id,$page_id){
        $result = DB::table('favourite_gpages')
            ->select('serial_number')
            ->where('page_id',$page_id)
            ->where('user_id',$user_id)
            ->get();
        if(count($result) > 0){
            return true;
        }else{
            return false;
        }
    }
    public function get_total_likes_by_page_id($page_id){
        $result = DB::table('product_likes')
            ->select('serial_number')
            ->where('product_id',$page_id)
            ->where('like_status','yes')
            ->get()->count();
        return $result;
    }
    public function get_total_dislikes_by_page_id($page_id){
        $result = DB::table('product_likes')
            ->select('serial_number')
            ->where('product_id',$page_id)
            ->where('like_status','no')
            ->get()->count();
        return $result;
    }
    public function get_total_comments_by_page_id($page_id){
        $result = DB::table('product_comment')
            ->select('serial_number')
            ->where('product_id',$page_id)
            ->get()
            ->count();
        return $result;
    }
    public function get_total_fllowers_by_page_id($page_id){
        $result = DB::table('product_fllowers')
            ->select('serial_number')
            ->where('product_id',$page_id)
            ->get()
            ->count();
        return $result;
    }
    public function get_total_followers_by_publisher_id($id){
        $result = DB::table('publisher_followers')
            ->select('serial_number')
            ->where('publisher_id',$id)
            ->get()
            ->count();
        return $result;
    }
    public function update_page_view($page_id){
        $result = DB::table('product')
            ->select('view_count')
            ->where('id',$page_id)
            ->get();
        if(count($result) > 0){
            $view_count = $result[0]->view_count +1;
            $param = array('view_count'=> $view_count);
            DB::table('product')->where('id',$page_id)->update($param);
        }else{
            return 0;
        }
    }
    public function total_gpages_like_by_creator_id($id){
        $result = DB::table('product')
            ->select('id')
            ->where('user_id',$id)
            ->join('product_likes','product.id', '=', 'product_likes.product_id')
            ->get()
            ->count();
        return $result;
    }
    public function total_gpages_comments_by_creator_id($id){
        $result = DB::table('product')
            ->select('id')
            ->where('user_id',$id)
            ->join('product_comment','product.id', '=', 'product_comment.product_id')
            ->get()
            ->count();
        return $result;
    }
    public function total_gpages_views_by_creator_id($id){
        $result = DB::table('product')
            ->select(DB::raw("SUM(view_count) as total_count"))
            ->where('user_id',$id)
            ->orderBy("created_at")
            ->groupBy('id')
            ->get();
        if(count($result) > 0){
            return $result[0]->total_count;
        }else{
            return 0;
        }
    }

    public function get_total_commentlist_by_page_id($page_id){
        $result = DB::table('product_comment')
            ->select('product_comment.serial_number','comment','product_comment.product_id','product_comment.parent_id','users.name as name','product_comment.created_at','users.profile_picture as sender_picture','users.name','u2.username as responser_name','u2.profile_picture as responser_picture')
            ->join('users','users.id','=','product_comment.sender_id')
            ->join('product','product.id','=','product_comment.product_id')
            ->join('users as u2','u2.id','=','product.user_id')
            ->where('product_id',$page_id)
            ->orderByRaw('product_comment.created_at ASC')
            ->get();
        return $result;
    }

    public function search_gpages($search_key){
        $result = DB::table('product as p')
            ->select('p.id','p.bar_code','p.name','p.title','p.image','u.username')
            ->where('bar_code','like', '%'.$search_key .'%')
            ->orWhere('p.name','like',  '%'.$search_key .'%')
            ->orWhere('p.title','like',  '%'.$search_key .'%')
            ->join('users as u','u.id','=','p.user_id')
            ->get();
        if(count($result) > 0){
            return $result;
        }else{
            return 0;
        }
    }
    public function product_category_id_by_product_id($id){
        $result = DB::table('product')
            ->select('category_id')
            ->where('id',$id)
            ->get();
        if(count($result) > 0){
            return $result[0]->category_id;
        }else{
            return 0;
        }
    }
    public function favourite_gpages_list_by_user_id($id)
    {
        $query = DB::table('favourite_gpages as fg')
            ->select('product.id','product.name','product.bar_code','product.title','product.price','product.manufactured_by','product.description','product.image','product.status','product.view_count','product_category.name as category_name','product_subcategory.name as subcategory_name','product.created_at','product.updated_at','product.user_id','users.username','users.email','users.profile_picture','user_details.account_type');
        $query->where('fg.user_id',$id);
        $query->join('product', 'product.id', '=', 'fg.page_id');
        $query->join('product_category', 'product.category_id', '=', 'product_category.category_id');
        $query->join('product_subcategory', 'product_subcategory.subcategory_id', '=', 'product.subcategory_id');
        $query->join('users','users.id','=','product.user_id');
        $query->join('user_details','user_details.user_id','=','users.id');
        $result = $query->get();
        return $result;
    }
    public function product_name_by_id($id)
    {
        $result = DB::table('product')
            ->select('product.name')
            ->where('product.id', $id)
            ->get();
        if(count($result) > 0){
            return $result[0]->name;
        }else{
            return false;
        }
    }
    public function gpages_stats_by_user_id($id)
    {
        $query = DB::table('product')
            ->select('product.id','product.name','product.bar_code','product.title','product.status','product.view_count')
            ->where('product.user_id', $id);
        $result = $query->get();
        return $result;
    }

    public function total_page_followers($page_id){
        $result = DB::table('favourite_gpages')
            ->select('serial_number')
            ->where('page_id',$page_id)
            ->get()
            ->count();
        return $result;
    }
    public function is_product_reported_by_user($user_id, $product_id){
        $result=DB::table('reported_product')
            ->where('product_id',$product_id)
            ->where('sender_id',$user_id)
            ->get()->toArray();
        if(count($result)>0){
            return true;
        }else{
            return false;
        }
    }
    public function reported_product_list($id){
        $result=DB::table('reported_product as rp')
            ->select('rp.serial_number as id','rp.description','u.email as sender_email','u.username as sender_name','p.name as gpage_name','reported_reason.name as reason','rp.status','rp.created_at','rp.product_id')
            ->where('reciver_id',$id)
            ->where('rp.status',0)
            ->join('users as u','u.id','=','rp.sender_id')
            ->join('product as p','rp.product_id','=','p.id')
            ->join('reported_reason','rp.reason','=','reported_reason.serial_number')
            ->get();
        return $result;
    }
    public function reported_product_details_by_id($id){
        $result=DB::table('reported_product as rp')
            ->select('rp.serial_number as id','rp.description','u.email as sender_email','u.username as sender_name','p.name as gpage_name','reported_reason.name as reason','rp.status','rp.created_at')
            ->where('rp.serial_number',$id)
            ->where('rp.status',0)
            ->join('users as u','u.id','=','rp.sender_id')
            ->join('product as p','rp.product_id','=','p.id')
            ->join('reported_reason','rp.reason','=','reported_reason.serial_number')
            ->get();
        return $result;
    }
    public function get_total_like_by_creator_id($creator_id){
        $result = DB::table('product as p')
            ->select('p.id')
            ->where('p.user_id',$creator_id)
            ->join('product_likes', 'product_likes.product_id', '=', 'p.id')
            ->where('like_status','yes')
            ->get()->count();
        return $result;
    }
    public function get_total_unlike_by_creator_id($creator_id){
        $result = DB::table('product as p')
            ->select('p.id')
            ->where('p.user_id',$creator_id)
            ->join('product_likes', 'product_likes.product_id', '=', 'p.id')
            ->where('like_status','no')
            ->get()->count();
        return $result;
    }
    public function currency_list()
    {
        $result = DB::table('currencies')
            ->select('id','country','currency','code','symbol')
            ->get();
        if(count($result) > 0){
            return $result;
        }else{
            return false;
        }
    }
}
