<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;
class Support extends Model
{
    protected $table = 'support';
    public function support_list_by_user_id($id, $type='')
    {
        $query = DB::table('support')
            ->select('u1.username as reciver_name','u2.username as sender_name','support.created_at','support.message','support.serial_number as id','support.sender_id','support.reply_status','support.status as support_status','support.subject');
        if($type == 'sender'){
            $query->where('support.sender_id', $id);
        }else{
            $query->where('support.reciver_id', $id);
        }
        //->orWhere('support.sender_id', $id)
        $query->where('support.parent_id', 0);
        $query->join('users as u1', 'u1.id', '=', 'support.reciver_id');
        $query->join('users as u2', 'u2.id', '=', 'support.sender_id');
        $query->orderby('id','DESC');
        $result = $query->get();
        return $result;
    }

    public function get_support_details_by_support_id($id)
    {
        $result = DB::table('support')
            ->select('u1.username as reciver_name','u2.username as sender_name','u1.profile_picture as reciver_profile_pic','u2.profile_picture as sender_profile_pic','support.created_at','support.message','support.status as support_status','support.subject')
            ->where('support.serial_number', $id)
            ->join('users as u1', 'u1.id', '=', 'support.reciver_id')
            ->join('users as u2', 'u2.id', '=', 'support.sender_id')
            ->get();
        return $result;
    }
    public function get_support_message_by_id($id)
    {
        $result = DB::table('support')
            ->select('support.serial_number as id','support.subject','support.message','support.status as support_status','support.sender_id','support.created_at','users.name','users.email','users.profile_picture')
            ->where('support.serial_number', $id)
            ->join('users', 'users.id', '=', 'support.sender_id')
            ->get();
        return $result;
    }
    public function get_support_message_response_by_id($id)
    {
        $result = DB::table('support')
            ->select('support.serial_number as id','support.subject','support.message','support.reciver_id','support.status as support_status','support.created_at','users.name','users.email','users.profile_picture','u2.profile_picture as sender_profile_pic','u2.name as sender_name')
            ->where('support.parent_id', $id)
            ->join('users', 'users.id', '=', 'support.reciver_id')
            ->join('users as u2', 'u2.id', '=', 'support.sender_id')
            ->get();
        return $result;
    }
}
