@extends('layouts.admin')
@section('content')
<div class="main">
    <div class="subheader">
        <ul>
            <li>Admin</li>
        </ul>
    </div>
    <!-- MAIN CONTENT -->
    <div class="main-content">
        <div class="container-fluid">
            <!-- OVERVIEW -->
            <div class="panel panel-headline">
                <div class="panel-heading">
                    <h3 class="panel-title">Category List</h3>
                    <a class="btn btn-primary" href="{{url('admin/category-add')}}" style="float: right;margin-top: -31px;margin-right: 50px;">Add</a>
                </div>
            </div>
            <!-- END OVERVIEW -->
            <div class="row">
                <div class="col-md-12">
                    <!-- RECENT PURCHASES -->
                    <div class="panel">
                        <div class="notice-area">
                           @include('admin.alert_message')
                        </div>
                        <div class="panel-body no-padding">
                            <div class="table-responsive">
                            <img src="{{asset('img/loading.gif')}}" height="144px"  style="position: absolute; z-index: 1;margin-top: 50px;margin-left: 353px; display: none;" id="loader_img" />
                                <table class="table table-striped datatable">
                                    <thead>
                                        <tr>
                                            <th>#SN</th>
                                            <th>Name</th>
                                            <th>Created_at</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if(count($category)>0)
                                            @foreach($category as $key => $value)
                                            <?php
                                                $dec_category_id = \Crypt::encryptString($value->id);
                                            ?>
                                                <tr>
                                                    <td></td>
                                                    <td>{{$value->name}}</td>
                                                    <td>{{$value->created_at}}</td>
                                                    <td>
                                                       <a href="{{url('admin/category-edit/'.$dec_category_id)}}">
                                                        <span class="label label-success">Edit</span>
                                                       </a>
                                                        <span class="label label-danger delete_action" data-id="{{$value->id}}">Delete</span>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- <div class="panel-footer">
                            <div class="row">
                                <div class=" text-right">
                                    <a href="#" class="btn btn-primary">View All</a>
                                </div>
                            </div>
                        </div> -->
                    </div>
                    <!-- END RECENT PURCHASES -->
                </div>
            </div>
        </div>
    </div>
    <!-- END MAIN CONTENT -->
    <script type="text/javascript">
    $(document).ready(function(){
        $('body').on('click', '.delete_action', function(e) {
            var id = $(this).data('id');
            if(id != "" || id != undefined){
                bootbox.confirm({
                    message: 'Are You sure want to delete ?',
                    buttons: {
                        cancel: {
                            label: '<i class="fa fa-times"></i> Cancel'
                        },
                        confirm: {
                            label: '<i class="fa fa-check"></i> Confirm'
                        }
                    },
                    callback: function (result) {
                        if(result){
                            $('#loader_img').css('display','block');
                            $.ajax({
                                type: "POST",
                                url: site_url+"/admin/category-delete",
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                data: {id: id},
                                success: function(res){
                                   $('#loader_img').css('display','none');
                                   var data = jQuery.parseJSON(res);
                                   if(data.status){
                                    setTimeout(function(){
                                       window.location.reload();
                                    }, 900);
                                      
                                   }else{
                                   toastr.error(data.msg);
                                    setTimeout(function(){
                                       // window.location.reload();
                                    }, 900);
                                   }
                                }
                            });
                            return true;
                        }
                    }
                });
            }
        });
    });
       
    </script>
</div>
@endsection