@extends('layouts.admin')
@section('content')
<style type="text/css">
    .container {
      border: 2px solid #dedede;
      background-color: #f1f1f1;
      border-radius: 5px;
      padding: 10px;
      margin: 10px 0;
      max-width: 500px;
    }

    .darker {
      border-color: #ccc;
      background-color: #ddd;
      margin-left: 400px;
    }

    .container::after {
      content: "";
      clear: both;
      display: table;
    }

    .container img {
      float: left;
      max-width: 60px;
      width: 100%;
      margin-right: 20px;
      border-radius: 50%;
    }

    .container img.right {
      float: right;
      margin-left: 20px;
      margin-right:0;
    }

    .time-right {
      float: right;
      color: #aaa;
    }

    .time-left {
      float: left;
      color: #999;
    }
</style>
<div class="main">
    <div class="subheader">
        <ul>
            <li>Admin</li>
        </ul>
    </div>
    <!-- MAIN CONTENT -->
    <div class="main-content">
        <div class="container-fluid">
            <!-- OVERVIEW -->
            <div class="panel panel-headline">
                <div class="panel-heading">
                    <h3 class="panel-title">Feedback Exchange</h3>
                </div>
            </div>
            <!-- END OVERVIEW -->
            <div class="row">
                <div class="col-md-12">
                    <!-- RECENT PURCHASES -->
                    <div class="panel">
                        <div class="notice-area">
                           @include('admin.alert_message')
                        </div>
                        <div class="panel-body no-padding">
                            <!-- chat div start here -->
                            @if(count($feedback))
                              <?php
                                $user_model = new App\User;
                                $sender_pic = $user_model->user_profile_pic_by_email($feedback[0]->sender_email); 
                              ?>
                              <div class="container">
                                <img src="{{$sender_pic?$sender_pic:asset('/public/profile_img/no_image.png')}}" alt="Avatar" style="width:100%;">
                                <p>{{ucfirst($feedback[0]->sender_name)}}</p>
                                <p>{{$feedback[0]->message}}</p>
                                <span class="time-right">{{$feedback[0]->created_at}}</span>
                              </div>
                              @if(count($feedback_response))
                                @foreach($feedback_response as $key=>$response)
                                  <div class="container darker">
                                    <img src="{{url(Auth::guard('admin')->user()->profile_picture)}}" alt="Avatar" class="" style="width:100%;position: '';">
                                    <p>{{ucfirst(Auth::guard('admin')->user()->name)}}</p>
                                    <p>{{$response->message}}</p>
                                    <span class="time-left">{{$response->created_at}}</span>
                                    <i class="fa fa-trash delete_action" style="float:right" data-id="{{$response->serial_number}}"></i>
                                  </div>
                                @endforeach
                              @endif
                              <div class="container darker">
                                <p>Reply to {{$feedback[0]->sender_name}}</p>
                                <textarea rows="6" cols="55" name="message" id="message">
                                  
                                </textarea>
                                <p>
                                <a href="{{url('admin/feedback')}}" class="btn btn-default"> Back</a>
                                <input type="button" class="btn btn-success" id="reply_btn" name="Send" value="Send" data-id="{{$feedback[0]->serial_number}}" data-email="{{$feedback[0]->sender_email}}" data-name="{{$feedback[0]->sender_name}}"></button></p>
                              </div>
                            @endif
                            <!-- chat div end  here -->
                        </div>
                    </div>
                    <!-- END RECENT PURCHASES -->
                </div>
            </div>
        </div>
    </div>
    <!-- END MAIN CONTENT -->
    <script type="text/javascript">
    $(document).ready(function(){
        $("#message").val($("#message").val().trim());
        $('body').on('click', '#reply_btn', function(e) {
          var id = $(this).data('id');
          var name = $(this).data('name');
          var email = $(this).data('email');
          var message = $("#message").val().trim();
          if(message == "" || message == undefined){
            toastr.error('Please enter message');
            return true;
          }
          if(id != "" || id != undefined){
              $("#reply_btn").attr("disabled", true);
              $.ajax({
                type: "POST",
                url: site_url+"/admin/feedback-response",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {id: id,name: name,message:message,email:email},
                success: function(res){
                  var data = jQuery.parseJSON(res);
                  if(data.status){
                  setTimeout(function(){
                    window.location.reload();
                  }, 900);
                      
                  }else{
                    setTimeout(function(){
                      window.location.reload();
                    }, 900);
                  }
                  $("#reply_btn").attr("disabled", false);
                }
            });  
          }
        });
        //delete feedback
        $('body').on('click', '.delete_action', function(e) {
            var id = $(this).data('id');
            if(id != "" || id != undefined){
                bootbox.confirm({
                    message: 'Are You sure want to delete ?',
                    buttons: {
                        cancel: {
                            label: '<i class="fa fa-times"></i> Cancel'
                        },
                        confirm: {
                            label: '<i class="fa fa-check"></i> Confirm'
                        }
                    },
                    callback: function (result) {
                        if(result){
                            $('#loader_img').css('display','block');
                            $.ajax({
                                type: "POST",
                                url: site_url+"/admin/delete-feedback",
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                data: {id: id},
                                success: function(res){
                                   $('#loader_img').css('display','none');
                                   var data = jQuery.parseJSON(res);
                                   if(data.status){
                                    setTimeout(function(){
                                       window.location.reload();
                                    }, 900);
                                      
                                   }else{
                                    setTimeout(function(){
                                        window.location.reload();
                                    }, 900);
                                   }
                                }
                            });
                            return true;
                        }
                    }
                });
            }
        });
    });
       
    </script>
</div>
@endsection
