@extends('layouts.admin')
@section('content')
<div class="main">
   <div class="subheader">
      <ul>
         <li>Admin</li>
      </ul>
   </div>
   <!-- MAIN CONTENT -->
   <div class="main-content">
      <div class="container-fluid">
         <!-- END OVERVIEW -->
         <div class="row">
            <div class="col-md-12">
               <!-- RECENT PURCHASES -->
               <form class="col-md-12 form-panel" style="border:0"  method="POST" action="" enctype="multipart/form-data" id="subcategory_frm">
                  <div class="row">
                     <div class="panel new-panel">
                        <div class="panel-heading">
                           <div class="col-md-12">
                              <h3 class="panel-title">Edit Subcategory</h3>
                           </div>
                           <br>
                        </div>
                        <div class="notice-area">
                           @include('admin.alert_message')
                        </div>
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="panel-body no-padding">
                           <div class="col-md-4">
                              <label>Category<span class="required">*</span></label>
                              <select id="category" name="category" class="form-control">
                              <option value="">Choose</option>
                                @if($category)
                                  @foreach($category as $key=>$value)
                                    <option value="{{$value->id}}" <?=$value->id == $subcategory[0]->category_id?'selected=selected':''?>>{{$value->name}}</option>
                                  @endforeach
                                @endif
                                <option>
                                  test
                                </option>
                              </select>
                              <br>
                           </div>
                           <div class="col-md-5">
                              <label>Subcategory<span class="required">*</span></label>
                              <input type="text" name="name" class="form-control" value="{{$subcategory[0]->name}}">
                              <br>
                              <input type="hidden" name="action_type" value="edit">
                               <input type="hidden" name="id" value="{{$subcategory[0]->id}}">
                           </div>
                        </div>
                        <div class="panel-footer">
                           <div class="row">
                              <div class="col-md-8 text-right">
                              <a href="{{ redirect()->back()->getTargetUrl() }}" class="btn btn-primary">Back</a>
                              <button type="Submit" class="btn btn-primary" id="reply_btn">Submit</button>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </form>
               <!-- END RECENT PURCHASES -->
            </div>
         </div>
      </div>
   </div>
   <!-- END MAIN CONTENT -->
</div>
<script type="text/javascript">
  $(document).ready(function(){
    $('form[id="subcategory_frm"]').validate({
      rules: {
        category: 'required',
        name: 'required',
      },
      messages: {
        category: 'Please select category',
        name: 'Please category name',
      },
      submitHandler: function(form) {
        //form.submit();
        $("#reply_btn").attr("disabled", true);
        frm = $('#subcategory_frm');
        $.ajax({
          type: "POST",
          url: site_url+"/admin/subcategory-edit",
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: frm.serialize(),
          success: function(res){
             var data = jQuery.parseJSON(res);
             if(data.status){
                setTimeout(function(){
                   window.location=site_url+"/admin/subcategory-list";
                }, 900);
             }else{
                toastr.error(data.msg);
             }
             $("#reply_btn").attr("disabled", false);
          }
        });
      }
    });
    //get subcategory list by id.
      /*$('body').on('change', '#category', function() {
        var id = $("#category").val();
        $.ajax({
            type: "POST",
            url: site_url+"/ajax/get-subcategory",
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: {id:id},
            success: function(res){
               var data = jQuery.parseJSON(res);
               if(data.status){
                  $("#sub_category").html(data.content);
               }
            }
        });
      });*/
  });
</script>
@endsection
