@extends('layouts.admin')
@section('content')
<div class="main">
    <div class="subheader">
        <ul>
            <li>Admin</li>
        </ul>
    </div>
    <!-- MAIN CONTENT -->
    <div class="main-content">
        <div class="container-fluid">
            <!-- OVERVIEW -->
            <div class="panel panel-headline">
                <div class="panel-heading">
                    <h3 class="panel-title">Users List</h3>
                </div>
            </div>
            <!-- END OVERVIEW -->
            <div class="row">
                <div class="col-md-12">
                    <!-- RECENT PURCHASES -->
                    <div class="panel">
                        <div class="notice-area">
                           @include('admin.alert_message')
                        </div>
                        <div class="panel-body no-padding">
                            <div class="table-responsive">
                            <img src="{{asset('/public/img/loading.gif')}}" height="144px"  style="position: absolute; z-index: 1;margin-top: 50px;margin-left: 353px; display: none;" id="loader_img" />
                                <table class="table table-striped datatable">
                                    <thead>
                                        <tr>
                                            <th>#SN</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Type</th>
                                            <th>Status</th>
                                            <th>Created_at</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if(count($user)>0)
                                            @foreach($user as $key => $value)
                                                <tr>
                                                    <td></td>
                                                    <td><a target="_blank" href="{{url('admin/user-info/'.$value->id)}}"><?=$value->first_name." ".$value->last_name?></a></td>
                                                    <td><?=$value->email?></td>
                                                    <td>
                                                        @if($value->account_type == 1)
                                                            <span class="label label-success">Publisher</span>
                                                        @elseif($value->account_type == 2)
                                                            <span class="label label-success">Agency</span>
                                                        @elseif($value->account_type == 3)
                                                            <span class="label label-success">Business</span>
                                                        @else
                                                            <span class="label label-success">User</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($value->status == 1)
                                                            <span class="label label-success">Approved</span>
                                                        @elseif($value->status == 2)
                                                            <span class="label label-warning">Hold</span>
                                                        @elseif($value->status == 3)
                                                            <span class="label label-info">Suspend</span>
                                                        @elseif($value->status == 4)
                                                            <span class="label label-info">Deleted</span>
                                                        @else
                                                            <span class="label label-danger">Unapproved</span>
                                                        @endif
                                                    </td>
                                                    <td>{{$value->created_at}}</td>
                                                    <td>
                                                        <select class="form-control common_action" style="border-radius: 1px" name="common_action" data-user_id="{{$value->id}}" data-email_id="{{$value->email}}" data-status="{{$value->status}}" id="{{$value->id}}_div_action">
                                                        <option value="">Choose</option>
                                                            <option value="1" <?= $value->status == 1?'selected=selected':''?>>
                                                                Approved
                                                            </option>
                                                            <option value="2" <?= $value->status == 2?'selected=selected':''?>>
                                                                Hold
                                                            </option>
                                                            <option value="3" <?= $value->status == 3?'selected=selected':''?>>
                                                                Suspend
                                                            </option>
                                                             <option value="4" <?= $value->status == 4?'selected=selected':''?>>
                                                               Delete
                                                            </option>
                                                        </select>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- <div class="panel-footer">
                            <div class="row">
                                <div class=" text-right">
                                    <a href="#" class="btn btn-primary">View All</a>
                                </div>
                            </div>
                        </div> -->
                    </div>
                    <!-- END RECENT PURCHASES -->
                </div>
            </div>
        </div>
    </div>
    <!-- contact form model -->
    <div class="modal fade" id="contact_model" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true"  style="overflow:scroll;">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header text-center">
            <h4 class="modal-title w-100 font-weight-bold">Request Form</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close" data-model_id="contact_model">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <form method="post" name="contact_model_frm" id="contact_model_frm">
            <div class="modal-body mx-3">
                <input type="hidden" name="user_id" id="user_id">
                 <input type="hidden" name="user_status" id="user_status">
              <div class="md-form mb-4">
                <label data-error="wrong" data-success="right" for="form34">To</label>
                <input type="text" id="to" name="to" class="form-control" readonly>
              </div>
              <div class="md-form mb-4">
                <label data-error="wrong" data-success="right" for="form34">Subject</label>
                <input type="text" id="subject" name="subject" class="form-control">
              </div>
              <input type="hidden" name="message" id="message">
              <div class="md-form mb-4">
                <label data-error="wrong" data-success="right" for="form34">Message</label>
                <textarea id="message_ck" name="message_ck" class="form-control" style="min-height: 160px;"></textarea> 
              </div>
            </div>
            <div class="modal-footer d-flex justify-content-center">
              <input class="btn btn-primary" type="submit" value="Send"></button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <!-- contact form model end here  -->
    <!-- END MAIN CONTENT -->
    <script type="text/javascript">
    $(document).ready(function(){
        CKEDITOR.replace( 'message_ck' );
        $('body').on('change', '.common_action', function(e) {
            var user_id = $(this).data('user_id');
            var status = $("#"+user_id+"_div_action").val();
            var old_status = $(this).data('status');
            var email = $(this).data('email_id');
            var message = 'Are you sure ?';
            if(status == old_status){
                return true;
            }
            //alert("status is:"+status);
            if(status == "1"){
                 message = 'Are you sure want to  approved account?';
            }else if(status == "2"){
                 message = 'Are you sure want to hold account ?';
            }else if(status == "3"){
                 message = 'Are you sure want to suspend account ?';
            }else if(status == "4"){
                 message = 'Are you sure want to delete account ?';
            }else{
                return true;
            }
            if(user_id != "" || user_id != undefined){
                bootbox.confirm({
                    message: message,
                    buttons: {
                        cancel: {
                            label: '<i class="fa fa-times"></i> Cancel'
                        },
                        confirm: {
                            label: '<i class="fa fa-check"></i> Confirm'
                        }
                    },
                    callback: function (result) {
                        if(result){
                            if(status == 1 || status == 2 || status == 3){
                                $("#to").val(email);
                                $("#user_id").val(user_id);
                                $("#user_status").val(status);
                                $("#subject").val('Our Gfects publisher account Review Feedback');
                                $("#message").val('');
                                $("#contact_model").modal("toggle"); 
                                return true;
                            }else if(status == 4){
                                $('#loader_img').css('display','block');
                                $.ajax({
                                    type: "POST",
                                    url: site_url+"/admin/user-account-delete",
                                    headers: {
                                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                    },
                                    data: {user_id:user_id,email:email},
                                    success: function(res){
                                       $('#loader_img').css('display','none');
                                       var data = jQuery.parseJSON(res);
                                       if(data.status){
                                        //toastr.success(data.msg);
                                        setTimeout(function(){
                                           window.location.reload(true);
                                        }, 900);
                                          
                                       }else{
                                        //toastr.error(data.msg);
                                        setTimeout(function(){
                                            window.location.reload(true);
                                        }, 900);
                                       }
                                    }
                                });
                            }
                        }
                    }
                });
            }
        });
         $('form[id="contact_model_frm"]').validate({
                rules: {
                  to: 'required',
                  email: 'required',
                  message: 'required'
                },
                messages: {
                  to: 'Please enter to field.',
                  email: 'Please enter email field.',
                  message: 'Please enter message field'
                },
                submitHandler: function(form) {
                    //form.submit();
                    $("#message").val(CKEDITOR.instances['message_ck'].getData());
                    $(':input[type="submit"]').prop('disabled', true);
                    frm = $('#contact_model_frm');
                    $.ajax({
                        type: "POST",
                        url: site_url+"/admin/user-account-review",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: frm.serialize(),
                        success: function(res){
                           $(':input[type="submit"]').prop('disabled', false);
                           var data = jQuery.parseJSON(res);
                           $("#contact_model").modal("toggle");
                           if(data.status){
                              //toastr.success(data.msg);
                              setTimeout(function(){
                                 window.location.reload(true);
                              }, 900);
                           }else{
                              setTimeout(function(){
                                 window.location.reload(true);
                              }, 900);
                           }
                        }
                    });
                }
            });
    });
</script>
</div>
@endsection