@extends('layouts.layout')

{{-- head Start--}}
  @section('meta_description'){{$meta_description}}@endsection
  @section('title'){{$title}}@endsection
  @section('more_css_style')
  <style>

  </style>
  @endsection
  @section('Google_adsense')
    @includeif('layouts.googleadsense')
  @endsection
{{-- head end--}}


{{-- Body start--}}

{{-- section starts--}}
  {{-- top --}}
  @section('section_content_top')
  @endsection
  
  {{-- Middle --}}
  @section('section_content')
  <div class="container">
    <div class="py-5 text-center">
      
      <h2>Create account</h2>
      <p class="lead">Create a publisher account to add your product to G-Pages. </p>
      <p>Read more about the types of <a href="Creator-Types">creator accounts</a></p>
    </div>


    <div class="card py-5">

      <div class="p-3 m-auto my-3" style="max-width:455px">             
          <h4 class="mb-3">Let's get started </h4>
          <hr class="mb-4">
          <div><p>Already have account? <a href="{{ url('Account') }}">Log in</a></p></div>
          <p>Continue with</p>
            <ul class="selectDynamicType">
              <a href="{{url('/')}}/auth/google" class="btn btn-sm" style="background: #da3d29; color:#fff"><i class="fab fa-google"></i>&nbsp; Signup with Google</a>
              <a href="{{url('/')}}/auth/linkedin" class="btn btn-sm" style="background: #0677b0; color:#fff"><i class="fab fa-linkedin"></i>&nbsp; Signup with Linkedin</a>
            </ul>
          <hr class="mb-4">

          <?php
              if(session('social_data')){
                  $user_data = session('social_data');
              }else{
                  $user_data = array();
              }
              if(old('account_type') == 1 ){
                  $min_height = '800px';
              }elseif ((old('account_type') == 2 || old('account_type') == 3)) {
                  $min_height = '1220px';
              }else{
                  $min_height = '800px';
              }
              ?>


          <form class="needs-validation" name="createACCf01" method="POST" action="{{ url('registerX') }}" enctype="multipart/form-data"> 
            <!-- hidden form field value -->
            @csrf
            <input type="hidden" name="social_id" value="<?=$user_data?$user_data['id']:old('social_id')?>">
            <input type="hidden" name="provider" value="<?=$user_data?$user_data['provider']:old('provider')?>">
            <input type="hidden" name="social_image" value="<?=$user_data?$user_data['profile_pic']:old('social_image')?>">

            <p><b>Representative Details</b> - let's get to know you</p>

            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="list-group">
                        @foreach ($errors->all() as $error)
                            <li class="list-group-item font-italic">{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="row">
              <div class="col-md-6 mb-3">
                <label for="first_name">First name</label>
                <input type="text" class="form-control{{ $errors->has('first_name') ? ' is-invalid' : '' }}" id="first_name" name="first_name" placeholder="first"  value="{{ old('first_name') }}" required="">
                <div class="invalid-feedback {{ $errors->has('first_name') ? ' is-invalid' : '' }}">
                  <p>{{ $errors->first('first_name') }}<br>Valid first name is required.</p>
                </div>
              </div>
              <div class="col-md-6 mb-3">
                <label for="last_name">Last name</label>
                <input type="text" class="form-control {{ $errors->has('last_name') ? ' is-invalid' : '' }}" id="last_name" name="last_name" placeholder=""  value="{{ old('last_name') }}" required="">
                <div class="invalid-feedback {{ $errors->has('last_name') ? ' is-invalid' : '' }}">
                  Valid last name is required.
                </div>
              </div>
            </div>

            <div class="mb-3">
              <label for="dob">Birthdate</label>
              <input type="date" class="form-control col-md-5 {{ $errors->has('dob') ? ' is-invalid' : '' }}" id="dob" name="dob" value="{{ old('dob') }}" require>
              <div class="invalid-feedback {{ $errors->has('dob') ? ' is-invalid' : '' }}">
                <p>Birthdate required and you must be over 18 years</p>
              </div>
            </div>
                          

            <div class="mb-3">
              <label for="email">Email </label>
              <input type="email" class="form-control {{ $errors->has('email') ? ' is-invalid' : '' }}" id="email" name="email" placeholder="work@example.com" value="{{ old('email') }}" required>
              @if ($errors->has('email'))
              <div class="text-danger {{ $errors->has('email') ? ' is-invalid' : '' }}" >
                {{ $errors->first('email') }} <a href="{{ url('Account') }}">log in</a>
              </div>
               @endif
            </div>
            <hr class="mb-4">

            
            <div class="row">
              <div class="col-md-6 mb-3">
                <label for="country">Country</label>
                  <select class="form-control" name="country" id="country" required autofocus>
                        <option value="">Select Country</option>
                        @if(count($country)>0)
                            @foreach($country as $key=>$value)
                                <option value="{{$value->id}}">{{$value->name}}</option>
                            @endforeach
                        @endif
                    </select>
                  <div class="invalid-feedback {{ $errors->has('country') ? ' is-invalid' : '' }}">
                    Please select a valid country.
                  </div>
              </div>
              <div class="col-md-6 mb-3">
                <label for="state"><span>State / Province / Region</span></label>
                <select class="form-control" name="state" id="state" required autofocus>
                </select>
                <div class="invalid-feedback {{ $errors->has('state') ? ' is-invalid' : '' }}">
                  Please provide a valid state.
                </div>
              </div>
            </div>

            <h5 class="mb-3">Enter your Username</h5>
            <div class="mb-3">
              <label for="username">Username<span class="error" role="alert" id="username_error" style="display: none"><strong>Username is already in used.</strong></span></label>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text">@</span>
                </div>
                <input type="text" class="form-control col-md-4 {{ $errors->has('username') ? ' is-invalid' : '' }}" id="username" name="username" placeholder="Username" value="{{ old('username') }}" required>
                @if ($errors->has('username'))
                <div class="invalid-feedback {{ $errors->has('username') ? ' is-invalid' : '' }}" >
                  <p>{{ $errors->first('username')}} <a href="log-in">log in</a></p> 
                </div>
                 @endif
              </div>
            </div>
            <div class="mb-3">
              <label for="password">Password</label>
              <input type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" id="password" name="password" placeholder="password" required>
              @if ($errors->has('password'))
                <div class="invalid-feedback {{ $errors->has('password') ? ' is-invalid' : '' }}" >
                  <p>{{ $errors->first('password')}}</p> 
                  <p>Password must be 8 characters in length, contains only alphanumeric characters with at least one numeric digit.</p>
                </div>
                 @endif
            </div>
            <div class="mb-3">
              <label for="password_confirmation">Confirm Password</label>
              <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" placeholder="password" required>
              @if ($errors->has('password_confirmation'))
                <div class="invalid-feedback {{ $errors->has('password_confirmation') ? ' is-invalid' : '' }}" >
                  <p>{{ $errors->first('password_confirmation')}}</p> 
                </div>
                 @endif
            </div>

            <div class="mb-3">
              <p>Account Type</p>
              <div class="form-check form-check-inline">
                <input class="form-check-input" type="radio" name="account_type" id="inlineRadio1" value="1"
                  {{old('account_type') == '1'?'checked':''}}
                  {{ old('account_type') ?? 'checked=checked' }}>
                <label class="form-check-label" for="inlineRadio1"> Publisher  </label>&nbsp;&nbsp;
                <span class="badge badge-secondary"
                  data-container="body" 
                  data-toggle="popover" 
                  data-placement="top" 
                  data-content="For not businesses, manufacturers of Agencies. No address verification required"  {{old('account_type') == '2'?'checked':''}}>
                  ?
                </span>
              </div>
              <div class="form-check form-check-inline">
                <input class="form-check-input" type="radio" name="account_type" id="inlineRadio2" value="2" {{old('account_type') == '3'?'checked':''}}>
                <label class="form-check-label" for="inlineRadio2"> Agency </label>&nbsp;&nbsp;
                <span class="badge badge-secondary"
                  data-container="body" 
                  data-toggle="popover" 
                  data-placement="top" 
                  data-content="For ad agencies who want to create G-pages for their clients. Address verification required">
                  ?
                </span>
              </div>
              <div class="form-check form-check-inline">
                <input class="form-check-input" type="radio" name="account_type" id="inlineRadio3" value="3">
                <label class="form-check-label" for="inlineRadio3"> Business  </label>&nbsp;&nbsp;
                <span class="badge badge-secondary"
                  data-container="body" 
                  data-toggle="popover" 
                  data-placement="top" 
                  data-content="For business or manufacturers who want to create G-pages for their clients. Address verification required">
                  ?
                </span>
              </div>
              <p class="pl-4"><small>You will be required to provide company details for agency and business account types</small></p>
            </div>
            
            <hr class="mb-4">
            <div class="mb-3">
              <small class="text-muted">
                By clicking continue, you agree to our
                <a href="terms" title="gfects terms of use"> Terms of use</a>, 
                <a href="privacy" title="gfects privacy">Privacy Policy</a>
                and
                <a href="Creator-Policy" title="gfects Creator Policy">Creator Policy</a>.
              </small>
            </div>

            <button class="btn btn-primary float-right" type="submit" >Continue</button>
          </form>
            

          
      </div>
    </div>
  </div>
  @endsection

  {{-- bottom for pop ups--}}
  @section('section_content_3')
  @endsection

{{-- section end--}}

{{-- footer Start--}}
{{-- footer end --}}

{{-- Scripts start--}}
  @section('ext_scripts')
   <!--<script
    src="https://code.jquery.com/jquery-3.4.1.min.js"
    integrity="sha256-CSXorXvZcTkaix6Yvo6HppcZGetbYMGWSFlBw8HfCJo="
    crossorigin="anonymous">
  </script>
  For country and state selector start-->
  <script>
    var site_url ='https://gfects.com';

  //get state list by country id
  $('body').on('change', '#country', function() {
      var id = $("#country").val();
      $.ajax({
          type: "POST",
          url: site_url+"/ajax/get-states",
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: {id:id,
              "_token": "{{ csrf_token() }}",
          },
          success: function(res){
              var data = jQuery.parseJSON(res);
              if(data.status){
                  $("#state").html(data.content);
              }
          }
      });
  });

  //check user is all ready exist or not
            $('body').on('keyup blur change', '#username', function() {
                $("#username_error").css('display','none');
                $("#nav-f1 .continue_btn").prop("disabled", false);
                var username = $("#username").val().trim();
                $.ajax({
                    type: "POST",
                    url: site_url+"/ajax/check-username",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {username:username,
                        "_token": "{{ csrf_token() }}",

                    },
                    success: function(res){
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            $("#username_error").css('display','block');
                            $("#nav-f1 .continue_btn").prop("disabled", true);
                        }
                    }
                });
            });
            //check user email exist
                       $('body').on('keyup blur change', '#email', function() {
                           $("#email_error").css('display','none');
                           $("#nav-f1 .continue_btn").prop("disabled", false);
                           var email = $("#email").val().trim();
                           $.ajax({
                               type: "POST",
                               url: site_url+"/ajax/check-email",
                               headers: {
                                   'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                               },
                               data: {email:email,
                                   "_token": "{{ csrf_token() }}",
                               },
                               success: function(res){
                                   var data = jQuery.parseJSON(res);
                                   if(data.status){
                                       $("#email_error").css('display','block');
                                       $("#nav-f1 .continue_btn").prop("disabled", true);

                                   }
                               }
                           });
                       });
  </script>
  <!-- end -->
    
  @endsection
{{-- script end--}}

{{--Body  end--}}