@extends('layouts.main')
@section('content')
    <style type="text/css">
        .remove_click{
            pointer-events:none;
        }
        .required_span{
            font-size: 19px;
            margin-left: 1px;
            color: red;
        }
        <?php
        $video = 0;
        $how_to_use_video = 0;
        ?>
    </style>
    <div>
        <h3>Edit G page</h3>
        <div>
            <nav class="mt-4">
                <div class="nav nav-tabs" id="nav-tab" role="tablist">
                    <a class="nav-item nav-link active " id="nav-home-barcode" data-toggle="tab" href="#home-barcode" role="tab" aria-controls="nav-barcode" aria-selected="true">1: Bar Code/UPC</a>
                    <a class="nav-item nav-link " id="nav-basic-details" data-toggle="tab" href="#basic-details" role="tab" aria-controls="nav-basic-details" aria-selected="true">2: Basic Details</a>
                    <a class="nav-item nav-link " id="nav-maker-details" data-toggle="tab" href="#maker-details" role="tab" aria-controls="nav-maker-details" aria-selected="true">3: Makers Details</a>
                    <a class="nav-item nav-link " id="nav-product-media" data-toggle="tab" href="#product-media" role="tab" aria-controls="nav-product-media " aria-selected="true">4: Product Media</a>
                    <a class="nav-item nav-link " id="nav-about-product" data-toggle="tab" href="#about-product" role="tab" aria-controls="nav-about-product" aria-selected="true">5: About Product</a>
                    <a class="nav-item nav-link " id="nav-external-sources" data-toggle="tab" href="#external-sources" role="tab" aria-controls="nav-external-sources" aria-selected="true">6: External Sources</a>
                    <a class="nav-item nav-link " id="nav-pages-options" data-toggle="tab" href="#pages-options" role="tab" aria-controls="nav-pages-options" aria-selected="true">7: G Pages Options</a>
                </div>
            </nav>
            <img src="{{asset('/public/img/loading.gif')}}" height="144px"  style="position: absolute; z-index: 1;margin-top: 103px;margin-left: 353px; display: none;" id="loader_img_product_update" />
            <form method="POST" action="{{ url('creator/add-product') }}" enctype="multipart/form-data" id="edit_product_frm">
                @csrf
                <div class="tab-content" id="nav-tabContent">
                    <div class="tab-pane active" id="home-barcode" role="tabpanel" aria-labelledby="home-barcode-tab">
                        <div class="row m-4">
                            <div class="col-md-6">
                                Bar Code
                            </div>
                        </div>
                        <input type="hidden" name="product_id" id="product_id" value="{{$product->id}}">
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Bar Code</label>
                            <div class="col-md-6">
                                <input id="bar_code" type="text" class="form-control" name="bar_code" value="{{$product->bar_code}}">
                            </div>
                            @if ($errors->has('bar_code'))
                                <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('bar_code') }}</strong>
                            </span>
                            @endif
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Category<span class="required_span">*</span></label>
                            <div class="col-md-6">
                                <select class="form-control" name="category" id="category" required autofocus>
                                    <option value="">Select Category</option>
                                    @if(count($category)>0)
                                        @foreach($category as $key=>$value)
                                            @if($product->category_id == $value->category_id)
                                                <option value="{{$value->category_id}}" selected="selected">{{$value->name}}</option>
                                            @else
                                                <option value="{{$value->category_id}}">{{$value->name}}</option>
                                            @endif
                                        @endforeach
                                    @endif
                                </select>
                                @if ($errors->has('category'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('category') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Subcategory<span class="required_span">*</span></label>
                            <div class="col-md-6">
                                <select class="form-control"  name="sub_category" id="sub_category">
                                    <option value="">Select subcategory</option>
                                    @if(count($subcategory)>0)
                                        @foreach($subcategory as $key=>$value)
                                            @if($product->subcategory_id == $value->subcategory_id)
                                                <option value="{{$value->subcategory_id}}" selected="selected">{{$value->name}}</option>
                                            @elseif($product->category_id == $value->category_id)
                                                <option value="{{$value->subcategory_id}}">{{$value->name}}</option>
                                            @endif
                                        @endforeach
                                    @endif
                                </select>
                                @if ($errors->has('sub_category'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('sub_category') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6 offset-md-4">
                            <button type="button" class="btn btn-primary update_product_btn" data-steps="1">
                                Update
                            </button>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="basic-details" role="tabpanel" aria-labelledby="basic-details">
                        <div class="row m-4">
                            <div class="col-md-6">
                                Basic details
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Product Name<span class="required_span">*</span></label>
                            <div class="col-md-6">
                                <input id="name" type="text" class="form-control" name="name" value="{{$product->name}}" required autofocus>
                                @if ($errors->has('name'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('name') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Product Title<span class="required_span">*</span></label>
                            <div class="col-md-6">
                                <input id="title" type="text" class="form-control" name="title" value="{{$product->title}}" required autofocus>
                                @if ($errors->has('title'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('title') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Product Summary<span class="required_span">*</span></label>
                            <div class="col-md-6">
                                <input id="summary" type="text" class="form-control" name="summary" value="{{$product->description}}" required autofocus>
                                @if ($errors->has('summary'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('summary') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6 offset-md-4">
                            <!-- <button type="button" class="btn btn-primary privious_btn" data-event_type="tab_previous_2">
                                Previous
                            </button> -->
                            <button type="button" class="btn btn-primary update_product_btn" data-steps="2">
                                Update
                            </button>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="maker-details" role="tabpanel" aria-labelledby="maker-details">
                        <div class="row m-4">
                            <div class="col-md-6">
                                Maker details
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Manufacture<span class="required_span">*</span></label>
                            <div class="col-md-6">
                                <input id="manufacture" type="text" class="form-control" name="manufacture" value="{{$product->manufactured_by}}" required autofocus>
                                @if ($errors->has('manufacture'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('manufacture') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Made In<span class="required_span">*</span></label>
                            <div class="col-md-6">
                                <select class="form-control" name="made_in" id="made_in" required autofocus>
                                    <option value="">Choose</option>

                                    @if(count($country)>0)
                                        @foreach($country as $key=>$value)
                                            @if($value->id == $product->made_in)
                                                <option value="{{$value->id}}" selected="selected">{{$value->name}}</option>
                                            @else
                                                <option value="{{$value->id}}">{{$value->name}}</option>
                                            @endif
                                        @endforeach
                                    @endif
                                </select>
                                @if ($errors->has('category'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('category') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Summary<span class="required_span">*</span></label>
                            <div class="col-md-6">
                         <textarea rows="3" cols="53" name="mnf_summary" id="mnf_summary" class="form-control">
                           {{$product->mnf_summary}}
                         </textarea>
                                @if ($errors->has('category'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('category') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Msr Price<span class="required_span">*</span></label>
                            <div class="col-md-6">
                                <input id="msr_price" type="text" class="form-control" name="msr_price" value="{{$product->msr_price}}" required autofocus onchange="return isNumber('msr_price')">
                                @if ($errors->has('msr_price'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('msr_price') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                    <!-- <div class="row m-4">
                        <label for="name" class="col-md-4 col-form-label text-md-right">Price<span class="required_span">*</span></label>
                        <div class="col-md-6">
                          <input id="price" type="text" class="form-control" name="price" value="{{$product->price}}" required autofocus onchange="return isNumber('price')">
                          @if ($errors->has('price'))
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $errors->first('price') }}</strong>
                            </span>
                          @endif
                        </div>
                      </div> -->
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Currency<span class="required_span"></span></label>
                            <div class="col-md-4">
                                <select class="form-control" name="currency" id="currency">
                                    @if($currency)
                                        @foreach($currency as $value)
                                            <option value="{{$value->id}}" {{$value->id == $product->currency?'selected=selected':''}}>{{$value->country}} {{$value->currency}} ({{$value->symbol}})</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Manufactured Part No<span class="required_span">*</span></label>
                            <div class="col-md-6">
                                <input id="manufacture_port_no" type="text" class="form-control" name="manufacture_port_no" value="{{$product->manufactured_port_no}}" required autofocus>
                                @if ($errors->has('manufacture_port_no'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('manufacture_port_no') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div id="add_more_color_div">
                            <?php
                            if(!isset($product->color_to_show) || empty($product->color_to_show)){
                                echo '<div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Color Show<span class="required_span">*</span></label>
                            <div class="col-md-5">
                              <input id="color" type="color" class="form-control" name="color[]" value="" required autofocus>
                            </div>
                            <div class="col-md-1">
                              <span class="add-more-color" style="color:rgb(0, 105, 217)"><i class="fa fa-plus" aria-hidden="true"></i></span>
                            </div>
                          </div>';
                            }else{
                                $colors= json_decode($product->color_to_show);
                                if(count($colors) > 0){
                                    foreach ($colors as $key => $color) {
                                        if($key == 0){
                                            echo '<div class="row m-4">
                                  <label for="name" class="col-md-4 col-form-label text-md-right">Color Show<span class="required_span">*</span></label>
                                  <div class="col-md-5">
                                    <input id="color" type="color" class="form-control" name="color[]" value="'.$color.'" required autofocus>
                                  </div>
                                  <div class="col-md-1">
                                    <span class="add-more-color" style="color:rgb(0, 105, 217)"><i class="fa fa-plus" aria-hidden="true"></i></span>
                                  </div>
                                </div>';
                                        }else{
                                            echo '
                                <div class="row m-5" id="add_more_color_child_div_'.$key.'">
                                  <label for="name" class="col-md-4 col-form-label text-md-right">
                                  </label>
                                  <div class="col-md-4">
                                    <input  type="color" class="form-control color" name="color[]" value="'.$color.'">
                                  </div>
                                  <span class="delete_color_div" style="color: rgb(0, 105, 217);" data-id="add_more_color_child_div_'.$key.'">
                                  <i class="fa fa-trash" aria-hidden="true"></i>
                                  </span>
                                </div>';
                                        }
                                    }
                                }
                            }
                            ?>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Weight<span class="required_span">*</span></label>
                            <div class="col-md-6">
                                <input id="weight" type="text" class="form-control" name="weight" value="{{$product->weight}}" required autofocus onchange="return isNumber('weight')">
                                @if ($errors->has('weight'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('weight') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Unit Price<span class="required_span">*</span></label>
                            <div class="col-md-4">
                                <select class="form-control" name="unit_price" id="unit_price">
                                    <option value="">Select Unit price</option>
                                    <option value="PounOunce" <?=$product->unit_price == 'PounOunce'? "selected='selected'":""?>>PounOunce</option>
                                    <option value="Kilogram" <?=$product->unit_price == 'Kilogram'? "selected='selected'":""?>>Kilogram</option>
                                    <option value="Gram" <?=$product->unit_price == 'Gram'? "selected='selected'":""?>>Gram</option>
                                    <option value="Milligram" <?=$product->unit_price == 'Milligram'? "selected='selected'":""?>>Milligram</option>
                                </select>
                                @if ($errors->has('unit_price'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('unit_price') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <?php
                        $d_details = json_decode($product->dimension);
                        ?>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Dimenstions Unit<span class="required_span">*</span></label>
                            <div class="col-md-4">
                                <select class="form-control" name="dimenstions" id="dimenstions">
                                    <option value="">Select Dimenstions Unit</option>
                                    <option value="Inches" <?=$d_details->type == 'Inches'? "selected='selected'":""?>>Inches</option>
                                    <option value="Centimeters" <?=$d_details->type == 'Centimeters'? "selected='selected'":""?>>Centimeters</option>
                                </select>
                                @if ($errors->has('dimenstions'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('dimenstions') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right"></label>
                            <div class="col-md-2">
                                <label class="col-form-label">Length<span class="required_span">*</span></label>
                                <input id="dimenstions_length" type="text" class="form-control" name="dimenstions_length" value="{{$d_details->length?$d_details->length:''}}" required autofocus onchange="return isNumber('dimenstions_length')">
                                @if ($errors->has('dimenstions_length'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('dimenstions_length') }}</strong>
                            </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <label class="col-form-label">Width<span class="required_span">*</span></label>
                                <input id="dimenstions_width" type="text" class="form-control" name="dimenstions_width" value="{{$d_details->width?$d_details->width:''}}" required autofocus onchange="return isNumber('dimenstions_width')">
                                @if ($errors->has('dimenstions_width'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('dimenstions_width') }}</strong>
                            </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <label class="col-form-label">Height<span class="required_span">*</span></label>
                                <input id="dimenstions_height" type="text" class="form-control" name="dimenstions_height" value="{{$d_details->height?$d_details->height:''}}" required autofocus onchange="return isNumber('dimenstions_height')">
                                @if ($errors->has('dimenstions_height'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('dimenstions_height') }}</strong>
                            </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <label class="col-form-label">Grith<span class="required_span">*</span></label>
                                <input id="dimenstions_girth" type="text" class="form-control" name="dimenstions_girth" value="{{$d_details->grith?$d_details->grith:''}}" required autofocus onchange="return isNumber('dimenstions_girth')">
                                @if ($errors->has('dimenstions_girth'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('dimenstions_girth') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6 offset-md-4">
                            <!-- <button type="button" class="btn btn-primary privious_btn" data-event_type="tab_previous_3">
                                Previous
                            </button> -->
                            <button type="button" class="btn btn-primary update_product_btn" data-steps="3">
                                Update
                            </button>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="product-media" role="tabpanel" aria-labelledby="product-media">
                        <div class="row">
                            <div class="col-md-6">
                                Product Media
                            </div>
                        </div>
                        <!-- image uploded list here start -->
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Upload Image(Maximum 10 images)<span class="required_span">*</span></label>
                            <div class="col-md-6">
                                <a class="btn btn-primary" style="color: white;" id="browse_image_btn">Browse</a>
                                <input id="upload_img" type="hidden" class="form-control" name="upload_img">
                                @if ($errors->has('upload_img'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('upload_img') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="row" >
                            <div class="col-md-6">
                            </div>
                        </div>
                        <!-- image section start here-->
                        <div id="image_preview_main_div">
                            <?php
                            if(!empty($product->image)){
                            $img = json_decode($product->image);
                            foreach ($img as $key => $value) {
                            ?>
                            <div class="row" id="<?=$value->id?$value->id:""?>">
                                <label for="name" class="col-md-4 col-form-label text-md-right"><?=$value->name?$value->name:""?></label>
                                <div class="col-md-6" style="margin-top: 6px;">
                            <span class="common_view_icon" style="color: rgb(0, 105, 217); cursor: pointer;" data_name="<?=$value->name?$value->name:''?>" data-url="<?=$value->url?$value->url:''?>" data-div_id ="<?=$value->id?$value->id:''?>" onClick="show_preview_image('preview_model','<?=$value->url?asset('/public'.$value->url):asset('/public/profile_img/no_image.png')?>','show_preview_image')">
                              <i class="fa fa-eye" aria-hidden="true"></i>View
                            </span>
                                    <span class="common_delete_icon" data_name="<?=$value->name?$value->name:''?>" data-url="<?=$value->url?$value->url:''?>" data-type="image" data-div_id ="<?=$value->id?$value->id:''?>" style="color:rgb(0, 105, 217);margin-left: 40px;cursor: pointer;"><i class="fa fa-trash" aria-hidden="true"></i>Delete</span>
                                </div>
                            </div>
                            <?php
                            }
                            }
                            ?>
                        </div>
                        <!-- video uploded list here start -->
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Upload Video(Maximum 3)<span class="required_span">*</span></label>
                            <div class="col-md-6">
                                <a class="btn btn-primary" style="color: white;" id="browse_video_btn">Browse</a>
                                <input id="upload_video" type="hidden" class="form-control" name="upload_video">
                                @if ($errors->has('upload_video'))
                                    <span class="invalid-feedback" role="alert">
                              <strong>{{ $errors->first('upload_video') }}</strong>
                          </span>
                                @endif
                            </div>
                        </div>
                        <div class="row" >
                            <div class="col-md-6">
                            </div>
                        </div>
                        <div id="video_preview_main_div">
                            <?php
                            if(!empty($product->video)){
                            $video = json_decode($product->video);
                            foreach ($video as $key => $value) {
                            ?>
                            <div class="row" id="<?=$value->id?$value->id:""?>">
                                <label for="name" class="col-md-4 col-form-label text-md-right"><?=$value->name?$value->name:""?></label>
                                <div class="col-md-6" style="margin-top: 6px;">
                            <span class="common_view_icon" style="color: rgb(0, 105, 217); cursor: pointer;" data_name="<?=$value->name?$value->name:''?>" data-url="<?=$value->url?$value->url:''?>" data-div_id ="<?=$value->id?$value->id:''?>" onClick="show_preview_video('video_preview_model','<?=$value->url?asset('/public/'.$value->url):asset('/public/profile_img/no_image.png')?>','show_preview_video')">
                              <i class="fa fa-eye" aria-hidden="true"></i>View
                            </span>
                                    <span class="common_delete_icon" data_name="<?=$value->name?$value->name:''?>" data-type="video" data-url="<?=$value->url?$value->url:''?>" data-div_id ="<?=$value->id?$value->id:''?>" style="color:rgb(0, 105, 217);margin-left: 40px;cursor: pointer;"><i class="fa fa-trash" aria-hidden="true"></i>Delete</span>
                                </div>
                            </div>
                            <?php
                            }
                            }
                            ?>
                        </div>
                        <!-- video uploded list here start end here -->
                        <div class="col-md-6 offset-md-4">
                            <!-- <button type="button" class="btn btn-primary privious_btn" data-event_type="tab_previous_4">
                                Previous
                            </button> -->
                            <button type="button" class="btn btn-primary update_product_btn" data-steps="4">
                                Update
                            </button>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="about-product" role="tabpanel" aria-labelledby="about-product">
                        <div class="row m-4">
                            <div class="col-md-6">
                                About product
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">How to use product video(Maximum 3)<span class="required_span">*</span></label>
                            <div class="col-md-6">
                                <a class="btn btn-primary" style="color: white;" id="browse_how_to_use_video_btn">Browse</a>
                                <input id="how_to_use_video" type="hidden" class="form-control" name="how_to_use_video">
                                @if ($errors->has('how_to_use_video'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('how_to_use_video') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div id="how_to_use_video_preview_main_div">
                            <?php
                            $how_to_use_video = json_decode($product->how_to_use_video);
                            if($how_to_use_video){
                            foreach ($how_to_use_video as $key => $value) {
                            ?>
                            <div class="row" id="<?=$value->id?$value->id:""?>">
                                <label for="name" class="col-md-4 col-form-label text-md-right"><?=$value->name?$value->name:""?></label>
                                <div class="col-md-6" style="margin-top: 6px;">
                            <span class="common_view_icon" style="color: rgb(0, 105, 217); cursor: pointer;" data_name="<?=$value->name?$value->name:''?>" data-url="<?=$value->url?$value->url:''?>" data-div_id ="<?=$value->id?$value->id:''?>" onClick="show_preview_video('video_preview_model','<?=$value->url?asset('/public/'.$value->url):asset('/public/profile_img/no_image.png')?>','show_preview_video')">
                              <i class="fa fa-eye" aria-hidden="true"></i>View
                            </span>
                                    <span class="common_delete_icon" data_name="<?=$value->name?$value->name:''?>" data-type="how_to_use" data-url="<?=$value->url?$value->url:''?>" data-div_id ="<?=$value->id?$value->id:''?>" style="color:rgb(0, 105, 217);margin-left: 40px;cursor: pointer;"><i class="fa fa-trash" aria-hidden="true"></i>Delete</span>
                                </div>
                            </div>
                            <?php
                            }
                            }
                            ?>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">How to use pictures and text (P.A.T)?<span class="required_span">*</span>
                            </label>
                            <div class="col-md-12">
                          <textarea id="how_to_use_text" name="how_to_use_text" cols="400" rows="10">
                             {{$product->how_to_use_text}}
                          </textarea>
                                @if ($errors->has('how_to_use_text'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('how_to_use_text') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Featured<span class="required_span">*</span></label>
                            <div class="col-md-12">
                          <textarea id="features" name="features" cols="400" rows="10">
                              {{$product->features_feed}}
                          </textarea>
                                @if ($errors->has('features'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('features') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Specification<span class="required_span">*</span></label>
                            <div class="col-md-12">
                           <textarea id="spect" name="spect" cols="400" rows="10">
                              {{$product->spec_field}}
                          </textarea>
                                @if ($errors->has('spect'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('spect') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6 offset-md-4">
                            <!-- <button type="button" class="btn btn-primary privious_btn" data-event_type="tab_previous_5">
                                Previous
                            </button> -->
                            <button type="button" class="btn btn-primary update_product_btn" data-steps="5">
                                Update
                            </button>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="external-sources" role="tabpanel" aria-labelledby="external-sources">
                        <div class="row m-4">
                            <div class="col-md-6">
                                Extrernal Sources
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">By Online Url<span class="required_span"></span></label>
                            <div class="col-md-4" id="online_url_div">
                            <?php
                            if(!empty($product->buy_online_link)){
                                $buy_link = json_decode($product->buy_online_link);
                                $count_txt = 1;
                                foreach($buy_link as $key => $value){
                                    if($key == 0){
                                        echo '<input id="online_url" type="text" class="form-control" name="online_url[]" value="'.$value->online_url.'" required autofocus>';
                                        echo ' <input type="text" class="form-control" name="online_price[]" value="'.$value->price.'" style="margin-top:10px;" placeholder="Buy online price">';
                                    }else{
                                        echo '<div id="online_url_div_child_'.$count_txt.'"><input id="" type="text" class="form-control" name="online_url[]" value="'.$value->online_url.'" required autofocus style="margin-top: 10px;"><input type="text" class="form-control" name="online_price[]" value="'.$value->price.'" style="margin-top:10px;" placeholder="Buy online price"><span class="buy_online_field_remove_icon" data-id="online_url_div_child_'.$count_txt.'" style="color: rgb(0, 105, 217); float: right;margin-top: -33px;margin-right: -15px;"><i class="fa fa-trash" aria-hidden="true"></i></span></div>';
                                    }
                                    $count_txt = $count_txt +1;
                                }

                            }else{
                                echo '<input id="online_url" type="text" class="form-control" name="online_url[]" value="" required autofocus>';
                                echo ' <input type="text" class="form-control" name="online_price[]"  style="margin-top:10px;" placeholder="Buy online price">';
                            }
                            ?>
                            <!-- dynamic div element -->
                                <!-- dynamic div element -->
                                @if ($errors->has('online_url'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('online_url') }}</strong>
                            </span>
                                @endif
                            </div>
                            <div class="col-md-2">
                                <span class="add_more_online_url_btn" style="color: rgb(0, 105, 217);"><i class="fa fa-plus" aria-hidden="true"></i>(Maximum 5)</span>
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Product Webpage</label>
                            <div class="col-md-6">
                                <input id="product_web_url" type="text" class="form-control" name="product_web_url" value="{{$product->web_page_link}}">
                                @if ($errors->has('product_web_url'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('product_web_url') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Manufacture Webpage</label>
                            <div class="col-md-6">
                                <input id="mnf_url" type="text" class="form-control" name="mnf_url" value="{{$product->manufactured_web_page_link}}">
                                @if ($errors->has('mnf_url'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('mnf_url') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6 offset-md-4">
                            <!-- <button type="button" class="btn btn-primary privious_btn" data-event_type="tab_previous_6">
                                Previous
                            </button> -->
                            <button type="button" class="btn btn-primary update_product_btn" data-steps="6">
                                Update
                            </button>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pages-options" role="tabpanel" aria-labelledby="pages-options">
                        <div class="row m-4">
                            <div class="col-md-6">
                                G -Pages options
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Exclude from feed<span class="required_span">*</span></label>
                            <div class="col-md-8">
                                <input  type="radio" class="exlcude_from_fee" name="exlcude_from_feed" value="1" required autofocus {{$product->exclude_from_feed == 1 ?"checked=checked":""}}> Yes
                                <input  type="radio" class="exlcude_from_fee" name="exlcude_from_feed" value="2" required autofocus  {{$product->exclude_from_feed == 2 ?"checked=checked":""}}> No
                                @if ($errors->has('exlcude_from_feed'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('exlcude_from_feed') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Hide Price<span class="required_span">*</span></label>
                            <div class="col-md-8">
                                <input  type="radio" class="hide_price" name="hide_price" value="1" required autofocus {{$product->hide_price == 1 ?"checked=checked":""}} > Yes
                                <input  type="radio" class="hide_price" name="hide_price" value="2" required autofocus {{$product->hide_price == 2 ?"checked=checked":""}} > No
                                @if ($errors->has('hide_price'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('hide_price') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Register to view<span class="required_span">*</span></label>
                            <input  type="radio" class="register_to_view" name="register_to_view" value="1"   required autofocus {{$product->register_to_view == 1 ?"checked=checked":""}}  > Yes
                            <input  type="radio" class="register_to_view" name="register_to_view" value="2" required autofocus {{$product->register_to_view == 2 ?"checked=checked":""}} > No
                            @if ($errors->has('register_to_view'))
                                <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('register_to_view') }}</strong>
                            </span>
                            @endif
                        </div>
                        <div class="row m-4">
                            <label for="name" class="col-md-4 col-form-label text-md-right">To be page age resticted<span class="required_span">*</span></label>
                            <input  type="radio" class="to_be_age_resticted" name="to_be_age_resticted" value="1" required autofocus {{$product->to_be_age_resticted == 1 ?"checked=checked":""}}> Yes
                            <input  type="radio" class="to_be_age_resticted" name="to_be_age_resticted" value="2" required autofocus {{$product->to_be_age_resticted == 2 ?"checked=checked":""}} > No
                        </div>
                        <div class="row m-4" id="age_resticted_div" style="display: {{$product->to_be_age_resticted == 1?'block':'none'}}">
                            <label for="name" class="col-md-4 col-form-label text-md-right">Choose Age<span class="required_span">*</span></label>
                            <div class="col-md-6" style="margin-left: 334px;">
                                <select class="form-control" id="age_resticted" name="age_resticted">
                                    <option value="for ages 10 and up" {{$product->age_restricted == 'for ages 10 and up'?"selected=selected":""}}>for ages 10 and up</option>
                                    <option value="for ages 12 and up" {{$product->age_restricted == 'for ages 12 and up'?"selected=selected":""}}>for ages 13 and up</option>
                                    <option value="for ages 17 and up" {{$product->age_restricted == 'for ages 17 and up'?"selected=selected":""}}>for ages 17 and up</option>
                                    <option value="only for adults ages 18 and up" {{$product->age_restricted == 'only for adults ages 18 and up'?"selected=selected":""}}>only for adults ages 18 and up</option>
                                </select>
                                @if ($errors->has('age_resticted'))
                                    <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('age_resticted') }}</strong>
                            </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6 offset-md-4">
                            <!--  <button type="button" class="btn btn-primary privious_btn" data-event_type="tab_previous_7">
                                 Previous
                             </button> -->
                            <button type="button" class="btn btn-primary update_product_btn" data-steps="7">
                                Update
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <hr class="featurette-divider">
        @include('common.menu')
    </div>
    <!-- Modal Image upload model start-->
    <style type="text/css">
        .model_button{
            margin-left: 63px;
            padding: 9px;
            margin-top: -8px;
        }
    </style>
    <div id="myModal" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close close_btn" data-model_id="myModal" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4">Upload image</div>
                        <div class="col-md-4">
                            <input type="file" name="product_image" id="product_image" onchange=" readURL(this,'product_image','preview_image')">
                        </div>
                        <div class="col-md-4">
                            <a class="btn btn-primary model_button" style="
                    color:white" id="model_upload_btn" data-type="image">Submit</a>
                        </div>
                    </div>
                    <img src="{{asset('/public/img/loading.gif')}}" height="144px"  style="position: absolute; z-index: 1;margin-top: -89px;margin-left: 165px; display: none;" id="loader_img" />
                    <div class="row">
                        <label for="name" class="col-md-4 col-form-label text-md-right"></label>
                        <img src="{{asset('/public/profile_img/no_image.png')}}" height="150px" width="200px;" id="preview_image">
                    </div>
                </div>
                <div class="modal-footer">
                </div>
            </div>

        </div>
    </div>
    <!-- Modal how to used upload model start -->
    <div id="how_to_use_video_model" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close close_btn" data-model_id="how_to_use_video_model" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4">Upload how to use product video</div>
                        <div class="col-md-4">
                            <input type="file" accept="video/*" name="how_to_use_product_video" id="how_to_use_product_video" onchange=" readVideoURL(this,'how_to_use_product_video','how_to_use_preview_video')">
                        </div>
                        <div class="col-md-4">
                            <a class="btn btn-primary model_button" style="
                  color:white" id="how_to_use_model_upload_btn" data-type="video">Submit</a>
                        </div>
                    </div>
                    <img src="{{asset('/public/img/loading.gif')}}" height="144px"  style="position: absolute; z-index: 1;margin-top: -89px;margin-left: 165px; display: none;" id="video_loader_img" />
                    <div class="row">
                        <label for="name" class="col-md-4 col-form-label text-md-right"></label>
                    <!-- <img src="{{asset('/public/profile_img/no_image.png')}}" height="150px" width="200px;" id="preview_video"> -->
                        <video width="200" height="200" controls class="video">
                            <source src="mov_bbb.mp4" id="how_to_use_preview_video">
                            Your browser does not support HTML5 video.
                        </video>
                    </div>
                </div>
                <div class="modal-footer">
                </div>
            </div>

        </div>
    </div>
    <!-- Modal Image upload model end-->
    <div id="myModal_video" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close close_btn" data-model_id="myModal_video" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4">Upload Video</div>
                        <div class="col-md-4">
                            <input type="file" accept="video/*" name="product_video" id="product_video" onchange=" readVideoURL(this,'product_video','preview_video')">
                        </div>
                        <div class="col-md-4">
                            <a class="btn btn-primary model_button" style="
                  color:white" id="model_upload_btn" data-type="video">Submit</a>
                        </div>
                    </div>
                    <img src="{{asset('/public/img/loading.gif')}}" height="144px"  style="position: absolute; z-index: 1;margin-top: -89px;margin-left: 165px; display: none;" id="video_loader_img" />
                    <div class="row">
                        <label for="name" class="col-md-4 col-form-label text-md-right"></label>
                    <!-- <img src="{{asset('/public/profile_img/no_image.png')}}" height="150px" width="200px;" id="preview_video"> -->
                        <video width="200" height="200" controls class="video">
                            <source src="mov_bbb.mp4" id="preview_video">
                            Your browser does not support HTML5 video.
                        </video>
                    </div>
                </div>
                <div class="modal-footer">
                </div>
            </div>

        </div>
    </div>
    <div id="preview_model" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close close_btn" data-model_id="preview_model" data-type="image" data-dismiss="modal">&times;</button>
                </div>
                <div class="row">
                    <div class="col-md-4">
                    </div>
                    <div class="col-md-4">
                        Image Preview
                    </div>
                    <div class="col-md-4">
                    </div>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <label for="name" class="col-md-2 col-form-label text-md-right"></label>
                        <img src="{{asset('/public/profile_img/no_image.png')}}" height="200px" width="250px;" id="show_preview_image">
                    </div>
                </div>
                <div class="modal-footer">
                </div>
            </div>

        </div>
    </div>
    <div id="video_preview_model" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close close_btn" data-model_id="video_preview_model" data-type="video" data-dismiss="modal">&times;</button>
                </div>
                <div class="row">
                    <div class="col-md-4">
                    </div>
                    <div class="col-md-4">
                        Video Preview
                    </div>
                    <div class="col-md-4">
                    </div>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <label for="name" class="col-md-2 col-form-label text-md-right"></label>
                        <video width="400" height="400" controls class="video" style="margin-top: -67px;margin-left: -34px;">
                            <source src="mov_bbb.mp4" id="show_preview_video">
                            Your browser does not support HTML5 video.
                        </video>
                    </div>
                </div>
                <div class="modal-footer">
                </div>
            </div>

        </div>
    </div>
    <?php
    if(is_array($product->color_to_show) || is_object($product->color_to_show)){
        $color_field_count = count(json_decode($product->color_to_show));
    }else{
        $color_field_count = 0;
    }
    ?>
    <script type="text/javascript">
        @if(!empty($product->image))

        @else
        var product_img_array = [];

        @endif
        var product_video_array = [];
        var how_to_use_video_array = [];
        var buy_online_field_count = 0;
        var add_more_color = [];
        var color_field_count = 0;

        $(document).ready(function(){
            var color_field_count = <?=$color_field_count?>;
            $("#mnf_summary").val($("#mnf_summary").val().trim());
            product_img_array = <?php echo json_encode(json_decode($product->image)); ?>;
            product_video_array = <?php echo json_encode($video); ?>;
            how_to_use_video_array = <?php echo json_encode($how_to_use_video); ?>;
            if(!how_to_use_video_array){
                how_to_use_video_array = [];
            }
            if(!product_video_array){
                product_video_array = [];
            }
            $("#upload_img").val(JSON.stringify(product_img_array));
            $("#upload_video").val(JSON.stringify(product_video_array));
            //open a model for browse image upload
            $('body').on('click', '#browse_image_btn', function() {
                var length = product_img_array.length;
                $('#preview_image').attr("src","{{asset('/public/profile_img/no_image.png')}}");
                if(length<10){
                    $("#myModal").modal("toggle");
                }else{
                    toastr.error("Sorry, You can upload maximum 10 images!");
                    //$("#myModal").modal("toggle");
                    return true;
                }
            });
            //open a model for browse video upload
            $('body').on('click', '#browse_video_btn', function() {
                var length = product_video_array.length;
                $('#preview_video').attr("src","{{asset('/public/profile_img/no_image.png')}}");
                if(length<3){
                    $("#myModal_video").modal("toggle");
                }else{
                    toastr.error("Sorry, You can upload maximum 3 video!");
                    return true;
                    //$("#myModal_video").modal("toggle");
                }
            });
            $('body').on('click', '#browse_how_to_use_video_btn', function() {
                if(how_to_use_video_array){
                    var length = how_to_use_video_array.length;
                }else{
                    var length = 0;
                }
                $('#how_to_use_preview_video').attr("src","{{asset('/public/profile_img/no_image.png')}}");
                if(length<3){
                    $("#how_to_use_video_model").modal("toggle");
                }else{
                    toastr.error("Sorry, You can upload maximum 3 video!");
                    return true;
                    //$("#myModal_video").modal("toggle");
                }
            });

            $('body').on('click', '#how_to_use_model_upload_btn', function(e) {
                var image_file = $("#how_to_use_product_video").prop("files")[0];
                var form_data = new FormData();
                form_data.append("custom_name",image_file);
                form_data.append("folder_name",'product');
                form_data.append("type",'video');
                $("#video_loader_img").css('display','block');
                $.ajax({
                    type: "POST",
                    url: site_url+"/common/file_upload",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: form_data,
                    cache: false,
                    processData: false,
                    contentType: false,
                    success: function(res){
                        $("#video_loader_img").css('display','none');
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            toastr.success(data.msg);
                            //$("#image_preview_main_div").html(data.content);
                            $("#how_to_use_video_preview_main_div").append(data.content);
                            var img_obj = {};
                            img_obj.name = data.name;
                            img_obj.url = data.url;
                            img_obj.id = data.id;
                            how_to_use_video_array.push(img_obj);
                            $("#how_to_use_video").val(JSON.stringify(how_to_use_video_array));
                            $("#how_to_use_video_model").modal("toggle");
                            $('#how_to_use_preview_video').attr("src","{{asset('/public/profile_img/no_image.png')}}");
                            $("#how_to_use_product_video").val('');
                            console.log('File uploaded success fully');
                        }else{
                            toastr.error(data.msg);
                        }
                    }
                });
            });
            //close a model
            $('body').on('click', '.close_btn', function(e) {
                var id = $(this).data('model_id');
                $("#"+id).modal("toggle");
            });
            //file upload
            $('body').on('click', '#model_upload_btn', function(e) {
                var type = $(this).data('type');
                if(type == 'video'){
                    var image_file = $("#product_video").prop("files")[0];
                }else{
                    var image_file = $("#product_image").prop("files")[0];
                }

                var form_data = new FormData();
                form_data.append("custom_name",image_file);
                form_data.append("folder_name",'product');
                form_data.append("type",type);
                if(type == 'image')  {
                    $("#loader_img").css('display','block');
                }else if(type == 'video'){
                    $("#video_loader_img").css('display','block');
                }
                $.ajax({
                    type: "POST",
                    url: site_url+"/common/file_upload",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: form_data,
                    cache: false,
                    processData: false,
                    contentType: false,
                    success: function(res){
                        if(type == 'image')  {
                            $("#loader_img").css('display','none');
                        }else if(type == 'video'){
                            $("#video_loader_img").css('display','none');
                        }
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            toastr.success(data.msg);
                            //$("#image_preview_main_div").html(data.content);
                            if(type == 'image'){
                                $("#image_preview_main_div").append(data.content);
                                var img_obj = {};
                                img_obj.name = data.name;
                                img_obj.url = data.url;
                                img_obj.id = data.id;
                                product_img_array.push(img_obj);
                                $("#upload_img").val(JSON.stringify(product_img_array));
                                $("#myModal").modal("toggle");
                                $('#preview_image').attr("src","{{asset('/public/profile_img/no_image.png')}}");
                                $("#product_image").val('');
                            }else{
                                $("#video_preview_main_div").append(data.content);
                                var img_obj = {};
                                img_obj.name = data.name;
                                img_obj.url = data.url;
                                img_obj.id = data.id;
                                product_video_array.push(img_obj);
                                $("#upload_video").val(JSON.stringify(product_video_array));
                                $("#myModal_video").modal("toggle");
                                $('#preview_video').attr("src","{{asset('/public/profile_img/no_image.png')}}");
                                $("#product_video").val('');
                            }
                            console.log('File uploaded success fully');
                        }else{
                            toastr.error(data.msg);
                        }
                    }
                });
            });
            $('body').on('click', '.common_delete_icon', function(e) {
                var id  = $(this).data('div_id');
                var type = $(this).data('type');
                //alert("type: "+type);
                if(type == 'image'){
                    $.each(product_img_array, function( index, value ) {
                        if(id == value.id) {
                            product_img_array.splice(index, 1);
                            $("#"+id).remove();
                        }
                    });
                    setTimeout(function(){
                        $("#upload_img").val(JSON.stringify(product_img_array));
                    }, 600);
                }else if(type == 'video'){
                    $.each(product_video_array, function( index, value ) {
                        if(id == value.id) {
                            product_video_array.splice(index, 1);
                            $("#"+id).remove();
                        }
                    });
                    setTimeout(function(){
                        $("#upload_video").val(JSON.stringify(product_video_array));
                    }, 600);
                }else if(type == 'how_to_use'){
                    $.each(how_to_use_video_array, function( index, value ) {
                        if(id == value.id) {
                            how_to_use_video_array.splice(index, 1);
                            $("#"+id).remove();
                        }
                    });
                    setTimeout(function(){
                        $("#how_to_use_video_array").val(JSON.stringify(how_to_use_video_array));
                    }, 600);
                }
            });
            //add more buy online url filed
            $('body').on('click', '.add_more_online_url_btn', function() {
                var online_field_array = document.getElementsByName('online_url[]');
                for (var i = 0; i <online_field_array.length; i++) {
                    //console.log('buy online url:'+online_field_array);
                    if(online_field_array[i].value.trim() == '' || online_field_array[i].value.trim() == undefined){
                        toastr.error("Please enter buy online url");
                        return true;
                    }
                }
                if(buy_online_field_count<5){
                    //toastr.success("Text box has been added!");
                    buy_online_field_count = buy_online_field_count + 1;
                    var html = '<div id="online_url_div_child_'+buy_online_field_count+'"><input id="" type="text" class="form-control" name="online_url[]" value="" required autofocus style="margin-top: 10px;" placeholder="Buy online url"><input type="text" class="form-control" name="online_price[]" style="margin-top:10px;" placeholder="Buy online price"><span class="buy_online_field_remove_icon" data-id="online_url_div_child_'+ buy_online_field_count+'" style="color: rgb(0, 105, 217); float: right;margin-top: -33px;margin-right: -15px;"><i class="fa fa-trash" aria-hidden="true"></i></span></div>';
                    $("#online_url_div").append(html);
                }else{
                    toastr.error("Sorry, You can add only 5 url.");
                    return true;
                }
            });
            $('body').on('click', '.buy_online_field_remove_icon', function() {
                var id = $(this).data('id');
                $("#"+id).remove();
                buy_online_field_count = buy_online_field_count - 1;
            });
            //add more color
            $('body').on('click', '.add-more-color', function() {
                var add_more_color_array = document.getElementsByName('color[]');
                for (var i = 0; i <add_more_color_array.length; i++) {
                    //console.log('buy online url:'+online_field_array);
                    if(add_more_color_array[i].value.trim() == '' || add_more_color_array[i].value.trim() == undefined){
                        toastr.error("Please enter color");
                        return true;
                    }
                }
                if(color_field_count<10){
                    //toastr.success("Text box has been added!");
                    color_field_count = color_field_count + 1;
                    var html = ' <div class="row m-4" id="add_more_color_child_div_'+color_field_count+'"><label for="name" class="col-md-4 col-form-label text-md-right"></label><div class="col-md-5"><input  type="color" class="form-control color" name="color[]" value="{{old('color')}}"></div><span class="delete_color_div" style="color: rgb(0, 105, 217);" data-id="add_more_color_child_div_'+ color_field_count+'"><i class="fa fa-trash" aria-hidden="true"></i></span></div>';
                    $("#add_more_color_div").append(html);
                }else{
                    toastr.error("Sorry, You can add only 10 color.");
                    return true;
                }
            });
            //delete add more color div
            $('body').on('click', '.delete_color_div', function() {
                var id = $(this).data('id');
                $("#"+id).remove();
                color_field_count = color_field_count - 1;
            });
            CKEDITOR.replace( 'how_to_use_text' );
            CKEDITOR.replace( 'features' );
            CKEDITOR.replace( 'spect' );
            //get subcategory list by id.
            $('body').on('change', '#category', function() {
                var id = $("#category").val();
                $.ajax({
                    type: "POST",
                    url: site_url+"/ajax/get-subcategory",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {id:id},
                    success: function(res){
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            $("#sub_category").html(data.content);
                        }
                    }
                });
            });

            //update product
            $('body').on('click', '.update_product_btn', function() {
                var steps = $(this).data('steps');
                var id = $("#product_id").val().trim();
                if(steps == 1){
                    var bar_code = $("#bar_code").val().trim();
                    if(bar_code != ''){
                        var pattern_number_only = /^\d+$/;
                        if(!pattern_number_only .test(bar_code)){
                            toastr.error("Barcode should be numbers only");
                            return true;
                        }
                        if(bar_code.length <8 || bar_code.length >20){
                            toastr.error("Bar code length(minimum 8 and maximum 20)");
                            return true;
                        }
                    }
                    var params= {
                        'bar_code' : $("#bar_code").val().trim(),
                        'category' : $("#category").val().trim(),
                        'sub_category' : $("#sub_category").val().trim(),
                        'steps' : steps,
                        'id' : id
                    };
                }else if(steps == 2){
                    var params= {
                        'name' : $("#name").val().trim(),
                        'title' : $("#title").val().trim(),
                        'summary' : $("#summary").val().trim(),
                        'steps' : steps,
                        'id' : id
                    };
                }else if(steps == 3){
                    var color_array = [];
                    var color_element = document.getElementsByName('color[]');
                    for (var i = 0; i <color_element.length; i++) {
                        //alert("color:"+color_element[i].value);
                        color_array.push(color_element[i].value);
                    }
                    var params= {
                        'manufacture' : $("#manufacture").val().trim(),
                        'made_in': $("#made_in").val().trim(),
                        'mnf_summary': $("#mnf_summary").val().trim(),
                        'msr_price' : $("#msr_price").val().trim(),
                        //'price' : $("#price").val().trim(),
                        'currency' : $("#currency").val().trim(),
                        'manufacture_port_no' : $("#manufacture_port_no").val().trim(),
                        'color' : color_array,
                        'unit_price' : $("#unit_price").val().trim(),
                        'weight'  : $("#weight").val().trim(),
                        'dimenstions' : $("#dimenstions").val().trim(),
                        'dimenstions_height' : $("#dimenstions_height").val().trim(),
                        'dimenstions_width' : $("#dimenstions_width").val().trim(),
                        'dimenstions_length' : $("#dimenstions_length").val().trim(),
                        'dimenstions_girth' :   $("#dimenstions_girth").val().trim(),
                        'steps' : steps,
                        'id' : id
                    };
                }else if(steps == 4){
                    var params= {
                        'upload_img' : $("#upload_img").val(),
                        'upload_video' :  $("#upload_video").val(),
                        'steps' : steps,
                        'id' : id
                    };
                }else if(steps == 5){
                    var params= {
                        'how_to_use_video' : $("#how_to_use_video").val(),
                        'how_to_use_text' : CKEDITOR.instances['how_to_use_text'].getData(),
                        'features' : CKEDITOR.instances['features'].getData(),
                        'spect' : CKEDITOR.instances['spect'].getData(),
                        'steps' : steps,
                        'id' : id
                    };
                }else if(steps == 6){
                    var online_url_array = [];
                    var online_url = document.getElementsByName('online_url[]');
                    for (var i = 0; i <online_url.length; i++) {
                        online_url_array.push(online_url[i].value);
                    }
                    var online_price_array = [];
                    var online_price = document.getElementsByName('online_price[]');
                    for (var i = 0; i <online_price.length; i++) {
                        online_price_array.push( online_price[i].value);
                    }
                    var params= {
                        'online_url' : online_url_array,
                        'online_price' : online_price_array,
                        'product_web_url' : $("#product_web_url").val().trim(),
                        'mnf_url' : $("#mnf_url").val().trim(),
                        'steps' : steps,
                        'id' : id
                    };
                }else if(steps == 7){
                    var params= {
                        'exclude_from_feed' : $("input[name='exlcude_from_feed']:checked").val(),
                        'hide_price' : $("input[name='hide_price']:checked").val(),
                        'register_to_view' : $("input[name='register_to_view']:checked").val(),
                        'age_resticted' : $("#age_resticted").val(),
                        'to_be_age_resticted' : $("input[name='to_be_age_resticted']:checked").val(),
                        'steps' : steps,
                        'id' : id
                    };
                }
                $("#loader_img_product_update").css('display','block');
                $.ajax({
                    type: "POST",
                    url: site_url+"/creator/edit-product",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: params,
                    success: function(res){
                        $("#loader_img_product_update").css('display','none');
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            toastr.success(data.msg);
                        }else{
                            toastr.error(data.msg);
                        }
                    }
                });
            });
        });
        //age resticted
        $(document).on('change', '[type="radio"][name="to_be_age_resticted"]', function() {
            var currentlyValue = $(this).val(); // Get the radio checked value
            //alert(currentlyValue);
            if(currentlyValue == 1 ){
                $("#age_resticted_div").css('display','block');
            }else{
                //$(".company_info_section input").removeAttr('required');
                $("#age_resticted_div").css('display','none');
            }
        });
    </script>
@endsection
