@extends('layouts.layout')

{{-- head Start--}}
  @section('meta_description'){{$meta_description}}@endsection
  @section('title'){{$title}}@endsection
  @section('more_css_style')
    <style>
      form input.ng-pristine{border: 1px solid lightblue;}
      form input.ng-dirty{border: 1px solid pink;}
    </style>
  @endsection
  @section('Google_adsense')
    @includeif('layouts.googleadsense')
  @endsection
{{-- head end--}}


{{-- Body start--}}

{{-- section starts--}}
  {{-- top --}}
  @section('section_content_top')
  @endsection
  
  {{-- Middle --}}
  @section('section_content')
  <div class="container" ng-app="app">
    <div class="py-5 text-center">

        <h2>Create a <b>Publisher</b> account</h2>
        <p class="lead">Create a Publisher account to be able to create product G-Pages.</p>
        <p>Read more about the types of <a href="Creator-Types">creator accounts</a></p>
    </div>
    
    <div class="py-5" ng-controller='create-P-ACC-cntrlr'>
    
        <div class="p-3 my-3">
            <h5 class="d-flex justify-content-between align-items-center mb-3">
            <span class="text-muted">Your progress</span>
            <span class="badge badge-info badge-pill"><span ng-bind="stepNumb"></span> - 4</span>
          </h5>
            <div class="progress">
                <div class="progress-bar" role="progressbar" style="width: 15%" aria-valuenow="15" aria-valuemin="0" aria-valuemax="100" ng-show="show_cAcc_prog_01">1</div>
                <div class="progress-bar" role="progressbar" style="width: 30%" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100" ng-show="show_cAcc_prog_02">2</div>
                <div class="progress-bar" role="progressbar" style="width: 20%" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100" ng-show="show_cAcc_prog_03">3</div>
                <div class="progress-bar" role="progressbar" style="width: 45%" aria-valuenow="45" aria-valuemin="0" aria-valuemax="100" ng-show="show_cAcc_prog_04">4</div>
            </div>
            <div ng-show="!show_cAcc_prog_01">
                <p>Already have account? <a href="log-in">Log in</a></p>
            </div>
        </div>
    
        <div class="p-3 my-3">
            <ng-include src="show_Create_ACC_HTML_form"></ng-include>
    
        </div>
    </div>
  </div>
  @endsection

  {{-- bottom for pop ups--}}
  @section('section_content_3')
  @endsection

{{-- section end--}}

{{-- footer Start--}}
{{-- footer end --}}

{{-- Scripts start--}}
  @section('ext_scripts')
  <!-- For country and state selector cass start-->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/country-region-dropdown-menu/1.2.1/geodatasource-cr.min.js"></script>
  <!--cass end -->
    <script src="https://ajax.googleapis.com/ajax/libs/angularjs/1.7.4/angular.min.js"></script>
    <script src="/js/angular-contr.js"></script>
  @endsection
{{-- script end--}}

{{--Body  end--}}