@extends('layouts.layout_C')

{{-- head Start--}}
  @section('meta_description'){{$meta_description}}@endsection
  @section('title'){{$title}}@endsection
  @section('more_css_style')
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.css">
  <style>
    @media (min-width: 768px) 
      { 
        #smallmenu
        {
          display:none;
        }
      }
      @includeif('layouts.inc_supportMessageExchangeCSS')
  </style>
  @endsection
  @section('Google_adsense')
    @includeif('layouts.googleadsense')
  @endsection
{{-- head end--}}


{{-- Body start--}}

{{-- section starts--}}
  {{-- top --}}
  @section('section_content_top')
  @endsection
  
  {{-- Middle --}}
  @section('section_content')
    <div class="container-fluid mt-5">

            <nav id="smallmenu" class="navbar navbar-expand-lg navbar-light bg-light">
              <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav2" aria-controls="navbarNav2" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
              </button>
              <div class="collapse navbar-collapse text-center" id="navbarNav2">
                @includeif('layouts.dash_side_nav')
              </div>
            </nav>
        <div class="row">
            <nav class="col-md-2 d-none d-md-block bg-transparent sidebar">
              <div class="sidebar-sticky">
                @includeif('layouts.dash_side_nav')
              </div>
            </nav>

            <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-4">
              <!-- Page title -->
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">{{$pagetitle}}</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                    </div>
                </div>

                <!-- top Gpages -->
                <?php 
                  $data =
                    [
                      'heading' => $heading,
                      'pass' => $pass
                    ]; 
                ?>
                <div class="row">
                  @if ($pass === 'Create')
                  @endif
                    @includeif('layouts.product_forms_side_Nav')

                  @includeif('layouts.dataCard_2',$data)
                </div>
                

            </main>
        </div>
    </div>
  @endsection

  {{-- bottom for pop ups--}}
  @section('section_content_3')
    {{-- Create Gpage pop ups--}}
    @includeif('layouts.create_Gpage_pop_ups')
  @endsection

{{-- section end--}}

{{-- footer Start--}}
  @section('footer_content_1')
  @includeif('layouts.footer_C')
  @endsection
{{-- footer end --}}

{{-- Scripts start--}}
  @section('ext_scripts')
    {{--forms js Scripts --}}
    <script>
        function isNumber(num){
            return !isNaN(num)
        }

        function custom_required (name)
        {
            if(!$('#'+name).val())
            {
                return false;
            }else {
                return true;
            }
        }
    </script>
                  @if ($pass === 'Create')
                    @includeif('layouts.create_js2')
                  @elseif ($pass === 'edit')
    <script src="https://cdn.ckeditor.com/4.5.6/standard/ckeditor.js"></script>
                  @includeif('layouts.edit_js2')
                  @endif



  @endsection
{{-- script end--}}

{{--Body  end--}}