
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>

<script>
    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function(e) {
                $('#blah').attr('src', e.target.result);
            }

            reader.readAsDataURL(input.files[0]);
        }
    }

    $("#preview_image").change(function() {
        readURL(this);
    });

    function show_preview_image(model_id,src,id){
        //alert('src:'+src+ " id:"+id);
        $('#'+id).attr('src', src);
        $("#"+model_id).modal("toggle");
    }
</script>
<script type="text/javascript">

    $(document).ready(function(){

        //check barcode is all ready exist or not
                    $('body').on('keyup blur change', '#bar_code', function() {
                        //$('#bar_code_error').toast('hide');
                       // $("#nav-f1 .continue_btn").prop("disabled", false);
                        var bar_code = $("#bar_code").val().trim();
                        $.ajax({
                            type: "POST",
                            url: "/ajax/check-barcode",
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            data: {bar_code:bar_code,
                                "_token": "{{ csrf_token() }}",

                            },
                            success: function(res){
                                var data = jQuery.parseJSON(res);
                                if(data.status){
                                    $('#bar_code').addClass('is-invalid');
                                    $('#bar_code_error').toast('show');
                                    //$("#nav-f1 .continue_btn").prop("disabled", true);
                                }
                            }
                        });
                    });


        //This code is used for handling form steps when click on continue  button
        $('body').on('click', '.continue_btn', function() {
            var type = $(this).data('event_type');
            if(type == 'tab_continue_1'){
                var bar_code = $("#bar_code").val().trim();
                if(bar_code != ''){
                    var pattern_number_only = /^\d+$/;
                    if(!pattern_number_only .test(bar_code)){
                        toastr.error("Barcode should be numbers only");
                        return true;
                    }
                    if(bar_code.length <8 || bar_code.length >13){
                        toastr.error("Bar code length(minimum 8 and maximum 20)");
                        return true;
                    }else{
                        $('#bar_code').removeClass('is-invalid');
                    }
                }

                if(!custom_required('category')){
                    toastr.error("Please Select Category!");
                    $('#category').addClass('is-invalid');
                    return true;
                }else if(!custom_required('sub_category')){
                    toastr.error("Please Select Subcategory!");
                    $('#category').removeClass('is-invalid');
                    $('#sub_category').addClass('is-invalid');
                    return true;
                }

                    $('#category').removeClass('is-invalid');
                    $('#sub_category').removeClass('is-invalid');
                $("#nav-basic-details").trigger('click');
            }else if(type == 'tab_continue_2'){
                if(!custom_required('name')){


                    toastr.error("Please Enter Name!");
                    $('#name').addClass('is-invalid');
                    return true;
                }else{
                    $('#name').removeClass('is-invalid');

                    var prodname = $("#name").val().trim();
                    if(prodname != ''){
                        var pattern_prodname_only = /[!@#$%^&*()~`+=\[\]{};':"\\|,.<>\/?]/;
                        if(pattern_prodname_only.test(prodname)){
                            toastr.error(" The product name should not contain special characters except [ -  _ ].");
                            return true;
                        }else if(prodname.length <3 || prodname.length >50){
                            toastr.error(" The product name length(minimum 8 and maximum 20)");
                            return true;
                        }
                    }

                }

                $("#nav-maker-details").trigger('click');
            }
        });

        //This code is used for handling form steps when click on previous button
        $('body').on('click', '.privious_btn', function() {
            var type = $(this).data('event_type');
            //alert("button is click for "+type);
            if(type == 'tab_previous_2'){
                $("#nav-home-barcode").trigger('click');
            }else if(type == 'tab_previous_3'){
                $("#nav-basic-details").trigger('click');
            }
        });

        //close a model
        $('body').on('click', '.close_btn', function(e) {
            var id = $(this).data('model_id');
            $("#"+id).modal("toggle");
        });


        //define old sub_category
        var sub_category = "{{old('sub_category')}}";

        $('body').on('change', '#category', function() {
            var id = $("#category").val();
            $.ajax({
                type: "POST",
                url: "/ajax/get-subcategory",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {id:id,
                    "_token": "{{ csrf_token() }}",
                },
                success: function(res){
                    var data = jQuery.parseJSON(res);
                    if(data.status){
                        $("#sub_category").html(data.content);
                    }
                }
            });
        });
        
        if (!sub_category == '') {
            $('#sub_category option:contains(sub_category)')
        }
    });

        //submit form
        $('#product_add_submit_btn').click(function(event) {
            event.preventDefault();
            if(!custom_required('manufacture')){ 
                    toastr.error("Please Enter Manufactured!");
                    $('#manufacture').addClass('is-invalid');

                    return true;
                }else if($("#manufacture").val().trim() != ''){
                    var manuName = $("#manufacture").val().trim();
                    if(manuName.length <2 || manuName.length >50){
                            toastr.error(" The manufacture's name length(minimum 3 and maximum 50)");
                            return true;
                        }
                }else if(!custom_required('made_in')){
                    toastr.error("Please Choose Made In!");
                    $('#made_in').addClass('is-invalid');
                    return true;
                }else if(!custom_required('name')){
                    toastr.error("Please enter product name!");
                    $('#name').addClass('is-invalid');
                    return true;
                }

            var bar_code = $("#bar_code").val().trim();
                if(bar_code != ''){
                    var pattern_number_only = /^\d+$/;
                    if(!pattern_number_only .test(bar_code)){
                        toastr.error("Barcode should be numbers only");
                        return true;
                    }
                    if(bar_code.length <8 || bar_code.length >20){
                        toastr.error("Bar code length(minimum 8 and maximum 20)");
                        return true;
                    }
                }


                if(!custom_required('category')){
                    toastr.error("Please Select Category!");
                    $('#category').removeClass('is-invalid');
                    return true;
                }else if(!custom_required('sub_category')){
                    toastr.error("Please Select Subcategory!");
                    $('#sub_category').addClass('is-invalid');
                }
                   
            $("#add_product_frm").submit();
        });

            //
</script>