@extends('layouts.layout')

{{-- head Start--}}
  @section('meta_description'){{$meta_description}}@endsection
  @section('title'){{$title}}@endsection
  @section('more_css_style')
    <style type="text/css">
      .nav-link:hover
          {
               border-bottom: .25rem solid black;
          }

    </style>
  @endsection
  @section('Google_adsense')
    @includeif('gfects.googleadsense')
  @endsection
{{-- head end--}}


{{-- Body start--}}

{{-- section starts--}}
  {{-- top --}}
  @section('section_content_top')
  	<div class="container">
        <h1 class="bd-title">Introduction</h1>
        <p class="lead">
          Welcome to Gfects. We have developed this new service for businesses to be able to publish an interactive page for their customers to find useful information about their products quickly. And also, for the user(publisher) to be able to create and publish pages about products they want the world to know better.
        </p>
      </div>
  @endsection

  {{-- Middle --}}
  @section('section_content')
      <hr class="featurette-divider">
    <nav>
      <div class="nav nav-tabs" id="nav-tab" role="tablist">
        <a class="nav-item nav-link active" id="nav-home-tab" data-toggle="tab" href="#nav-home" role="tab" aria-controls="nav-home" aria-selected="true">For the customer/user</a>
        <a class="nav-item nav-link" id="nav-profile-tab" data-toggle="tab" href="#nav-profile" role="tab" aria-controls="nav-profile" aria-selected="false">For the Maop<span class="d-none">(manufacturer, agent or producer)</span> and  publisher</a>
      </div>
    </nav>
    <div class="tab-content" id="nav-tabContent">
      <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">
        <h4 class="mt-3">What?</h4>
        <p>
          G-page is the page that gives you all the information you need to know about a product.
        </p>
        <h4 class="mt-3">Why?</h4>
        <p>
          G-pages are very specific to a product. If you find by barcode or scan it, if that barcode is in our database, you would land on the exact page for that product.
          <br>
          Also, you can find the lowest prices online for a specific product.
          <br>
          Gfects gives you images, videos, how to use, features, spec's, and reviews on our G-pages.
          <br>
          You can save a product to a list for later.
        </p>
        <h4 class="mt-3">How?</h4>
        <p>
          Find the right information about a product by scanning the Gfects QR code, barcode, or by even searching for the products by name or barcode number.
        </p>
        <h2></h2>
        <p>What would you like to do?</p>

        <div class="row mx-n2">
          <div class="col-md m-3 px-2">
            <a href="{{ url('/') }}/apps"><button type="button" class="btn btn-primary shadow">Get the app</button></a>
          </div>
          <div class="col-md m-3 px-2">
            <a href="{{ url('/') }}/search"><button type="button" class="btn btn-info shadow">Search for product</button></a>
          </div>
        </div>

      </div>

      <div class="tab-pane fade" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab">
        <h4 class="mt-3"></h4>
        <p>
          G-Page a web and app page for your product, it is a web service that we offer which businesses can use to publish information about their products. A G-page is a page of Gfects' many pages. It is one G-page per product.
        </p>
        <p>
          A G-page is loaded with features, they include product;
          <ul class="">
            <li class="">Images</li>
            <li class="">Videos</li>
            <li class="">Features</li>
            <li class="">Specs</li>
            <li class="">How to use</li>
            <li class="">Buy links</li>
            <li class="">Reviews</li>
            <li class="">And more to come.</li>
          </ul>
        </p>
        <p>
          Creating a G-Page is easy, first, create an account if you do not already have one, fill in the details about your product, download your new Gfects Qr code, print it, test it, when it tests out ok, then publish your page. Add the QR code to your product's packaging design or paste labels with your printed Gfects QR code on your product packing.
        </p>
        <div class="row mx-n2">
          <div class="col-md m-3 px-2">
            <a href="{{ url('/') }}/creator/add-product"><button type="button" class="btn btn-primary shadow">Get started</button></a>
          </div>
          <div class="col-md m-3 px-2">
            <a href="{{ url('/') }}/contact"><button type="button" class="btn btn-info shadow">Contact us</button></a>
          </div>
        </div>

        <p>
          Publishers sorry verified manufacturers and agencies have priority over barcodes and product names in scans and searches.
        </p>



      </div>
    </div>


          
  @endsection

  {{-- bottom for pop ups--}}
  @section('section_content_3')
  	
          <hr class="featurette-divider">
  @endsection

{{-- section end--}}

{{-- footer Start--}}
{{-- footer end --}}

{{-- Scripts start--}}
  @section('ext_scripts')
  
 
  @endsection
{{-- script end--}}

{{--Body  end--}}
