@extends('layouts.layout')

{{-- head Start--}}
  @section('meta_description'){{$meta_description}}@endsection
  @section('title'){{$title}}@endsection
  @section('more_css_style')
  <style>
    .card-body.t1
      {
        min-height:200px;
      }
  </style>
  @endsection
  @section('Google_adsense')
    @includeif('layouts.googleadsense')
  @endsection
{{-- head end--}}


{{-- Body start--}}

{{-- section starts--}}
  {{-- top --}}
  @section('section_content_top')
  @endsection
  
  {{-- Middle --}}
  @section('section_content')
    <div class="container" ng-app="app">
        <div class="py-5 text-center">

            <h2>Creator Account types</h2>
            <p>If you are not interested in creating G-pages, create a <a href="user/register">regular account</a>.
            </p><p class="lead">Creator accounts are accounts that can be used to create and publish <a href="Creator"> G-pages </a>on Gfects. There are three creator account types. They are Publisher, Agency, and Business.</p>
        </div>

        <div class="py-5" ng-controller='creator-ACC-Types-cntrlr'>
            <div></div>
            <div class="p-3 my-3">
                <div class="card-deck mb-3 text-center">

                    <div class="card mb-4 shadow-sm">
                        <div class="card-header text-white bg-info">
                            <h4 class="my-0 font-weight-normal">Publisher</h4>
                        </div>
                        <div class="card-body t1">
                            <p>A Publisher is a user who can publish a G-Page about product or service. This account type is for users who will want to add contents about products or service to the Gfects platform. The user must be 18 years or older to apply.</p>
                        </div>
                        <div class="card-body">
                            <h1 class="card-title pricing-card-title"></h1>
                            <ul class="list-unstyled mt-3 mb-4">
                                <li>Can create Product G-Pages</li>
                                <li>Can manage G-Page</li>
                                <li>Can sell G-Page</li>
                                <li></li>
                            </ul>
                            <a href="register">
                                <button type="button" class="btn btn-lg btn-block btn-info">Get started</button>
                            </a>
                            <p>
                                <br>
                            </p>
                            <!--<a class="text-muted" href="A-Publisher">Read more</a>-->
                        </div>
                    </div>

                    <div class="card mb-4 shadow-sm">
                        <div class="card-header text-white bg-success">
                            <h4 class="my-0 font-weight-normal">Business</h4>
                        </div>
                        <div class="card-body t1">
                            <p>A business, this account type is for businesses who want to publish GPages about their products or services. For the account to have a verified Badge, you must pay for the business verification. </p>
                        </div>
                        <div class="card-body">
                            <h1 class="card-title pricing-card-title"></h1>
                            <ul class="list-unstyled mt-3 mb-4">
                                <li>Can create product G-pages</li>
                                <li>Can manage G-Page</li>
                                <li>Get Qr code for G-page</li>
                                <li>Can get NFC Tags For G-page</li>
                                <li>Can be verified</li>
                            </ul>
                            <a href="register"><button type="button" class="btn btn-lg btn-block btn-outline-success">Get this</button></a>
                            <p>
                                <br>
                            </p>
                            <!--<a class="text-muted" href="A-Business">Read more</a>-->
                        </div>
                    </div>

                    <div class="card mb-4 shadow-sm">
                        <div class="card-header text-white bg-primary">
                            <h4 class="my-0 font-weight-normal">Agency</h4>
                        </div>
                        <div class="card-body t1">
                            <p>An agency, this account type is for an agency that wants to publish GPages for their client's product or service. For the account to have a verified Badge, you must pay for the business verification.</p>
                        </div>
                        <div class="card-body">
                            <h1 class="card-title pricing-card-title"></h1>
                            <ul class="list-unstyled mt-3 mb-4">
                                <li>Can create product G-pages</li>
                                <li>Can manage G-Page</li>
                                <li>Get Qr code for G-page</li>
                                <li>Can get NFC Tags For G-page</li>
                                <li>Can be verified</li>
                            </ul>
                            <a href="register"><button type="button" class="btn btn-lg btn-block btn-primary">Select this</button></a>
                            <p>
                                <br>
                            </p>
                            <!--<a class="text-muted" href="A-Agency">Read more</a>-->
                        </div>
                    </div>

                </div>
                <div>

                </div>
            </div>
        </div>
    </div><!------view div---->
  @endsection

  {{-- bottom for pop ups--}}
  @section('section_content_3')
  @endsection

{{-- section end--}}

{{-- footer Start--}}
{{-- footer end --}}

{{-- Scripts start--}}
  @section('ext_scripts')
    <!-- Custom styles for this template -->
    <script src="https://ajax.googleapis.com/ajax/libs/angularjs/1.7.4/angular.min.js"></script>
    <script src="https://gfects.com/assets/js/angular-contr.js"></script>
  @endsection
{{-- script end--}}

{{--Body  end--}}