<script type="text/javascript">
      $(document).ready(function(){
        //get state list by country id
        $('body').on('change', '#country', function() {
          var id = $("#country").val();
          $.ajax({
              type: "POST",
              url: site_url+"/ajax/get-states",
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              },
              data: {id:id},
              success: function(res){
                 var data = jQuery.parseJSON(res);
                 if(data.status){
                    $("#state").html(data.content);
                 }
              }
          });
        });
        //get state list when company country is selected
        $('body').on('change', '#company_country', function() {
          var id = $("#company_country").val();
          $.ajax({
              type: "POST",
              url: site_url+"/ajax/get-states",
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              },
              data: {id:id},
              success: function(res){
                 var data = jQuery.parseJSON(res);
                 if(data.status){
                    $("#company_state").html(data.content);
                 }
              }
          });
        });
        //get city list when company state is selected
        $('body').on('change', '#company_state', function() {
          var id = $("#company_state").val();
          $.ajax({
              type: "POST",
              url: site_url+"/ajax/get-cities",
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              },
              data: {id:id},
              success: function(res){
                 var data = jQuery.parseJSON(res);
                 if(data.status){
                    $("#company_city").html(data.content);
                 }
              }
          });
        });
        $( "#dob").datepicker({
            dateFormat : 'yy-mm-dd',
            changeMonth : true,
            changeYear : true,
            yearRange: '-100y:c+nn',
            maxDate: '-18Y',
        });
        $(document).on('change', '[type="radio"][name="account_type"]', function() {
          var currentlyValue = $(this).val(); // Get the radio checked value
          if(currentlyValue == 2 || currentlyValue == 3){
            //$(".company_info_section input").prop('required', true);
            $(".company_info_section").css('display','block');
          }else{
            //$(".company_info_section input").removeAttr('required');
            $(".company_info_section").css('display','none');
          }
        });
        $(document).on('change', '[type="radio"][name="same_address_check"]', function() {
          var currentlyValue = $(this).val(); // Get the radio checked value
          if(currentlyValue == 'no'){
            //$(".company_address_section input").prop('required', true);
            $(".company_address_section").css('display','block');
          }else{
            //$(".company_address_section input").removeAttr('required');
            $(".company_address_section").css('display','none');
          }
        });
        //basic details form submit
        $('form[id="basic-details-frm"]').validate({
          rules: {
            first_name: 'required',
            last_name: 'required',
            dob: 'required',
            country: 'required',
            state: 'required',
          },
          messages: {
            first_name: 'Please enter first name.',
            last_name: 'Please enter last name.',
            dob: 'Please enter date of birth.',
            country: 'Please select country',
            state: 'Please select state',
          },
          submitHandler: function(form) {
            //form.submit();
            frm = $('#basic-details-frm');
            $.ajax({
              type: "POST",
              url: site_url+"/account/setting",
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              },
              data: frm.serialize(),
              success: function(res){
                 //$("#loader_img_product_update").css('display','none');
                 var data = jQuery.parseJSON(res);
                 if(data.status){
                    toastr.success(data.msg);
                 }else{
                    toastr.error(data.msg);
                 }
              }
            });
          }
        });
        //about from submit.
        $('form[id="about_frm"]').validate({
          rules: {
            about_txt: 'required',
          },
          messages: {
            about_txt: 'Please enter about.',

          },
          submitHandler: function(form) {
            //form.submit();
            frm = $('#about_frm');
            $.ajax({
              type: "POST",
              url: site_url+"/account/setting",
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              },
              data: frm.serialize(),
              success: function(res){
                 var data = jQuery.parseJSON(res);
                 if(data.status){
                    toastr.success(data.msg);
                 }else{
                    toastr.error(data.msg);
                 }
              }
            });
          }
        });
        //profile image form submit
        $('form[id="profile_image_frm"]').validate({
          rules: {
            profile_pic: 'required',
          },
          messages: {
            profile_pic: 'Please select profile image.',
          },
          submitHandler: function(form) {
            //form.submit();
            //alert("form is submited");
            var image_file = $("#profile_pic").prop("files")[0]; 
            var old_profile_pic =  $("#old_profile_pic").val(); 
            var form_data = new FormData();
            form_data.append("profile_pic",image_file);  
            form_data.append("old_profile_pic",old_profile_pic); 
            form_data.append("action_type",'profile_image'); 
            $("#loader_img_product_update").css('display','block');
            $.ajax({
              type: "POST",
              url: site_url+"/account/setting",
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              },
              data: form_data,
              cache: false,
              processData: false,
              contentType: false,
              success: function(res){
                 $("#loader_img_product_update").css('display','none');
                 var data = jQuery.parseJSON(res);
                 if(data.status){
                    toastr.success(data.msg);
                 }else{
                    toastr.error(data.msg);
                 }
              }
            });
          }
        });
         //change password frm
        $('form[id="password_change_frm"]').validate({
          rules: {
            old_password: 'required',
            password: 'required',
            password_confirmation: 'required', 
          },
          messages: {
            old_password: 'Please enter old password.',
            password: 'Please enter password.',
            password_confirmation: 'please enter confirm password'
          },
          submitHandler: function(form) {
            //form.submit();
            frm = $('#password_change_frm');
            $.ajax({
              type: "POST",
              url: site_url+"/account/setting",
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              },
              data: frm.serialize(),
              success: function(res){
                 //$("#loader_img_product_update").css('display','none');
                 var data = jQuery.parseJSON(res);
                 if(data.status){
                    toastr.success(data.msg);
                 }else{
                    toastr.error(data.msg);
                 }
              }
            });
          }
        });
        //company details form submit
        $('form[id="company_details_frm"]').validate({
          rules: {
            company_name: 'required',
            company_title: 'required',
            company_street: 'required',
            company_zip: 'required',
            company_country: 'required',
            company_state: 'required',
            company_city: 'required',
            phone: 'required',
          },
          messages: {
            company_name: 'Please enter company name.',
            company_title: 'Please enter company title',
            company_street: 'Please enter company street',
            company_zip: 'Please enter zip  code.',
            company_country: 'Please select country.',
            company_state: 'Please select state.',
            company_city: 'Please select city',
            phone: 'Please enetr phone',
          },
          submitHandler: function(form) {
            //form.submit();
            frm = $('#company_details_frm');
            $.ajax({
              type: "POST",
              url: site_url+"/account/setting",
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              },
              data: frm.serialize(),
              success: function(res){
                 //$("#loader_img_product_update").css('display','none');
                 var data = jQuery.parseJSON(res);
                 if(data.status){
                    toastr.success(data.msg);
                 }else{
                    toastr.error(data.msg);
                 }
              }
            });
          }
        });
      });
    </script>