@extends('layouts.layout')

{{-- head Start--}}
  @section('meta_description'){{$meta_description}}@endsection
  @section('title'){{$title}}@endsection
  @section('more_css_style')
  @endsection
  @section('Google_adsense')
    @includeif('layouts.googleadsense')
  @endsection
{{-- head end--}}


{{-- Body start--}}

{{-- section starts--}}
  {{-- top --}}
  @section('section_content_top')
    <style>
    body {
      font-size: .875rem;
    }

    .feather {
      width: 16px;
      height: 16px;
      vertical-align: text-bottom;
    }

    /*
     * Sidebar
     */

    .sidebar {
      position: fixed;
      top: 0;
      bottom: 0;
      left: 0;
      z-index: 100; /* Behind the navbar */
      padding: 48px 0 0; /* Height of navbar */
      box-shadow: inset -1px 0 0 rgba(0, 0, 0, .1);
    }

    .sidebar-sticky {
      position: relative;
      top: 0;
      height: calc(100vh - 48px);
      padding-top: .5rem;
      overflow-x: hidden;
      overflow-y: auto; /* Scrollable contents if viewport is shorter than content. */
    }

    @supports ((position: -webkit-sticky) or (position: sticky)) {
      .sidebar-sticky {
        position: -webkit-sticky;
        position: sticky;
      }
    }

    .sidebar .nav-link {
      font-weight: 500;
      color: #333;
    }

    .sidebar .nav-link .feather {
      margin-right: 4px;
      color: #999;
    }

    .sidebar .nav-link.active {
      color: #007bff;
    }

    .sidebar .nav-link:hover .feather,
    .sidebar .nav-link.active .feather {
      color: inherit;
    }

    .sidebar-heading {
      font-size: .75rem;
      text-transform: uppercase;
    }

    /*
     * Content
     */

    [role="main"] {
      padding-top: 48px; /* Space for fixed navbar */
    }

    /*
     * Navbar
     */

    .form-control-dark {
      color:#fff;
      background-color: rgba(255, 255, 255, .1);
      border-color: rgba(255, 255, 255, .1);
    }

    .form-control-dark:focus {
      border-color: transparent;
      box-shadow: 0 0 0 3px rgba(255, 255, 255, .25);
    }


    .nav-scroller {
      position: relative;
      z-index: 2;
      height: 2.75rem;
      overflow-y: hidden;
    }

    .nav-scroller .nav {
      display: -ms-flexbox;
      display: flex;
      -ms-flex-wrap: nowrap;
      flex-wrap: nowrap;
      padding-bottom: 1rem;
      margin-top: -1px;
      overflow-x: auto;
      text-align: center;
      white-space: nowrap;
      -webkit-overflow-scrolling: touch;
    }

    .nav-scroller .nav-link {
      padding-top: .75rem;
      padding-bottom: .75rem;
      font-size: .875rem;
    }
    /*
     * Utilities
     */

    .border-top { border-top: 1px solid #e5e5e5; }
    .border-bottom { border-bottom: 1px solid #e5e5e5; }

    /*
    *hide angular ex
    */
    [ng\:cloak], [ng-cloak], .ng-cloak {
          display: none;
        }
    </style>
  @endsection
  
  {{-- Middle --}}
  @section('section_content')
    <div>
        <div ng-app="app">
          <div class="nav-scroller py-1 mb-2">
            <nav class="nav nav-masthead justify-content-center">
                <a href="More-service"><button type="button" class="nav-link btn btn-outline-light text-dark font-weight-bold" ng-click="getHTML('create')">Create a page for your product</button></a>
                <a href="Qr-code-generator">
                    <button type="button" class="nav-link btn btn-outline-light text-dark font-weight-bold" ng-click="getHTML('con')">Qr code generator</button>
                </a>
                <a href="Select-package"><button type="button" class="nav-link btn btn-outline-light text-dark font-weight-bold" ng-click="getHTML('pricin')">Pricing</button></a>
                <a href="Dynamic-Pages"><button type="button" class="nav-link btn btn-outline-light text-dark font-weight-bold" ng-click="getHTML('Dynamic')">Dynamic Qr code</button></a>
            </nav>
          </div>
           <div class="container-fluid" ng-controller='qr-code-Gen-cntrlr'>
                <div class="row">
                  <nav class="col-md-2 d-none d-md-block bg-light sidebar">
                    <div class="sidebar-sticky">
                      <ul class="nav flex-column">
                        <li class="nav-item">
                          <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('ulr')">
                            <i class="fas fa-globe-africa"></i>
                            Url <span class="sr-only">(current)</span>
                          </button>
                        </li>
                        <li class="nav-item">
                          <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('con')">
                            <i class="far fa-id-card"></i>
                            Contact/Business card
                          </button>
                        </li>
                        <li class="nav-item">
                          <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('ema')">
                            <i class="far fa-envelope-open"></i>
                            Email
                          </button>
                        </li>
                        <li class="nav-item">
                          <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('sms')">
                           <i class="far fa-comment-alt"></i>
                            SMS
                          </button>
                        </li>
                        <li class="nav-item">
                          <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('wif')">
                            <i class="fas fa-wifi"></i>
                            Wifi
                          </button>
                        </li>
                        <li class="nav-item">
                          <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('cal')">
                            <i class="fas fa-calendar-plus"></i>
                            Calendar/Events
                          </button>
                        </li>
                        <li class="nav-item">
                          <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('geo')">
                            <i class="fas fa-map-marker-alt"></i>
                            Geolocation
                          </button>
                        </li>
                        <li class="nav-item">
                          <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('pho')">
                            <i class="fas fa-phone"></i>
                            Phone number
                          </button>
                        </li>
                        <li class="nav-item">
                          <button type="button" class="nav-link active btn btn-outline-light" ng-click="getHTML('tex')">
                            <i class="far fa-file-alt"></i>
                            Text
                          </button>
                        </li>
                      </ul>
                    </div>
                  </nav>

                  <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-4">
                    <div class="row"><!-----main.row--start-->

                        <div class="col-md-8 order-md-1">
                          <ng-include src="showHTML"></ng-include>
                          <!--div ng-bind="showHTML"></div-->
                        </div>
                        
                        <div class="col-md-4 order-md-2 mb-4 ">
                          <div class="border bg-white">
                            <img class="mb-3 w-100" src="/img/qr-code.png">
                            <div class="p-3" >
                              <p><small class="text-muted">Always test code by scan your new Qr code before downloading it.</small></p>
                              <p>
                                <strong>Image size</strong> 
                                <button type="button" class="btn btn-outline-success">200px</button>
                                <button type="button" class="btn btn-outline-success">300px</button>
                                <button type="button" class="btn btn-outline-success">400px</button>
                              </p>
                              <nav aria-label="breadcrumb">
                                <strong>Image format</strong>
                                <ol class="breadcrumb">
                                  <li class="breadcrumb-item"><a href="#"> JPEG </a></li>
                                  <li class="breadcrumb-item"><a href="#"> PNG </a></li>
                                </ol>
                              </nav>
                            </div>
                          </div>
                        </div>

                        <div class="col-md-8 order-md-3 mb-4" style="margin-top:20px;">
                          <div class="jumbotron p-3 p-md-5 text-white rounded bg-dark">
                            <div class="px-0">
                              <h1 class="display-4 font-italic">Create a page for your product</h1>
                              <p class="lead my-3">Welcome to Gfects, we develop this new service for business to be able to publish an awesome and interactive page for their customers to quickly find useful information about their products.</p>
                              <p class="lead mb-0"><a href="More-service" class="text-white font-weight-bold">Continue reading...</a></p>
                            </div>
                          </div>
                        </div>

                      </div><!-----main.row--end-->

                    

                    
                    
                  </main>
                </div>
              </div>
        </div>
        <hr class="featurette-divider">
    </div>
  @endsection

  {{-- bottom for pop ups--}}
  @section('section_content_3')
  @endsection

{{-- section end--}}

{{-- footer Start--}}
{{-- footer end --}}

{{-- Scripts start--}}
  @section('ext_scripts')
    <!-- Custom styles for this template -->
    <script src="https://ajax.googleapis.com/ajax/libs/angularjs/1.7.4/angular.min.js"></script>
    <script src="js/angular-contr.js"></script>
  @endsection
{{-- script end--}}

{{--Body  end--}}
