@extends('layouts.layout')

{{-- head Start--}}
  @section('meta_description'){{$meta_description}}@endsection
  @section('title'){{$title}}@endsection
  @section('more_css_style')
      <style type="text/css">

    body{margin-top:20px;
    background:#eee;
    }

    .btn {
        margin-bottom: 5px;
    }

    .grid {
        position: relative;
        width: 100%;
        background: #fff;
        color: #666666;
        border-radius: 2px;
        margin-bottom: 25px;
        box-shadow: 0px 1px 4px rgba(0, 0, 0, 0.1);
    }

    .grid .grid-body {
        padding: 15px 20px 15px 20px;
        font-size: 0.9em;
        line-height: 1.9em;
    }

    .search table tr td.rate {
        color: #f39c12;
        line-height: 50px;
    }

    .search table tr:hover {
        cursor: pointer;
    }

    .search table tr td.image {
      width: 50px;
    }

    .search table tr td img {
      width: 50px;
      height: 50px;
    }

    .search table tr td.rate {
      color: #f39c12;
      line-height: 50px;
    }

    .search table tr td.price {
      font-size: 1.5em;
      line-height: 50px;
    }

    .search #price1,
    .search #price2 {
      display: inline;
      font-weight: 600;
    }
  </style>
  @endsection
  @section('Google_adsense')
    @includeif('layouts.googleadsense')
  @endsection
{{-- head end--}}


{{-- Body start--}}

{{-- section starts--}}
  {{-- top --}}
  @section('section_content_top')
  @endsection

  {{-- Middle --}}
  @section('section_content')
    <hr class="featurette-divider">
    <!-- BEGIN SEARCH RESULT -->
    <div class="col-md-12">
      <div class="grid search">
        <div class="grid-body">
          <div class="">
              <h2><i class="fa fa-file-o"></i> Result</h2>
              <hr>
              <!-- BEGIN SEARCH INPUT -->
              <form action="{{url('search')}}" method="post">
              <div class="input-group">
                      @csrf
                      <input type="text" class="form-control" name="q" value="{{$query}}">
                      <span class="input-group-btn">
                  <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i></button>
                </span>
              </div>
              </form>

              <!-- END SEARCH INPUT -->
              <p>Showing all results matching "{{$query}}"</p>

              <div class="padding"></div>

              <div class="row">
                <!-- BEGIN ORDER RESULT -->
                <div class="col-sm-6">
                </div>
                <!-- END ORDER RESULT -->

                <div class="col-md-6 text-right">
                  <div class="btn-group">
                    <button type="button" class="btn btn-default active"><i class="fa fa-list"></i></button>
                    <button type="button" class="btn btn-default"><i class="fa fa-th"></i></button>
                  </div>
                </div>
              </div>

              <!-- BEGIN TABLE RESULT -->
              <!-- Gpages start -->
              <?php
                  use Hashids\Hashids;
                  $hashids = new Hashids();

              ?>
                            <div class="row">
                                @if(count($gpages_list))
                                    @foreach($gpages_list as $key=>$value)
                                <?php
                                                $image = json_decode($value->image);
                                                $this->product_model = new \App\Product;
                                                $total_likes = $this->product_model->get_total_likes_by_page_id($value->id);
                                                $total_unlikes = $this->product_model->get_total_dislikes_by_page_id($value->id);
                                                $total_comments = $this->product_model->get_total_comments_by_page_id($value->id);
                                                $total_fllowers = $this->product_model->get_total_fllowers_by_page_id($value->id);
                                                $page_name = preg_replace('/[^A-Za-z0-9]/', '-', $value->name);
                                                $page_name = preg_replace('/-+/', '-', $page_name);
                                                if(Auth::check()){
                                                  $like_status = $this->product_model->page_like_status_by_user(Auth::user()->id,$value->id);
                                                }else{
                                                  $like_status = 0;
                                                }


                                              ?>


                                <div class="card mb-4 shadow-sm" style="margin-left:auto; margin-right:auto; max-width: 345px;">
                                    @if(isset($image[0]->url))
                                  <img class="bd-placeholder-img card-img-top" src="{{asset('/public/'.$image[0]->url)}}" width="100%" height="225"  role="img" aria-label="Placeholder: Thumbnail">
                                  @else
                                        <img class="bd-placeholder-img card-img-top" src="{{asset('/public/')}}" width="100%" height="225"  role="img" aria-label="Placeholder: Thumbnail">

                                    @endif
                                  <div class="card-body">
                                    <p class="card-text"><a href="{{url('product/tv1/'.strtolower($page_name).'/'.$hashids->encode($value->id,$value->id+11,$value->id+22,$value->id+33,$value->id+44,$value->id+55))}}" class="stretched-link">{{$value->name}}</a></p>
                                    <div class="d-flex justify-content-between align-items-center">
                                      <div class="btn-group">
                                        <a href="{{url('user/'.$value->user_id.'/'.$value->username)}}">
                                          <img src="{{$value->profile_picture}}" style="border-radius: 50%;height: 30px;max-width: 25px;"/> {{$value->username}}
                                        </a>
                                      </div>
                                      <small class="text-muted"> <i class="fas fa-arrow-up font-weight-bold"></i>  {{$total_likes}}</small>
                                    </div>
                                  </div>
                                </div>
                                    @endforeach
                                    @endif
                            </div>
                            {{-- Get domain name --}}
                            <?php
                            // This is PHP function to convert a user-supplied URL to just the domain name,
                            // which I use as the link text.
                            // Remember you still need to use htmlspecialchars() or similar to escape the
                            // result.
                            function url_to_domain($url)
                            {
                                $host = @parse_url($url, PHP_URL_HOST);
                                // If the URL can't be parsed, use the original URL
                                // Change to "return false" if you don't want that
                                if (!$host)
                                    $host = $url;
                                // The "www." prefix isn't really needed if you're just using
                                // this to display the domain to the user
                                if (substr($host, 0, 4) == "www.")
                                    $host = substr($host, 4);
                                // You might also want to limit the length if screen space is limited
                                if (strlen($host) > 50)
                                    $host = substr($host, 0, 47) . '...';
                                return $host;
                            }
                            ?>


                            <!-- Gpages end -->
              <!-- END TABLE RESULT -->

              <!-- BEGIN PAGINATION -->

              <div class="row">
                  <div class="col-md-2 col-md-offset-5" style="margin: auto;">
                      {{$gpages_list->links()}}

                  </div>
              </div>

              <nav aria-label="Page navigation example">

              </nav>
              <!-- END PAGINATION -->
            </div>
        </div>
      </div>
    </div>
    <!-- END SEARCH RESULT -->
    <hr class="featurette-divider">
  @endsection

  {{-- bottom for pop ups--}}
  @section('section_content_3')
  @endsection

{{-- section end--}}

{{-- footer Start--}}
{{-- footer end --}}

{{-- Scripts start--}}
  @section('ext_scripts')
  @endsection
{{-- script end--}}

{{--Body  end--}}
