@extends('layouts.landing')
@section('section_content')
    <style>
        .stack-nav li a{background: transparent; text-align: left; color:#fff}
        .stack-nav li a{position: relative}
        .stack-nav li a .badge{position: absolute; right:15px; top:7px}
        .trigger-nav li a {position: relative}
        .trigger-nav li a i.flag{position: absolute; top:-5px; right:-20px; background: #f05a28; padding: 2px; color:#fff; border-radius: 3px; width: 16px; height: 16px; text-align: center; line-height: 12px}
        .sidepopup.on{left:0}
        .login-box{ background: linear-gradient(90deg,#2e6184, #5182a0); border-radius: 6px; padding: 20px; margin-top: 120px; }
        .error{color:#641818;}
    </style>
    <div class="container-fluid" style="margin-bottom: 50px;">
        <div class="row">
            <div class="col-md-4" style='float:none; margin: auto'>
                <div class="login-box">
                    <a href="{{url('/')}}" class=" text-center" style="display: block; line-height: 35px; padding-left: 15px"><img src="{{asset('/public/assets_web/img/logo_original_sm.png')}}" height="28" alt="logo"></a>
                    <div class="content">
                        <p class="lead text-center" style="color:#fff">Create your account</p>
                        <form class="form-auth-small" action="{{url('user/register')}}" method="post" id="user_register_frm">
                            <div class="border border-white row mx-auto my-3" style=" max-width: 180px; ">
                                <h5 class="text-white text-left pl-1 mt-1">Continue with</h5>
                                <div class=" p-3">
                                    <a href="{{url('/')}}/user/auth/google" class="btn btn-sm shadow" style="background: #da3d29; color:#fff"><i class="fab fa-google"></i>&nbsp;</a>
                                    <a href="{{url('/')}}/user/auth/linkedin" class="btn btn-sm shadow" style="background: #0677b0; color:#fff"><i class="fab fa-linkedin"></i>&nbsp;</a>
                                    <a href="{{url('/')}}/user/auth/facebook" class="btn btn-sm shadow" style="background: #3b5998; color:#fff"><i class="fab fa-facebook"></i>&nbsp;</a>
                                </div>
                            </div>

                            @csrf
                            <div class="form-group">
                                <label  class="control-label ">First Name</label>
                                <input type="text" class="form-control" name="first_name"  value="{{old('first_name')}}" required>
                                <br>
                                @if ($errors->has('first_name'))
                                    <span class="error" role="alert">
                          <strong>{{ $errors->first('first_name') }}</strong>
                      </span>
                                @endif
                            </div>
                            <div class="form-group">
                                <label  class="control-label">Last Name</label>
                                <input type="text" class="form-control" name="last_name"  value="{{old('last_name')}}" required>
                                <br>
                                @if ($errors->has('last_name'))
                                    <span class="error" role="alert">
                          <strong>{{ $errors->first('last_name') }}</strong>
                      </span>
                                @endif
                            </div>
                            <div class="form-group">
                                <label  class="control-label ">DOB</label>
                                <input type="date" class="form-control" name="dob"  value="{{old('dob')}}" required>
                                <br>
                                @if ($errors->has('dob'))
                                    <span class="error" role="alert">
                          <strong>{{ $errors->first('dob') }}</strong>
                      </span>
                                @endif
                            </div>
                            <div class="form-group">
                                <label class="control-label ">Email</label>
                                <input type="email" class="form-control" name="email"  value="{{old('email')}}" required>
                                <br>
                                @if ($errors->has('email'))
                                    <span class="error" role="alert">
                          <strong>{{ $errors->first('email') }}</strong>
                      </span>
                                @endif
                            </div>
                            <div class="form-group">
                                <label class="control-label ">Username</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">@</span>
                                    </div>
                                    <input type="text" class="form-control " id="username" name="username" value="{{old('username')}}" placeholder="Username" required>
                                    <br>
                                    @if ($errors->has('username'))
                                        <span class="error" role="alert">
                              <strong>{{ $errors->first('username') }}</strong>
                          </span>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label ">Country</label>
                                <select class="form-control" name="country" id="country" required autofocus>
                                    <option value="">Select Country</option>
                                    @if(count($country)>0)
                                        @foreach($country as $key=>$value)
                                            <option value="{{$value->id}}">{{$value->name}}</option>
                                        @endforeach
                                    @endif
                                </select>
                                <br>
                                @if ($errors->has('country'))
                                    <span class="error" role="alert">
                          <strong>{{ $errors->first('country') }}</strong>
                      </span>
                                @endif
                            </div>
                            <div class="form-group">
                                <label class="control-label ">State</label>
                                <select class="form-control" name="state" id="state" required autofocus>
                                </select>
                                <br>
                                @if ($errors->has('state'))
                                    <span class="error" role="alert">
                          <strong>{{ $errors->first('state') }}</strong>
                      </span>
                                @endif
                            </div>
                            <div class="form-group">
                                <label  class="control-label ">Password</label>
                                <input type="password" class="form-control" value="{{ old('password') }}" name="password" id="password" required>
                                @if ($errors->has('password'))
                                    <span class="error" role="alert">
                          <strong>{{ $errors->first('password') }}</strong>
                      </span>
                                @endif
                            </div>
                            <div class="form-group">
                                <label  class="control-label ">Confirm Password</label>
                                <input type="password" class="form-control" value="{{ old('password_confirmation') }}" name="password_confirmation" id="password_confirmation" required>
                                @if ($errors->has('password_confirmation'))
                                    <span class="error" role="alert">
                          <strong>{{ $errors->first('password_confirmation') }}</strong>
                      </span>
                                @endif
                            </div>
                            <hr class="mb-4">
                            
                            <div class="mb-3">
                              <small class="text-white">
                                  By clicking continue, you agree to our 
                                  <a href="terms"  class="text-warning" title="gfects terms of use"> Terms of use</a>
                                  and
                                  <a href="privacy"  class="text-warning" title="gfects privacy">Privacy Policy</a>.
                              </small>
                            </div>
                            <hr class="mb-4">
                            
                            <button type="submit" class="btn btn-primary btn-lg btn-block">SIGNUP</button>
                            <div class="bottom text-center">
                            </div>
                        </form>
                    </div>
                </div>
                <br>
                <br>
                <div class="text-center"><a href="{{url('/Account')}}" style="color:#2e6184; font-size: 18px; font-size: 800;">Already have an account?</a></div>
            </div>
        </div>
    </div>
   
@endsection


{{-- footer Start--}}
{{-- footer end --}}

{{-- Scripts start--}}

  @section('ext_scripts')
   <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.1/dist/jquery.validate.js"></script>
    <script type="text/javascript">
        site_url ='https://gfects.com';
        $(document).ready(function(){
            $( "#user_register_frm" ).validate({
                rules: {
                    first_name: {
                        required: true
                    },
                    last_name: {
                        required: true
                    },
                    country: {
                        required: true
                    },
                    state: {
                        required: true
                    },
                    dob: {
                        required: true
                    },
                    email: {
                        required: true,
                        email: true,
                        email_exists: true,
                    },
                    username: {
                        required: true,
                        username_exist: true,
                    },
                    password: {
                        required: true,
                        minlength: 6,
                    },
                    password_confirmation: {
                        required: true,
                        equalTo: "#password",
                    },
                },
                messages: {
                    first_name: "Please enter first name",
                    last_name: "Please enter last name",
                    country: "Please enter country name",
                    state: "Please enter state name",
                    dob: "Please enter date of birth",
                    email: {
                        required: 'Please enter email address',
                        email: 'Please enter valid email address',
                    },
                    username:{
                        required: 'Please enter user name',
                    } ,
                    password: {
                        required:"Please enter password",
                        minlength:"password length should be minimum 6 character or numbers",
                    },
                    password_confirmation: {
                        required:"Please retype new password",
                        equalTo: "Confirm password does not match"
                    },
                }
            });
            //get state list by country id
            $('body').on('change', '#country', function() {
                var id = $("#country").val();
                $.ajax({
                    type: "POST",
                    url: site_url+"/ajax/get-states",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {id:id,
                        "_token": "{{ csrf_token() }}",
                    },
                    success: function(res){
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            $("#state").html(data.content);
                        }
                    }
                });
            });
            //custum js validation event add to form validation
            jQuery.validator.addMethod("username_exist", function(value, element) {
                var isSuccess = true;
                $.ajax({
                    type: "POST",
                    async: false,
                    url: site_url+"/ajax/check-username",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {username:value,
                        "_token": "{{ csrf_token() }}",

                    },
                    success: function(res){
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            isSuccess = false;
                        }
                    }
                });
                return isSuccess;
            }, 'This username is unavailable.');
            //custom js for email check
            jQuery.validator.addMethod("email_exists", function(value, element) {
                var isSuccess = true;
                $.ajax({
                    type: "POST",
                    async: false,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: site_url+"/ajax/check-email",
                    data: {email:value},
                    success: function(res){
                        var data = jQuery.parseJSON(res);
                        if(data.status){
                            isSuccess = false;
                        }
                    }
                });
                return isSuccess;
            }, 'Email is already used.');
        });
    </script>
  @endsection
{{-- script end--}}

{{--Body  end--}}
