<?php
    namespace App\Helpers;
    
    use DateTime;
    Class Common_func{
    	public static function time_ago($datetime, $full = false) {
            $now = new DateTime;
            $ago = new DateTime($datetime);
            $diff = $now->diff($ago);

            $diff->w = floor($diff->d / 7);
            $diff->d -= $diff->w * 7;

            $string = array(
                'y' => 'Year',
                'm' => 'Month',
                'w' => 'Week',
                'd' => 'Day',
                'h' => 'Hour',
                'i' => 'Minute',
                's' => 'Second',
            );
            foreach ($string as $k => &$v) {
                if ($diff->$k) {
                    $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
                } else {
                    unset($string[$k]);
                }
            }

            if (!$full) $string = array_slice($string, 0, 1);
            return $string ? implode(', ', $string) . ' Ago' : 'Just now';
        }
        public static function time_ago_int($datetime, $full = false) {
            $now = new DateTime;
            $ago = new DateTime($datetime);
            $diff = $now->diff($ago);

            $diff->w = floor($diff->d / 7);
            $diff->d -= $diff->w * 7;

            $string = array(
                'y' => 'Year',
                'm' => 'Month',
                'w' => 'Week',
                'd' => 'Day',
                'h' => 'Hour',
                'i' => 'Minute',
                's' => 'Second',
            );
            foreach ($string as $k => &$v) {
                if ($diff->$k) {
                    $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
                } else {
                    unset($string[$k]);
                }
            }

            if (!$full) $string = array_slice($string, 0, 1);
            return $string ? implode(', ', $string) . ' ' : 'Just now';
        }
    }
?>